"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiGatewayV2HttpApiMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const ApiGatewayNamespace = "AWS/ApiGateway";
class ApiGatewayV2HttpApiMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.fillTpsWithZeroes = props.fillTpsWithZeroes ?? true;
        this.rateComputationMethod =
            props.rateComputationMethod ?? common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            ApiId: props.api.httpApiId,
            Stage: props.apiStage ?? "$default",
            ...(props.apiMethod && { Method: props.apiMethod }),
            ...(props.apiResource && { Resource: props.apiResource }),
        };
    }
    /**
     * @deprecated use metricInvocationRate
     */
    metricTps() {
        return this.metricFactory.toRate(this.metricInvocationCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests");
    }
    metricInvocationRate() {
        return this.metricFactory.toRate(this.metricInvocationCount(), this.rateComputationMethod, false, "requests");
    }
    metricInvocationCount() {
        return this.metricFactory.createMetric("Count", common_1.MetricStatistic.SUM, "Invocations", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric4xxCount() {
        return this.metricFactory.createMetric("4xx", common_1.MetricStatistic.SUM, "4xx", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric4xxRate() {
        const metric = this.metric4xxCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "errors");
    }
    metric5xxCount() {
        return this.metricFactory.createMetric("5xx", common_1.MetricStatistic.SUM, "5xx", this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metric5xxRate() {
        const metric = this.metric5xxCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP50InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P50);
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP90InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P90);
    }
    /**
     * @deprecated use metricLatencyInMillis instead
     */
    metricLatencyP99InMillis() {
        return this.metricLatencyInMillis(common_1.LatencyType.P99);
    }
    /**
     * @deprecated use metricIntegrationLatencyInMillis instead
     */
    metricIntegrationLatencyP50InMillis() {
        return this.metricIntegrationLatencyInMillis(common_1.LatencyType.P50);
    }
    /**
     * @deprecated use metricIntegrationLatencyInMillis instead
     */
    metricIntegrationLatencyP90InMillis() {
        return this.metricIntegrationLatencyInMillis(common_1.LatencyType.P90);
    }
    /**
     * @deprecated use metricIntegrationLatencyInMillis instead
     */
    metricIntegrationLatencyP99InMillis() {
        return this.metricIntegrationLatencyInMillis(common_1.LatencyType.P99);
    }
    metricIntegrationLatencyInMillis(latencyType) {
        const label = common_1.getLatencyTypeLabel(latencyType);
        return this.metricFactory.createMetric("IntegrationLatency", common_1.getLatencyTypeStatistic(latencyType), label, this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
    metricLatencyInMillis(latencyType) {
        const label = common_1.getLatencyTypeLabel(latencyType);
        return this.metricFactory.createMetric("Latency", common_1.getLatencyTypeStatistic(latencyType), label, this.dimensionsMap, undefined, ApiGatewayNamespace);
    }
}
exports.ApiGatewayV2HttpApiMetricFactory = ApiGatewayV2HttpApiMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
ApiGatewayV2HttpApiMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.ApiGatewayV2HttpApiMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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