"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppSyncMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/AppSync";
class AppSyncMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.fillTpsWithZeroes = props.fillTpsWithZeroes ?? true;
        this.rateComputationMethod =
            props.rateComputationMethod ?? common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            GraphQLAPIId: props.api.apiId,
        };
    }
    /**
     * @deprecated use metricRequestRate
     */
    metricTps() {
        return this.metricFactory.toRate(this.metricRequestCount(), common_1.RateComputationMethod.PER_SECOND, true, "requests", this.fillTpsWithZeroes);
    }
    metricRequestRate() {
        return this.metricFactory.toRate(this.metricRequestCount(), this.rateComputationMethod, true, "requests", this.fillTpsWithZeroes);
    }
    metricRequestCount() {
        return this.metricFactory.createMetric("Latency", common_1.MetricStatistic.N, "Requests", this.dimensionsMap, undefined, Namespace);
    }
    metricLatencyP50InMillis() {
        return this.metricFactory.createMetric("Latency", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricLatencyP90InMillis() {
        return this.metricFactory.createMetric("Latency", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricLatencyP99InMillis() {
        return this.metricFactory.createMetric("Latency", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metric4XXErrorCount() {
        return this.metricFactory.createMetric("4XXError", common_1.MetricStatistic.SUM, "4XX Error", this.dimensionsMap, undefined, Namespace);
    }
    metric4XXErrorRate() {
        const metric = this.metric4XXErrorCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "errors");
    }
    metric5XXFaultCount() {
        return this.metricFactory.createMetric("5XXError", common_1.MetricStatistic.SUM, "5XX Fault", this.dimensionsMap, undefined, Namespace);
    }
    metric5XXFaultRate() {
        const metric = this.metric5XXFaultCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
}
exports.AppSyncMetricFactory = AppSyncMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
AppSyncMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.AppSyncMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXBwU3luY01ldHJpY0ZhY3RvcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJBcHBTeW5jTWV0cmljRmFjdG9yeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBLHlDQUlzQjtBQUV0QixNQUFNLFNBQVMsR0FBRyxhQUFhLENBQUM7QUFtQmhDLE1BQWEsb0JBQW9CO0lBTS9CLFlBQVksYUFBNEIsRUFBRSxLQUFnQztRQUN4RSxJQUFJLENBQUMsYUFBYSxHQUFHLGFBQWEsQ0FBQztRQUNuQyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsS0FBSyxDQUFDLGlCQUFpQixJQUFJLElBQUksQ0FBQztRQUN6RCxJQUFJLENBQUMscUJBQXFCO1lBQ3hCLEtBQUssQ0FBQyxxQkFBcUIsSUFBSSw4QkFBcUIsQ0FBQyxPQUFPLENBQUM7UUFDL0QsSUFBSSxDQUFDLGFBQWEsR0FBRztZQUNuQixZQUFZLEVBQUUsS0FBSyxDQUFDLEdBQUcsQ0FBQyxLQUFLO1NBQzlCLENBQUM7SUFDSixDQUFDO0lBRUQ7O09BRUc7SUFDSCxTQUFTO1FBQ1AsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FDOUIsSUFBSSxDQUFDLGtCQUFrQixFQUFFLEVBQ3pCLDhCQUFxQixDQUFDLFVBQVUsRUFDaEMsSUFBSSxFQUNKLFVBQVUsRUFDVixJQUFJLENBQUMsaUJBQWlCLENBQ3ZCLENBQUM7SUFDSixDQUFDO0lBRUQsaUJBQWlCO1FBQ2YsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FDOUIsSUFBSSxDQUFDLGtCQUFrQixFQUFFLEVBQ3pCLElBQUksQ0FBQyxxQkFBcUIsRUFDMUIsSUFBSSxFQUNKLFVBQVUsRUFDVixJQUFJLENBQUMsaUJBQWlCLENBQ3ZCLENBQUM7SUFDSixDQUFDO0lBRUQsa0JBQWtCO1FBQ2hCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQ3BDLFNBQVMsRUFDVCx3QkFBZSxDQUFDLENBQUMsRUFDakIsVUFBVSxFQUNWLElBQUksQ0FBQyxhQUFhLEVBQ2xCLFNBQVMsRUFDVCxTQUFTLENBQ1YsQ0FBQztJQUNKLENBQUM7SUFFRCx3QkFBd0I7UUFDdEIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FDcEMsU0FBUyxFQUNULHdCQUFlLENBQUMsR0FBRyxFQUNuQixLQUFLLEVBQ0wsSUFBSSxDQUFDLGFBQWEsRUFDbEIsU0FBUyxFQUNULFNBQVMsQ0FDVixDQUFDO0lBQ0osQ0FBQztJQUVELHdCQUF3QjtRQUN0QixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUNwQyxTQUFTLEVBQ1Qsd0JBQWUsQ0FBQyxHQUFHLEVBQ25CLEtBQUssRUFDTCxJQUFJLENBQUMsYUFBYSxFQUNsQixTQUFTLEVBQ1QsU0FBUyxDQUNWLENBQUM7SUFDSixDQUFDO0lBRUQsd0JBQXdCO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQ3BDLFNBQVMsRUFDVCx3QkFBZSxDQUFDLEdBQUcsRUFDbkIsS0FBSyxFQUNMLElBQUksQ0FBQyxhQUFhLEVBQ2xCLFNBQVMsRUFDVCxTQUFTLENBQ1YsQ0FBQztJQUNKLENBQUM7SUFFRCxtQkFBbUI7UUFDakIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FDcEMsVUFBVSxFQUNWLHdCQUFlLENBQUMsR0FBRyxFQUNuQixXQUFXLEVBQ1gsSUFBSSxDQUFDLGFBQWEsRUFDbEIsU0FBUyxFQUNULFNBQVMsQ0FDVixDQUFDO0lBQ0osQ0FBQztJQUVELGtCQUFrQjtRQUNoQixNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztRQUMxQyxPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsTUFBTSxDQUM5QixNQUFNLEVBQ04sSUFBSSxDQUFDLHFCQUFxQixFQUMxQixLQUFLLEVBQ0wsUUFBUSxDQUNULENBQUM7SUFDSixDQUFDO0lBRUQsbUJBQW1CO1FBQ2pCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxZQUFZLENBQ3BDLFVBQVUsRUFDVix3QkFBZSxDQUFDLEdBQUcsRUFDbkIsV0FBVyxFQUNYLElBQUksQ0FBQyxhQUFhLEVBQ2xCLFNBQVMsRUFDVCxTQUFTLENBQ1YsQ0FBQztJQUNKLENBQUM7SUFFRCxrQkFBa0I7UUFDaEIsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLG1CQUFtQixFQUFFLENBQUM7UUFDMUMsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FDOUIsTUFBTSxFQUNOLElBQUksQ0FBQyxxQkFBcUIsRUFDMUIsS0FBSyxFQUNMLFFBQVEsQ0FDVCxDQUFDO0lBQ0osQ0FBQzs7QUEzSEgsb0RBNEhDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgR3JhcGhxbEFwaSB9IGZyb20gXCJAYXdzLWNkay9hd3MtYXBwc3luYy1hbHBoYVwiO1xuaW1wb3J0IHsgRGltZW5zaW9uc01hcCB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaFwiO1xuXG5pbXBvcnQge1xuICBNZXRyaWNGYWN0b3J5LFxuICBNZXRyaWNTdGF0aXN0aWMsXG4gIFJhdGVDb21wdXRhdGlvbk1ldGhvZCxcbn0gZnJvbSBcIi4uLy4uL2NvbW1vblwiO1xuXG5jb25zdCBOYW1lc3BhY2UgPSBcIkFXUy9BcHBTeW5jXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXBwU3luY01ldHJpY0ZhY3RvcnlQcm9wcyB7XG4gIC8qKlxuICAgKiB0aGUgR3JhcGhRTCBBUEkgdG8gbW9uaXRvclxuICAgKi9cbiAgcmVhZG9ubHkgYXBpOiBHcmFwaHFsQXBpO1xuICAvKipcbiAgICogd2hldGhlciB0aGUgVFBTIHNob3VsZCBiZSBmaWxsZWQgd2l0aCB6ZXJvZXNcbiAgICogQGRlZmF1bHQgLSB0cnVlXG4gICAqL1xuICByZWFkb25seSBmaWxsVHBzV2l0aFplcm9lcz86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBtZXRob2QgdG8gY29tcHV0ZSBUUFNcbiAgICogQGRlZmF1bHQgLSBhdmVyYWdlXG4gICAqL1xuICByZWFkb25seSByYXRlQ29tcHV0YXRpb25NZXRob2Q/OiBSYXRlQ29tcHV0YXRpb25NZXRob2Q7XG59XG5cbmV4cG9ydCBjbGFzcyBBcHBTeW5jTWV0cmljRmFjdG9yeSB7XG4gIHByb3RlY3RlZCByZWFkb25seSBtZXRyaWNGYWN0b3J5OiBNZXRyaWNGYWN0b3J5O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgZmlsbFRwc1dpdGhaZXJvZXM6IGJvb2xlYW47XG4gIHByb3RlY3RlZCByZWFkb25seSByYXRlQ29tcHV0YXRpb25NZXRob2Q6IFJhdGVDb21wdXRhdGlvbk1ldGhvZDtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGRpbWVuc2lvbnNNYXA6IERpbWVuc2lvbnNNYXA7XG5cbiAgY29uc3RydWN0b3IobWV0cmljRmFjdG9yeTogTWV0cmljRmFjdG9yeSwgcHJvcHM6IEFwcFN5bmNNZXRyaWNGYWN0b3J5UHJvcHMpIHtcbiAgICB0aGlzLm1ldHJpY0ZhY3RvcnkgPSBtZXRyaWNGYWN0b3J5O1xuICAgIHRoaXMuZmlsbFRwc1dpdGhaZXJvZXMgPSBwcm9wcy5maWxsVHBzV2l0aFplcm9lcyA/PyB0cnVlO1xuICAgIHRoaXMucmF0ZUNvbXB1dGF0aW9uTWV0aG9kID1cbiAgICAgIHByb3BzLnJhdGVDb21wdXRhdGlvbk1ldGhvZCA/PyBSYXRlQ29tcHV0YXRpb25NZXRob2QuQVZFUkFHRTtcbiAgICB0aGlzLmRpbWVuc2lvbnNNYXAgPSB7XG4gICAgICBHcmFwaFFMQVBJSWQ6IHByb3BzLmFwaS5hcGlJZCxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIEBkZXByZWNhdGVkIHVzZSBtZXRyaWNSZXF1ZXN0UmF0ZVxuICAgKi9cbiAgbWV0cmljVHBzKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkudG9SYXRlKFxuICAgICAgdGhpcy5tZXRyaWNSZXF1ZXN0Q291bnQoKSxcbiAgICAgIFJhdGVDb21wdXRhdGlvbk1ldGhvZC5QRVJfU0VDT05ELFxuICAgICAgdHJ1ZSxcbiAgICAgIFwicmVxdWVzdHNcIixcbiAgICAgIHRoaXMuZmlsbFRwc1dpdGhaZXJvZXNcbiAgICApO1xuICB9XG5cbiAgbWV0cmljUmVxdWVzdFJhdGUoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS50b1JhdGUoXG4gICAgICB0aGlzLm1ldHJpY1JlcXVlc3RDb3VudCgpLFxuICAgICAgdGhpcy5yYXRlQ29tcHV0YXRpb25NZXRob2QsXG4gICAgICB0cnVlLFxuICAgICAgXCJyZXF1ZXN0c1wiLFxuICAgICAgdGhpcy5maWxsVHBzV2l0aFplcm9lc1xuICAgICk7XG4gIH1cblxuICBtZXRyaWNSZXF1ZXN0Q291bnQoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5jcmVhdGVNZXRyaWMoXG4gICAgICBcIkxhdGVuY3lcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5OLFxuICAgICAgXCJSZXF1ZXN0c1wiLFxuICAgICAgdGhpcy5kaW1lbnNpb25zTWFwLFxuICAgICAgdW5kZWZpbmVkLFxuICAgICAgTmFtZXNwYWNlXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpY0xhdGVuY3lQNTBJbk1pbGxpcygpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmNyZWF0ZU1ldHJpYyhcbiAgICAgIFwiTGF0ZW5jeVwiLFxuICAgICAgTWV0cmljU3RhdGlzdGljLlA1MCxcbiAgICAgIFwiUDUwXCIsXG4gICAgICB0aGlzLmRpbWVuc2lvbnNNYXAsXG4gICAgICB1bmRlZmluZWQsXG4gICAgICBOYW1lc3BhY2VcbiAgICApO1xuICB9XG5cbiAgbWV0cmljTGF0ZW5jeVA5MEluTWlsbGlzKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkuY3JlYXRlTWV0cmljKFxuICAgICAgXCJMYXRlbmN5XCIsXG4gICAgICBNZXRyaWNTdGF0aXN0aWMuUDkwLFxuICAgICAgXCJQOTBcIixcbiAgICAgIHRoaXMuZGltZW5zaW9uc01hcCxcbiAgICAgIHVuZGVmaW5lZCxcbiAgICAgIE5hbWVzcGFjZVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNMYXRlbmN5UDk5SW5NaWxsaXMoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5jcmVhdGVNZXRyaWMoXG4gICAgICBcIkxhdGVuY3lcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5QOTksXG4gICAgICBcIlA5OVwiLFxuICAgICAgdGhpcy5kaW1lbnNpb25zTWFwLFxuICAgICAgdW5kZWZpbmVkLFxuICAgICAgTmFtZXNwYWNlXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpYzRYWEVycm9yQ291bnQoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5jcmVhdGVNZXRyaWMoXG4gICAgICBcIjRYWEVycm9yXCIsXG4gICAgICBNZXRyaWNTdGF0aXN0aWMuU1VNLFxuICAgICAgXCI0WFggRXJyb3JcIixcbiAgICAgIHRoaXMuZGltZW5zaW9uc01hcCxcbiAgICAgIHVuZGVmaW5lZCxcbiAgICAgIE5hbWVzcGFjZVxuICAgICk7XG4gIH1cblxuICBtZXRyaWM0WFhFcnJvclJhdGUoKSB7XG4gICAgY29uc3QgbWV0cmljID0gdGhpcy5tZXRyaWM0WFhFcnJvckNvdW50KCk7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS50b1JhdGUoXG4gICAgICBtZXRyaWMsXG4gICAgICB0aGlzLnJhdGVDb21wdXRhdGlvbk1ldGhvZCxcbiAgICAgIGZhbHNlLFxuICAgICAgXCJlcnJvcnNcIlxuICAgICk7XG4gIH1cblxuICBtZXRyaWM1WFhGYXVsdENvdW50KCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkuY3JlYXRlTWV0cmljKFxuICAgICAgXCI1WFhFcnJvclwiLFxuICAgICAgTWV0cmljU3RhdGlzdGljLlNVTSxcbiAgICAgIFwiNVhYIEZhdWx0XCIsXG4gICAgICB0aGlzLmRpbWVuc2lvbnNNYXAsXG4gICAgICB1bmRlZmluZWQsXG4gICAgICBOYW1lc3BhY2VcbiAgICApO1xuICB9XG5cbiAgbWV0cmljNVhYRmF1bHRSYXRlKCkge1xuICAgIGNvbnN0IG1ldHJpYyA9IHRoaXMubWV0cmljNVhYRmF1bHRDb3VudCgpO1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkudG9SYXRlKFxuICAgICAgbWV0cmljLFxuICAgICAgdGhpcy5yYXRlQ29tcHV0YXRpb25NZXRob2QsXG4gICAgICBmYWxzZSxcbiAgICAgIFwiZmF1bHRzXCJcbiAgICApO1xuICB9XG59XG4iXX0=