"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BillingMetricFactory = exports.BillingCurrency = exports.BillingRegion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
exports.BillingRegion = "us-east-1";
exports.BillingCurrency = "USD";
const BillingNamespace = "AWS/Billing";
const BillingMetric = "EstimatedCharges";
const BillingPeriod = aws_cdk_lib_1.Duration.days(1);
const DefaultServiceLimit = 10;
class BillingMetricFactory {
    metricSearchTopCostByServiceInUsd() {
        // standard MathExpression class does not support region
        // TODO: revisit after migration to CDK 1.126.0
        const search = new common_1.XaxrMathExpression({
            period: BillingPeriod,
            region: exports.BillingRegion,
            expression: `SEARCH('{${BillingNamespace},Currency,ServiceName} MetricName="${BillingMetric}"', 'Maximum', ${BillingPeriod.toSeconds()})`,
            usingMetrics: {},
            label: " ",
        });
        return new common_1.XaxrMathExpression({
            period: BillingPeriod,
            region: exports.BillingRegion,
            expression: `SORT(search, MAX, DESC, ${DefaultServiceLimit})`,
            usingMetrics: { search },
            label: " ",
        });
    }
    metricTotalCostInUsd() {
        // not using metric factory because we customize everything
        return new aws_cloudwatch_1.Metric({
            namespace: BillingNamespace,
            metricName: BillingMetric,
            dimensionsMap: { Currency: exports.BillingCurrency },
            period: BillingPeriod,
            label: `Estimated Charges`,
            region: exports.BillingRegion,
            statistic: common_1.MetricStatistic.MAX,
        });
    }
}
exports.BillingMetricFactory = BillingMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
BillingMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.BillingMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQmlsbGluZ01ldHJpY0ZhY3RvcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJCaWxsaW5nTWV0cmljRmFjdG9yeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLDZDQUF1QztBQUN2QywrREFBNkQ7QUFFN0QseUNBSXNCO0FBRVQsUUFBQSxhQUFhLEdBQUcsV0FBVyxDQUFDO0FBQzVCLFFBQUEsZUFBZSxHQUFHLEtBQUssQ0FBQztBQUVyQyxNQUFNLGdCQUFnQixHQUFHLGFBQWEsQ0FBQztBQUN2QyxNQUFNLGFBQWEsR0FBRyxrQkFBa0IsQ0FBQztBQUN6QyxNQUFNLGFBQWEsR0FBRyxzQkFBUSxDQUFDLElBQUksQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUN2QyxNQUFNLG1CQUFtQixHQUFHLEVBQUUsQ0FBQztBQUUvQixNQUFhLG9CQUFvQjtJQUMvQixpQ0FBaUM7UUFDL0Isd0RBQXdEO1FBQ3hELCtDQUErQztRQUUvQyxNQUFNLE1BQU0sR0FBRyxJQUFJLDJCQUFrQixDQUFDO1lBQ3BDLE1BQU0sRUFBRSxhQUFhO1lBQ3JCLE1BQU0sRUFBRSxxQkFBYTtZQUNyQixVQUFVLEVBQUUsWUFBWSxnQkFBZ0Isc0NBQXNDLGFBQWEsa0JBQWtCLGFBQWEsQ0FBQyxTQUFTLEVBQUUsR0FBRztZQUN6SSxZQUFZLEVBQUUsRUFBRTtZQUNoQixLQUFLLEVBQUUsR0FBRztTQUNYLENBQUMsQ0FBQztRQUVILE9BQU8sSUFBSSwyQkFBa0IsQ0FBQztZQUM1QixNQUFNLEVBQUUsYUFBYTtZQUNyQixNQUFNLEVBQUUscUJBQWE7WUFDckIsVUFBVSxFQUFFLDJCQUEyQixtQkFBbUIsR0FBRztZQUM3RCxZQUFZLEVBQUUsRUFBRSxNQUFNLEVBQUU7WUFDeEIsS0FBSyxFQUFFLEdBQUc7U0FDWCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsb0JBQW9CO1FBQ2xCLDJEQUEyRDtRQUUzRCxPQUFPLElBQUksdUJBQU0sQ0FBQztZQUNoQixTQUFTLEVBQUUsZ0JBQWdCO1lBQzNCLFVBQVUsRUFBRSxhQUFhO1lBQ3pCLGFBQWEsRUFBRSxFQUFFLFFBQVEsRUFBRSx1QkFBZSxFQUFFO1lBQzVDLE1BQU0sRUFBRSxhQUFhO1lBQ3JCLEtBQUssRUFBRSxtQkFBbUI7WUFDMUIsTUFBTSxFQUFFLHFCQUFhO1lBQ3JCLFNBQVMsRUFBRSx3QkFBZSxDQUFDLEdBQUc7U0FDL0IsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFsQ0gsb0RBbUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgRHVyYXRpb24gfSBmcm9tIFwiYXdzLWNkay1saWJcIjtcbmltcG9ydCB7IElNZXRyaWMsIE1ldHJpYyB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaFwiO1xuXG5pbXBvcnQge1xuICBNZXRyaWNTdGF0aXN0aWMsXG4gIE1ldHJpY1dpdGhBbGFybVN1cHBvcnQsXG4gIFhheHJNYXRoRXhwcmVzc2lvbixcbn0gZnJvbSBcIi4uLy4uL2NvbW1vblwiO1xuXG5leHBvcnQgY29uc3QgQmlsbGluZ1JlZ2lvbiA9IFwidXMtZWFzdC0xXCI7XG5leHBvcnQgY29uc3QgQmlsbGluZ0N1cnJlbmN5ID0gXCJVU0RcIjtcblxuY29uc3QgQmlsbGluZ05hbWVzcGFjZSA9IFwiQVdTL0JpbGxpbmdcIjtcbmNvbnN0IEJpbGxpbmdNZXRyaWMgPSBcIkVzdGltYXRlZENoYXJnZXNcIjtcbmNvbnN0IEJpbGxpbmdQZXJpb2QgPSBEdXJhdGlvbi5kYXlzKDEpO1xuY29uc3QgRGVmYXVsdFNlcnZpY2VMaW1pdCA9IDEwO1xuXG5leHBvcnQgY2xhc3MgQmlsbGluZ01ldHJpY0ZhY3Rvcnkge1xuICBtZXRyaWNTZWFyY2hUb3BDb3N0QnlTZXJ2aWNlSW5Vc2QoKTogSU1ldHJpYyB7XG4gICAgLy8gc3RhbmRhcmQgTWF0aEV4cHJlc3Npb24gY2xhc3MgZG9lcyBub3Qgc3VwcG9ydCByZWdpb25cbiAgICAvLyBUT0RPOiByZXZpc2l0IGFmdGVyIG1pZ3JhdGlvbiB0byBDREsgMS4xMjYuMFxuXG4gICAgY29uc3Qgc2VhcmNoID0gbmV3IFhheHJNYXRoRXhwcmVzc2lvbih7XG4gICAgICBwZXJpb2Q6IEJpbGxpbmdQZXJpb2QsXG4gICAgICByZWdpb246IEJpbGxpbmdSZWdpb24sXG4gICAgICBleHByZXNzaW9uOiBgU0VBUkNIKCd7JHtCaWxsaW5nTmFtZXNwYWNlfSxDdXJyZW5jeSxTZXJ2aWNlTmFtZX0gTWV0cmljTmFtZT1cIiR7QmlsbGluZ01ldHJpY31cIicsICdNYXhpbXVtJywgJHtCaWxsaW5nUGVyaW9kLnRvU2Vjb25kcygpfSlgLFxuICAgICAgdXNpbmdNZXRyaWNzOiB7fSxcbiAgICAgIGxhYmVsOiBcIiBcIixcbiAgICB9KTtcblxuICAgIHJldHVybiBuZXcgWGF4ck1hdGhFeHByZXNzaW9uKHtcbiAgICAgIHBlcmlvZDogQmlsbGluZ1BlcmlvZCxcbiAgICAgIHJlZ2lvbjogQmlsbGluZ1JlZ2lvbixcbiAgICAgIGV4cHJlc3Npb246IGBTT1JUKHNlYXJjaCwgTUFYLCBERVNDLCAke0RlZmF1bHRTZXJ2aWNlTGltaXR9KWAsXG4gICAgICB1c2luZ01ldHJpY3M6IHsgc2VhcmNoIH0sXG4gICAgICBsYWJlbDogXCIgXCIsXG4gICAgfSk7XG4gIH1cblxuICBtZXRyaWNUb3RhbENvc3RJblVzZCgpOiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0IHtcbiAgICAvLyBub3QgdXNpbmcgbWV0cmljIGZhY3RvcnkgYmVjYXVzZSB3ZSBjdXN0b21pemUgZXZlcnl0aGluZ1xuXG4gICAgcmV0dXJuIG5ldyBNZXRyaWMoe1xuICAgICAgbmFtZXNwYWNlOiBCaWxsaW5nTmFtZXNwYWNlLFxuICAgICAgbWV0cmljTmFtZTogQmlsbGluZ01ldHJpYyxcbiAgICAgIGRpbWVuc2lvbnNNYXA6IHsgQ3VycmVuY3k6IEJpbGxpbmdDdXJyZW5jeSB9LFxuICAgICAgcGVyaW9kOiBCaWxsaW5nUGVyaW9kLFxuICAgICAgbGFiZWw6IGBFc3RpbWF0ZWQgQ2hhcmdlc2AsXG4gICAgICByZWdpb246IEJpbGxpbmdSZWdpb24sXG4gICAgICBzdGF0aXN0aWM6IE1ldHJpY1N0YXRpc3RpYy5NQVgsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==