"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BillingMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const BillingMetricFactory_1 = require("./BillingMetricFactory");
class BillingMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName: "Billing",
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.alarmFactory = scope.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.anomalyDetectingAlarmFactory = new common_1.AnomalyDetectingAlarmFactory(this.alarmFactory);
        const metricFactory = new BillingMetricFactory_1.BillingMetricFactory();
        this.costByServiceMetric =
            metricFactory.metricSearchTopCostByServiceInUsd();
        this.totalCostMetric = metricFactory.metricTotalCostInUsd();
        for (const disambiguator in props.addTotalCostAnomalyAlarm) {
            const alarmProps = props.addTotalCostAnomalyAlarm[disambiguator];
            const createdAlarm = this.anomalyDetectingAlarmFactory.addAlarmWhenOutOfBand(this.totalCostMetric, "Cost-Anomaly", disambiguator, alarmProps);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createTotalChargesWidget(common_1.FullWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createChargesByServiceWidget(common_1.ThreeQuartersWidth, common_1.DefaultGraphWidgetHeight),
            this.createTotalChargesWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "AWS Account Billing",
            title: this.title,
        });
    }
    createChargesByServiceWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Most Expensive Services (" + BillingMetricFactory_1.BillingCurrency + ")",
            left: [this.costByServiceMetric],
            leftYAxis: common_1.CurrencyAxisUsdFromZero,
            view: aws_cloudwatch_1.GraphWidgetView.BAR,
            // billing is global but resides in single region
            region: BillingMetricFactory_1.BillingRegion,
        });
    }
    createTotalChargesWidget(width, height) {
        return new aws_cloudwatch_1.SingleValueWidget({
            width,
            height,
            title: "Total Cost (" + BillingMetricFactory_1.BillingCurrency + ")",
            metrics: [this.totalCostMetric],
            fullPrecision: false,
            setPeriodToTimeRange: false,
            // billing is global but resides in single region
            region: BillingMetricFactory_1.BillingRegion,
        });
    }
}
exports.BillingMonitoring = BillingMonitoring;
_a = JSII_RTTI_SYMBOL_1;
BillingMonitoring[_a] = { fqn: "cdk-monitoring-constructs.BillingMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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