"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontDistributionMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const CloudFrontNamespace = "AWS/CloudFront";
const CloudFrontGlobalRegion = "Global";
const CloudFrontDefaultMetricRegion = "us-east-1";
/**
 * To get the CloudFront metrics from the CloudWatch API, you must use the US East (N. Virginia) Region (us-east-1).
 * https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/programming-cloudwatch-metrics.html
 */
class CloudFrontDistributionMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.fillTpsWithZeroes = props.fillTpsWithZeroes ?? true;
        this.rateComputationMethod =
            props.rateComputationMethod ?? common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            DistributionId: props.distribution.distributionId,
            Region: CloudFrontGlobalRegion,
        };
    }
    metricRequestCount() {
        return this.metricFactory
            .createMetric("Requests", common_1.MetricStatistic.SUM, "Uploaded", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metricRequestRate() {
        return this.metricFactory.toRate(this.metricRequestCount(), this.rateComputationMethod, false, "requests", this.fillTpsWithZeroes);
    }
    /**
     * @deprecated use metricRequestRate
     */
    metricRequestTps() {
        return this.metricFactory.toRate(this.metricRequestCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests", this.fillTpsWithZeroes);
    }
    metricTotalBytesUploaded() {
        return this.metricFactory
            .createMetric("BytesUploaded", common_1.MetricStatistic.SUM, "Uploaded", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metricTotalBytesDownloaded() {
        return this.metricFactory
            .createMetric("BytesDownloaded", common_1.MetricStatistic.SUM, "Downloaded", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    /**
     * Cache hit rate metric. This is an additional metric that needs to be explicitly enabled for an additional cost.
     *
     * @see https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/viewing-cloudfront-metrics.html#monitoring-console.distributions-additional
     */
    metricCacheHitRateAverageInPercent() {
        return this.metricFactory
            .createMetric("CacheHitRate", common_1.MetricStatistic.AVERAGE, "Hit Rate", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metric4xxErrorRateAverage() {
        return this.metricFactory
            .createMetric("4xxErrorRate", common_1.MetricStatistic.AVERAGE, "4XX", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metric5xxErrorRateAverage() {
        return this.metricFactory
            .createMetric("5xxErrorRate", common_1.MetricStatistic.AVERAGE, "5XX", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
    metricTotalErrorRateAverage() {
        return this.metricFactory
            .createMetric("TotalErrorRate", common_1.MetricStatistic.AVERAGE, "Total", this.dimensionsMap, undefined, CloudFrontNamespace)
            .with({ region: CloudFrontDefaultMetricRegion });
    }
}
exports.CloudFrontDistributionMetricFactory = CloudFrontDistributionMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontDistributionMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.CloudFrontDistributionMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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