"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudFrontDistributionMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const CloudFrontDistributionMetricFactory_1 = require("./CloudFrontDistributionMetricFactory");
class CloudFrontDistributionMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope);
        const namedConstruct = props.distribution;
        const fallbackConstructName = namedConstruct.distributionId;
        this.namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct,
            fallbackConstructName,
        });
        this.title = this.namingStrategy.resolveHumanReadableName();
        this.distributionUrl = scope
            .createAwsConsoleUrlFactory()
            .getCloudFrontDistributionUrl(namedConstruct.distributionId);
        this.alarmFactory = this.createAlarmFactory(this.namingStrategy.resolveAlarmFriendlyName());
        this.errorAlarmFactory = new common_1.ErrorAlarmFactory(this.alarmFactory);
        this.tpsAlarmFactory = new common_1.TpsAlarmFactory(this.alarmFactory);
        this.errorRateAnnotations = [];
        this.tpsAnnotations = [];
        const metricFactory = new CloudFrontDistributionMetricFactory_1.CloudFrontDistributionMetricFactory(scope.createMetricFactory(), props);
        this.tpsMetric = metricFactory.metricRequestTps();
        this.downloadedBytesMetric = metricFactory.metricTotalBytesDownloaded();
        this.uploadedBytesMetric = metricFactory.metricTotalBytesUploaded();
        this.error4xxRate = metricFactory.metric4xxErrorRateAverage();
        this.error5xxRate = metricFactory.metric5xxErrorRateAverage();
        this.additionalMetricsEnabled = props.additionalMetricsEnabled ?? true;
        if (this.additionalMetricsEnabled) {
            this.cacheHitRate = metricFactory.metricCacheHitRateAverageInPercent();
        }
        for (const disambiguator in props.addLowTpsAlarm) {
            const alarmProps = props.addLowTpsAlarm[disambiguator];
            const createdAlarm = this.tpsAlarmFactory.addMinTpsAlarm(this.tpsMetric, alarmProps, disambiguator);
            this.tpsAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addHighTpsAlarm) {
            const alarmProps = props.addHighTpsAlarm[disambiguator];
            const createdAlarm = this.tpsAlarmFactory.addMaxTpsAlarm(this.tpsMetric, alarmProps, disambiguator);
            this.tpsAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addError4xxRate) {
            const alarmProps = props.addError4xxRate[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorRateAlarm(this.error4xxRate, common_1.ErrorType.ERROR, alarmProps, disambiguator);
            this.errorRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addFault5xxRate) {
            const alarmProps = props.addFault5xxRate[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorRateAlarm(this.error5xxRate, common_1.ErrorType.FAULT, alarmProps, disambiguator);
            this.errorRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        if (props.useCreatedAlarms) {
            props.useCreatedAlarms.consume(this.createdAlarms());
        }
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createTpsWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            this.createErrorRateWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        if (this.additionalMetricsEnabled) {
            return [
                this.createTitleWidget(),
                this.createTpsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
                this.createCacheWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
                this.createTrafficWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
                this.createErrorRateWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            ];
        }
        else {
            return [
                this.createTitleWidget(),
                this.createTpsWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
                this.createTrafficWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
                this.createErrorRateWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            ];
        }
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "CloudFront Distribution",
            title: this.title,
            goToLinkUrl: this.distributionUrl,
        });
    }
    createTpsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "TPS",
            left: [this.tpsMetric],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: this.tpsAnnotations,
        });
    }
    createCacheWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Hit Rate",
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            left: [this.cacheHitRate],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
        });
    }
    createTrafficWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Traffic",
            left: [this.downloadedBytesMetric, this.uploadedBytesMetric],
            leftYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
    createErrorRateWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Errors (rate)",
            left: [this.error4xxRate, this.error5xxRate],
            leftAnnotations: this.errorRateAnnotations,
            leftYAxis: common_1.RateAxisFromZero,
        });
    }
}
exports.CloudFrontDistributionMonitoring = CloudFrontDistributionMonitoring;
_a = JSII_RTTI_SYMBOL_1;
CloudFrontDistributionMonitoring[_a] = { fqn: "cdk-monitoring-constructs.CloudFrontDistributionMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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