"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LogMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const DefaultLimit = 10;
/**
 * Monitors a CloudWatch log group for various patterns.
 */
class LogMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope);
        this.pattern = props.pattern;
        this.title = props.title;
        this.limit = props.limit ?? DefaultLimit;
        this.logGroupName = props.logGroupName;
        this.logGroupUrl = scope
            .createAwsConsoleUrlFactory()
            .getCloudWatchLogGroupUrl(props.logGroupName);
    }
    widgets() {
        return [
            new dashboard_1.MonitoringHeaderWidget({
                family: "Log Group",
                title: this.logGroupName,
                goToLinkUrl: this.logGroupUrl,
            }),
            // Log Query Results
            new aws_cloudwatch_1.LogQueryWidget({
                logGroupNames: [this.logGroupName],
                height: this.resolveRecommendedHeight(this.limit),
                width: common_1.FullWidth,
                title: this.title ?? `Find ${this.pattern} (limit = ${this.limit})`,
                /**
                 * https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/CWL_QuerySyntax.html
                 */
                queryLines: [
                    "fields @timestamp, @logStream, @message",
                    `filter @message like /${this.pattern}/`,
                    "sort @timestamp desc",
                    `limit ${this.limit}`,
                ],
            }),
        ];
    }
    resolveRecommendedHeight(numRows) {
        const heightPerLine = 1;
        const recommendedHeight = heightPerLine * numRows;
        return Math.max(recommendedHeight, common_1.DefaultLogWidgetHeight);
    }
}
exports.LogMonitoring = LogMonitoring;
_a = JSII_RTTI_SYMBOL_1;
LogMonitoring[_a] = { fqn: "cdk-monitoring-constructs.LogMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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