"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CodeBuildProjectMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const CodeBuildProjectMetricFactory_1 = require("./CodeBuildProjectMetricFactory");
class CodeBuildProjectMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.project,
            fallbackConstructName: this.resolveProjectName(props.project),
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.projectUrl = scope
            .createAwsConsoleUrlFactory()
            .getCodeBuildProjectUrl(props.project.projectName);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.durationAlarmFactory = new common_1.LatencyAlarmFactory(alarmFactory);
        this.errorAlarmFactory = new common_1.ErrorAlarmFactory(alarmFactory);
        this.durationAnnotations = [];
        this.errorCountAnnotations = [];
        this.errorRateAnnotations = [];
        const metricFactory = new CodeBuildProjectMetricFactory_1.CodeBuildProjectMetricFactory(scope.createMetricFactory(), props);
        this.buildCountMetric = metricFactory.metricBuildCount();
        this.succeededBuildCountMetric = metricFactory.metricSucceededBuildCount();
        this.failedBuildCountMetric = metricFactory.metricFailedBuildCount();
        this.failedBuildRateMetric = metricFactory.metricFailedBuildRate();
        this.durationP99InSecondsMetric =
            metricFactory.metricDurationP99InSeconds();
        this.durationP90InSecondsMetric =
            metricFactory.metricDurationP90InSeconds();
        this.durationP50InSecondsMetric =
            metricFactory.metricDurationP50InSeconds();
        for (const disambiguator in props.addDurationP99Alarm) {
            const alarmProps = props.addDurationP99Alarm[disambiguator];
            const createdAlarm = this.durationAlarmFactory.addDurationAlarm(this.durationP99InSecondsMetric, common_1.LatencyType.P99, alarmProps, disambiguator);
            this.durationAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDurationP90Alarm) {
            const alarmProps = props.addDurationP90Alarm[disambiguator];
            const createdAlarm = this.durationAlarmFactory.addDurationAlarm(this.durationP90InSecondsMetric, common_1.LatencyType.P90, alarmProps, disambiguator);
            this.durationAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDurationP50Alarm) {
            const alarmProps = props.addDurationP50Alarm[disambiguator];
            const createdAlarm = this.durationAlarmFactory.addDurationAlarm(this.durationP50InSecondsMetric, common_1.LatencyType.P50, alarmProps, disambiguator);
            this.durationAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addFailedBuildCountAlarm) {
            const alarmProps = props.addFailedBuildCountAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorCountAlarm(this.failedBuildCountMetric, common_1.ErrorType.FAILURE, alarmProps, disambiguator);
            this.errorCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addFailedBuildRateAlarm) {
            const alarmProps = props.addFailedBuildRateAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorRateAlarm(this.failedBuildRateMetric, common_1.ErrorType.FAILURE, alarmProps, disambiguator);
            this.errorRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createBuildCountsWidget(),
            this.createDurationWidget(),
            this.createFailedBuildRateWidget(),
        ];
    }
    summaryWidgets() {
        // TODO: verify sizes, mainly heights
        return this.widgets();
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "CodeBuild Project",
            title: this.title,
            goToLinkUrl: this.projectUrl,
        });
    }
    createBuildCountsWidget() {
        return new aws_cloudwatch_1.GraphWidget({
            width: common_1.ThirdWidth,
            height: common_1.DefaultGraphWidgetHeight,
            title: "Builds",
            left: [
                this.buildCountMetric,
                this.succeededBuildCountMetric,
                this.failedBuildCountMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.errorCountAnnotations,
        });
    }
    createDurationWidget() {
        return new aws_cloudwatch_1.GraphWidget({
            width: common_1.ThirdWidth,
            height: common_1.DefaultGraphWidgetHeight,
            title: "Duration",
            left: [
                this.durationP50InSecondsMetric,
                this.durationP90InSecondsMetric,
                this.durationP99InSecondsMetric,
            ],
            leftYAxis: common_1.TimeAxisSecondsFromZero,
            leftAnnotations: this.durationAnnotations,
        });
    }
    createFailedBuildRateWidget() {
        return new aws_cloudwatch_1.GraphWidget({
            width: common_1.ThirdWidth,
            height: common_1.DefaultGraphWidgetHeight,
            title: "Failed Builds (rate)",
            left: [this.failedBuildRateMetric],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: this.errorRateAnnotations,
        });
    }
    resolveProjectName(project) {
        return project.node.defaultChild?.name;
    }
}
exports.CodeBuildProjectMonitoring = CodeBuildProjectMonitoring;
_a = JSII_RTTI_SYMBOL_1;
CodeBuildProjectMonitoring[_a] = { fqn: "cdk-monitoring-constructs.CodeBuildProjectMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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