"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DocumentDbMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const DocumentDbNamespace = "AWS/DocDB";
class DocumentDbMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.clusterIdentifier = props.cluster.clusterIdentifier;
        this.dimensionsMap = { DBClusterIdentifier: this.clusterIdentifier };
    }
    metricAverageCpuUsageInPercent() {
        return this.metric("CPUUtilization", common_1.MetricStatistic.AVERAGE, "CPU Usage");
    }
    metricMaxConnectionCount() {
        return this.metric("DatabaseConnectionsMax", common_1.MetricStatistic.MAX, "Connections");
    }
    metricMaxCursorCount() {
        return this.metric("DatabaseCursorsMax", common_1.MetricStatistic.MAX, "Cursors");
    }
    metricMaxTransactionOpenCount() {
        return this.metric("TransactionsOpenMax", common_1.MetricStatistic.MAX, "Transactions");
    }
    metricOperationsThrottledDueLowMemoryCount() {
        return this.metric("LowMemNumOperationsThrottled", common_1.MetricStatistic.SUM, "Operations throttled (low mem)");
    }
    metricReadLatencyInMillis(latencyType) {
        const label = "Read " + common_1.getLatencyTypeLabel(latencyType);
        return this.metric("ReadLatency", common_1.getLatencyTypeStatistic(latencyType), label);
    }
    metricWriteLatencyInMillis(latencyType) {
        const label = "Write " + common_1.getLatencyTypeLabel(latencyType);
        return this.metric("WriteLatency", common_1.getLatencyTypeStatistic(latencyType), label);
    }
    metric(metricName, statistic, label) {
        return this.metricFactory.createMetric(metricName, statistic, label, this.dimensionsMap, undefined, DocumentDbNamespace);
    }
}
exports.DocumentDbMetricFactory = DocumentDbMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
DocumentDbMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.DocumentDbMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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