"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoTableGlobalSecondaryIndexMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const DynamoDbNamespace = "AWS/DynamoDB";
class DynamoTableGlobalSecondaryIndexMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.dimensionsMap = {
            TableName: props.table.tableName,
            GlobalSecondaryIndexName: props.globalSecondaryIndexName,
        };
    }
    metricProvisionedReadCapacityUnits() {
        return this.metricFactory.createMetric("ProvisionedReadCapacityUnits", common_1.MetricStatistic.SUM, "Provisioned", this.dimensionsMap, undefined, DynamoDbNamespace);
    }
    metricProvisionedWriteCapacityUnits() {
        return this.metricFactory.createMetric("ProvisionedWriteCapacityUnits", common_1.MetricStatistic.SUM, "Provisioned", this.dimensionsMap, undefined, DynamoDbNamespace);
    }
    metricConsumedReadCapacityUnits() {
        return this.metricFactory.createMetric("ConsumedReadCapacityUnits", common_1.MetricStatistic.SUM, "Consumed", this.dimensionsMap, undefined, DynamoDbNamespace);
    }
    metricConsumedWriteCapacityUnits() {
        return this.metricFactory.createMetric("ConsumedWriteCapacityUnits", common_1.MetricStatistic.SUM, "Consumed", this.dimensionsMap, undefined, DynamoDbNamespace);
    }
    metricIndexConsumedWriteUnitsMetric() {
        return this.metricFactory.createMetric("OnlineIndexConsumedWriteCapacity", common_1.MetricStatistic.SUM, "Consumed by index", this.dimensionsMap, undefined, DynamoDbNamespace);
    }
    metricThrottledReadRequestCount() {
        const readThrottles = this.metricFactory.createMetric("ReadThrottleEvents", common_1.MetricStatistic.SUM, undefined, this.dimensionsMap, undefined, DynamoDbNamespace);
        return this.metricFactory.createMetricMath("FILL(readThrottles,0)", { readThrottles }, "Read");
    }
    metricThrottledWriteRequestCount() {
        const writeThrottles = this.metricFactory.createMetric("WriteThrottleEvents", common_1.MetricStatistic.SUM, undefined, this.dimensionsMap, undefined, DynamoDbNamespace);
        return this.metricFactory.createMetricMath("FILL(writeThrottles,0)", { writeThrottles }, "Write");
    }
    metricThrottledIndexRequestCount() {
        const indexThrottles = this.metricFactory.createMetric("OnlineIndexThrottleEvents", common_1.MetricStatistic.SUM, undefined, this.dimensionsMap, undefined, DynamoDbNamespace);
        return this.metricFactory.createMetricMath("FILL(indexThrottles,0)", { indexThrottles }, "Index");
    }
}
exports.DynamoTableGlobalSecondaryIndexMetricFactory = DynamoTableGlobalSecondaryIndexMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
DynamoTableGlobalSecondaryIndexMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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