"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DynamoTableGlobalSecondaryIndexMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const DynamoTableGlobalSecondaryIndexMetricFactory_1 = require("./DynamoTableGlobalSecondaryIndexMetricFactory");
class DynamoTableGlobalSecondaryIndexMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName: props.globalSecondaryIndexName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.tableUrl = scope
            .createAwsConsoleUrlFactory()
            .getDynamoTableUrl(props.table.tableName);
        const metricFactory = new DynamoTableGlobalSecondaryIndexMetricFactory_1.DynamoTableGlobalSecondaryIndexMetricFactory(scope.createMetricFactory(), props);
        this.provisionedReadUnitsMetric =
            metricFactory.metricProvisionedReadCapacityUnits();
        this.provisionedWriteUnitsMetric =
            metricFactory.metricProvisionedWriteCapacityUnits();
        this.consumedReadUnitsMetric =
            metricFactory.metricConsumedReadCapacityUnits();
        this.consumedWriteUnitsMetric =
            metricFactory.metricConsumedWriteCapacityUnits();
        this.indexConsumedWriteUnitsMetric =
            metricFactory.metricIndexConsumedWriteUnitsMetric();
        this.readThrottleCountMetric =
            metricFactory.metricThrottledReadRequestCount();
        this.writeThrottleCountMetric =
            metricFactory.metricThrottledWriteRequestCount();
        this.indexThrottleCountMetric =
            metricFactory.metricThrottledIndexRequestCount();
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createReadCapacityWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createWriteCapacityWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createThrottlesWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createReadCapacityWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createWriteCapacityWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createThrottlesWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Dynamo Table Global Secondary Index",
            title: this.title,
            goToLinkUrl: this.tableUrl,
        });
    }
    createReadCapacityWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Read Capacity",
            left: [this.consumedReadUnitsMetric, this.provisionedReadUnitsMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createWriteCapacityWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Write Capacity",
            left: [
                this.consumedWriteUnitsMetric,
                this.provisionedWriteUnitsMetric,
                this.indexConsumedWriteUnitsMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createThrottlesWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Throttles",
            left: [
                this.readThrottleCountMetric,
                this.writeThrottleCountMetric,
                this.indexThrottleCountMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
}
exports.DynamoTableGlobalSecondaryIndexMonitoring = DynamoTableGlobalSecondaryIndexMonitoring;
_a = JSII_RTTI_SYMBOL_1;
DynamoTableGlobalSecondaryIndexMonitoring[_a] = { fqn: "cdk-monitoring-constructs.DynamoTableGlobalSecondaryIndexMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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