"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutoScalingGroupMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const AutoScalingNamespace = "AWS/AutoScaling";
class AutoScalingGroupMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.dimensionsMap = {
            AutoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
        };
    }
    /**
     * The minimum size of the Auto Scaling group.
     */
    metricGroupMinSize() {
        return this.createMetric("GroupMinSize", "Min", common_1.MetricStatistic.AVERAGE);
    }
    /**
     * The maximum size of the Auto Scaling group.
     */
    metricGroupMaxSize() {
        return this.createMetric("GroupMaxSize", "Max", common_1.MetricStatistic.AVERAGE);
    }
    /**
     * The number of instances that the Auto Scaling group attempts to maintain.
     */
    metricGroupDesiredCapacity() {
        return this.createMetric("GroupDesiredCapacity", "Desired", common_1.MetricStatistic.AVERAGE);
    }
    /**
       *
       The number of instances that are running as part of the Auto Scaling group.
       This metric does not include instances that are pending or terminating.
       */
    metricGroupInServiceInstances() {
        return this.createMetric("GroupInServiceInstances", "InService", common_1.MetricStatistic.AVERAGE);
    }
    /**
     * The number of instances that are pending. A pending instance is not yet in service.
     * This metric does not include instances that are in service or terminating.
     */
    metricGroupPendingInstances() {
        return this.createMetric("GroupPendingInstances", "Pending", common_1.MetricStatistic.AVERAGE);
    }
    /**
     * The number of instances that are in a Standby state.
     * Instances in this state are still running but are not actively in service.
     */
    metricGroupStandbyInstances() {
        return this.createMetric("GroupStandbyInstances", "Standby", common_1.MetricStatistic.AVERAGE);
    }
    /**
     * The number of instances that are in the process of terminating.
     * This metric does not include instances that are in service or pending.
     */
    metricGroupTerminatingInstances() {
        return this.createMetric("GroupTerminatingInstances", "Terminating", common_1.MetricStatistic.AVERAGE);
    }
    /**
     * The total number of instances in the Auto Scaling group.
     * This metric identifies the number of instances that are in service, pending, and terminating.
     */
    metricGroupTotalInstances() {
        return this.createMetric("GroupTotalInstances", "Total", common_1.MetricStatistic.AVERAGE);
    }
    createMetric(metricName, label, statistic) {
        return this.metricFactory.createMetric(metricName, statistic, label, this.dimensionsMap, undefined, AutoScalingNamespace);
    }
}
exports.AutoScalingGroupMetricFactory = AutoScalingGroupMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
AutoScalingGroupMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.AutoScalingGroupMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQXV0b1NjYWxpbmdHcm91cE1ldHJpY0ZhY3RvcnkuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJBdXRvU2NhbGluZ0dyb3VwTWV0cmljRmFjdG9yeS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUdBLHlDQUE4RDtBQUU5RCxNQUFNLG9CQUFvQixHQUFHLGlCQUFpQixDQUFDO0FBTS9DLE1BQWEsNkJBQTZCO0lBSXhDLFlBQ0UsYUFBNEIsRUFDNUIsS0FBeUM7UUFFekMsSUFBSSxDQUFDLGFBQWEsR0FBRyxhQUFhLENBQUM7UUFDbkMsSUFBSSxDQUFDLGFBQWEsR0FBRztZQUNuQixvQkFBb0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsb0JBQW9CO1NBQ2xFLENBQUM7SUFDSixDQUFDO0lBRUQ7O09BRUc7SUFDSCxrQkFBa0I7UUFDaEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLGNBQWMsRUFBRSxLQUFLLEVBQUUsd0JBQWUsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMzRSxDQUFDO0lBRUQ7O09BRUc7SUFDSCxrQkFBa0I7UUFDaEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUFDLGNBQWMsRUFBRSxLQUFLLEVBQUUsd0JBQWUsQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUMzRSxDQUFDO0lBRUQ7O09BRUc7SUFDSCwwQkFBMEI7UUFDeEIsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUN0QixzQkFBc0IsRUFDdEIsU0FBUyxFQUNULHdCQUFlLENBQUMsT0FBTyxDQUN4QixDQUFDO0lBQ0osQ0FBQztJQUVEOzs7O1NBSUs7SUFDTCw2QkFBNkI7UUFDM0IsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUN0Qix5QkFBeUIsRUFDekIsV0FBVyxFQUNYLHdCQUFlLENBQUMsT0FBTyxDQUN4QixDQUFDO0lBQ0osQ0FBQztJQUVEOzs7T0FHRztJQUNILDJCQUEyQjtRQUN6QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQ3RCLHVCQUF1QixFQUN2QixTQUFTLEVBQ1Qsd0JBQWUsQ0FBQyxPQUFPLENBQ3hCLENBQUM7SUFDSixDQUFDO0lBRUQ7OztPQUdHO0lBQ0gsMkJBQTJCO1FBQ3pCLE9BQU8sSUFBSSxDQUFDLFlBQVksQ0FDdEIsdUJBQXVCLEVBQ3ZCLFNBQVMsRUFDVCx3QkFBZSxDQUFDLE9BQU8sQ0FDeEIsQ0FBQztJQUNKLENBQUM7SUFFRDs7O09BR0c7SUFDSCwrQkFBK0I7UUFDN0IsT0FBTyxJQUFJLENBQUMsWUFBWSxDQUN0QiwyQkFBMkIsRUFDM0IsYUFBYSxFQUNiLHdCQUFlLENBQUMsT0FBTyxDQUN4QixDQUFDO0lBQ0osQ0FBQztJQUVEOzs7T0FHRztJQUNILHlCQUF5QjtRQUN2QixPQUFPLElBQUksQ0FBQyxZQUFZLENBQ3RCLHFCQUFxQixFQUNyQixPQUFPLEVBQ1Asd0JBQWUsQ0FBQyxPQUFPLENBQ3hCLENBQUM7SUFDSixDQUFDO0lBRU8sWUFBWSxDQUNsQixVQUFrQixFQUNsQixLQUFhLEVBQ2IsU0FBMEI7UUFFMUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFlBQVksQ0FDcEMsVUFBVSxFQUNWLFNBQVMsRUFDVCxLQUFLLEVBQ0wsSUFBSSxDQUFDLGFBQWEsRUFDbEIsU0FBUyxFQUNULG9CQUFvQixDQUNyQixDQUFDO0lBQ0osQ0FBQzs7QUFqSEgsc0VBa0hDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgSUF1dG9TY2FsaW5nR3JvdXAgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWF1dG9zY2FsaW5nXCI7XG5pbXBvcnQgeyBEaW1lbnNpb25zTWFwIH0gZnJvbSBcImF3cy1jZGstbGliL2F3cy1jbG91ZHdhdGNoXCI7XG5cbmltcG9ydCB7IE1ldHJpY0ZhY3RvcnksIE1ldHJpY1N0YXRpc3RpYyB9IGZyb20gXCIuLi8uLi9jb21tb25cIjtcblxuY29uc3QgQXV0b1NjYWxpbmdOYW1lc3BhY2UgPSBcIkFXUy9BdXRvU2NhbGluZ1wiO1xuXG5leHBvcnQgaW50ZXJmYWNlIEF1dG9TY2FsaW5nR3JvdXBNZXRyaWNGYWN0b3J5UHJvcHMge1xuICByZWFkb25seSBhdXRvU2NhbGluZ0dyb3VwOiBJQXV0b1NjYWxpbmdHcm91cDtcbn1cblxuZXhwb3J0IGNsYXNzIEF1dG9TY2FsaW5nR3JvdXBNZXRyaWNGYWN0b3J5IHtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IG1ldHJpY0ZhY3Rvcnk6IE1ldHJpY0ZhY3Rvcnk7XG4gIHByb3RlY3RlZCByZWFkb25seSBkaW1lbnNpb25zTWFwOiBEaW1lbnNpb25zTWFwO1xuXG4gIGNvbnN0cnVjdG9yKFxuICAgIG1ldHJpY0ZhY3Rvcnk6IE1ldHJpY0ZhY3RvcnksXG4gICAgcHJvcHM6IEF1dG9TY2FsaW5nR3JvdXBNZXRyaWNGYWN0b3J5UHJvcHNcbiAgKSB7XG4gICAgdGhpcy5tZXRyaWNGYWN0b3J5ID0gbWV0cmljRmFjdG9yeTtcbiAgICB0aGlzLmRpbWVuc2lvbnNNYXAgPSB7XG4gICAgICBBdXRvU2NhbGluZ0dyb3VwTmFtZTogcHJvcHMuYXV0b1NjYWxpbmdHcm91cC5hdXRvU2NhbGluZ0dyb3VwTmFtZSxcbiAgICB9O1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBtaW5pbXVtIHNpemUgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICovXG4gIG1ldHJpY0dyb3VwTWluU2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5jcmVhdGVNZXRyaWMoXCJHcm91cE1pblNpemVcIiwgXCJNaW5cIiwgTWV0cmljU3RhdGlzdGljLkFWRVJBR0UpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBtYXhpbXVtIHNpemUgb2YgdGhlIEF1dG8gU2NhbGluZyBncm91cC5cbiAgICovXG4gIG1ldHJpY0dyb3VwTWF4U2l6ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5jcmVhdGVNZXRyaWMoXCJHcm91cE1heFNpemVcIiwgXCJNYXhcIiwgTWV0cmljU3RhdGlzdGljLkFWRVJBR0UpO1xuICB9XG5cbiAgLyoqXG4gICAqIFRoZSBudW1iZXIgb2YgaW5zdGFuY2VzIHRoYXQgdGhlIEF1dG8gU2NhbGluZyBncm91cCBhdHRlbXB0cyB0byBtYWludGFpbi5cbiAgICovXG4gIG1ldHJpY0dyb3VwRGVzaXJlZENhcGFjaXR5KCkge1xuICAgIHJldHVybiB0aGlzLmNyZWF0ZU1ldHJpYyhcbiAgICAgIFwiR3JvdXBEZXNpcmVkQ2FwYWNpdHlcIixcbiAgICAgIFwiRGVzaXJlZFwiLFxuICAgICAgTWV0cmljU3RhdGlzdGljLkFWRVJBR0VcbiAgICApO1xuICB9XG5cbiAgLyoqXG4gICAgICpcbiAgICAgVGhlIG51bWJlciBvZiBpbnN0YW5jZXMgdGhhdCBhcmUgcnVubmluZyBhcyBwYXJ0IG9mIHRoZSBBdXRvIFNjYWxpbmcgZ3JvdXAuXG4gICAgIFRoaXMgbWV0cmljIGRvZXMgbm90IGluY2x1ZGUgaW5zdGFuY2VzIHRoYXQgYXJlIHBlbmRpbmcgb3IgdGVybWluYXRpbmcuXG4gICAgICovXG4gIG1ldHJpY0dyb3VwSW5TZXJ2aWNlSW5zdGFuY2VzKCkge1xuICAgIHJldHVybiB0aGlzLmNyZWF0ZU1ldHJpYyhcbiAgICAgIFwiR3JvdXBJblNlcnZpY2VJbnN0YW5jZXNcIixcbiAgICAgIFwiSW5TZXJ2aWNlXCIsXG4gICAgICBNZXRyaWNTdGF0aXN0aWMuQVZFUkFHRVxuICAgICk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIG51bWJlciBvZiBpbnN0YW5jZXMgdGhhdCBhcmUgcGVuZGluZy4gQSBwZW5kaW5nIGluc3RhbmNlIGlzIG5vdCB5ZXQgaW4gc2VydmljZS5cbiAgICogVGhpcyBtZXRyaWMgZG9lcyBub3QgaW5jbHVkZSBpbnN0YW5jZXMgdGhhdCBhcmUgaW4gc2VydmljZSBvciB0ZXJtaW5hdGluZy5cbiAgICovXG4gIG1ldHJpY0dyb3VwUGVuZGluZ0luc3RhbmNlcygpIHtcbiAgICByZXR1cm4gdGhpcy5jcmVhdGVNZXRyaWMoXG4gICAgICBcIkdyb3VwUGVuZGluZ0luc3RhbmNlc1wiLFxuICAgICAgXCJQZW5kaW5nXCIsXG4gICAgICBNZXRyaWNTdGF0aXN0aWMuQVZFUkFHRVxuICAgICk7XG4gIH1cblxuICAvKipcbiAgICogVGhlIG51bWJlciBvZiBpbnN0YW5jZXMgdGhhdCBhcmUgaW4gYSBTdGFuZGJ5IHN0YXRlLlxuICAgKiBJbnN0YW5jZXMgaW4gdGhpcyBzdGF0ZSBhcmUgc3RpbGwgcnVubmluZyBidXQgYXJlIG5vdCBhY3RpdmVseSBpbiBzZXJ2aWNlLlxuICAgKi9cbiAgbWV0cmljR3JvdXBTdGFuZGJ5SW5zdGFuY2VzKCkge1xuICAgIHJldHVybiB0aGlzLmNyZWF0ZU1ldHJpYyhcbiAgICAgIFwiR3JvdXBTdGFuZGJ5SW5zdGFuY2VzXCIsXG4gICAgICBcIlN0YW5kYnlcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5BVkVSQUdFXG4gICAgKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgbnVtYmVyIG9mIGluc3RhbmNlcyB0aGF0IGFyZSBpbiB0aGUgcHJvY2VzcyBvZiB0ZXJtaW5hdGluZy5cbiAgICogVGhpcyBtZXRyaWMgZG9lcyBub3QgaW5jbHVkZSBpbnN0YW5jZXMgdGhhdCBhcmUgaW4gc2VydmljZSBvciBwZW5kaW5nLlxuICAgKi9cbiAgbWV0cmljR3JvdXBUZXJtaW5hdGluZ0luc3RhbmNlcygpIHtcbiAgICByZXR1cm4gdGhpcy5jcmVhdGVNZXRyaWMoXG4gICAgICBcIkdyb3VwVGVybWluYXRpbmdJbnN0YW5jZXNcIixcbiAgICAgIFwiVGVybWluYXRpbmdcIixcbiAgICAgIE1ldHJpY1N0YXRpc3RpYy5BVkVSQUdFXG4gICAgKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBUaGUgdG90YWwgbnVtYmVyIG9mIGluc3RhbmNlcyBpbiB0aGUgQXV0byBTY2FsaW5nIGdyb3VwLlxuICAgKiBUaGlzIG1ldHJpYyBpZGVudGlmaWVzIHRoZSBudW1iZXIgb2YgaW5zdGFuY2VzIHRoYXQgYXJlIGluIHNlcnZpY2UsIHBlbmRpbmcsIGFuZCB0ZXJtaW5hdGluZy5cbiAgICovXG4gIG1ldHJpY0dyb3VwVG90YWxJbnN0YW5jZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMuY3JlYXRlTWV0cmljKFxuICAgICAgXCJHcm91cFRvdGFsSW5zdGFuY2VzXCIsXG4gICAgICBcIlRvdGFsXCIsXG4gICAgICBNZXRyaWNTdGF0aXN0aWMuQVZFUkFHRVxuICAgICk7XG4gIH1cblxuICBwcml2YXRlIGNyZWF0ZU1ldHJpYyhcbiAgICBtZXRyaWNOYW1lOiBzdHJpbmcsXG4gICAgbGFiZWw6IHN0cmluZyxcbiAgICBzdGF0aXN0aWM6IE1ldHJpY1N0YXRpc3RpY1xuICApIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmNyZWF0ZU1ldHJpYyhcbiAgICAgIG1ldHJpY05hbWUsXG4gICAgICBzdGF0aXN0aWMsXG4gICAgICBsYWJlbCxcbiAgICAgIHRoaXMuZGltZW5zaW9uc01hcCxcbiAgICAgIHVuZGVmaW5lZCxcbiAgICAgIEF1dG9TY2FsaW5nTmFtZXNwYWNlXG4gICAgKTtcbiAgfVxufVxuIl19