import { BaseService } from "aws-cdk-lib/aws-ecs";
import { MetricFactory } from "../../common";
/**
 * Props to create BaseServiceMetricFactory.
 */
export interface BaseServiceMetricFactoryProps {
    readonly service: BaseService;
}
/**
 * Metric factory for a base service (parent class for e.g. Fargate and EC2 services).
 */
export declare class BaseServiceMetricFactory {
    protected readonly metricFactory: MetricFactory;
    protected readonly service: BaseService;
    constructor(metricFactory: MetricFactory, props: BaseServiceMetricFactoryProps);
    metricClusterCpuUtilisationInPercent(): import("../../common").MetricWithAlarmSupport;
    metricClusterMemoryUtilisationInPercent(): import("../../common").MetricWithAlarmSupport;
    metricRunningTaskCount(): import("../../common").MetricWithAlarmSupport;
}
