"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseServiceMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const EcsContainerInsightsNamespace = "ECS/ContainerInsights";
/**
 * Metric factory for a base service (parent class for e.g. Fargate and EC2 services).
 */
class BaseServiceMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.service = props.service;
    }
    metricClusterCpuUtilisationInPercent() {
        return this.metricFactory.adaptMetric(this.service.metricCpuUtilization({
            label: "Cluster CPU Utilization",
        }));
    }
    metricClusterMemoryUtilisationInPercent() {
        return this.metricFactory.adaptMetric(this.service.metricMemoryUtilization({
            label: "Cluster Memory Utilization",
        }));
    }
    metricRunningTaskCount() {
        return this.metricFactory.createMetric("RunningTaskCount", common_1.MetricStatistic.AVERAGE, "Running Tasks", {
            ServiceName: this.service.serviceName,
            ClusterName: this.service.cluster.clusterName,
        }, undefined, EcsContainerInsightsNamespace);
    }
}
exports.BaseServiceMetricFactory = BaseServiceMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
BaseServiceMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.BaseServiceMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQmFzZVNlcnZpY2VNZXRyaWNGYWN0b3J5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiQmFzZVNlcnZpY2VNZXRyaWNGYWN0b3J5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBRUEseUNBQThEO0FBRTlELE1BQU0sNkJBQTZCLEdBQUcsdUJBQXVCLENBQUM7QUFTOUQ7O0dBRUc7QUFDSCxNQUFhLHdCQUF3QjtJQUluQyxZQUNFLGFBQTRCLEVBQzVCLEtBQW9DO1FBRXBDLElBQUksQ0FBQyxhQUFhLEdBQUcsYUFBYSxDQUFDO1FBQ25DLElBQUksQ0FBQyxPQUFPLEdBQUcsS0FBSyxDQUFDLE9BQU8sQ0FBQztJQUMvQixDQUFDO0lBRUQsb0NBQW9DO1FBQ2xDLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQ25DLElBQUksQ0FBQyxPQUFPLENBQUMsb0JBQW9CLENBQUM7WUFDaEMsS0FBSyxFQUFFLHlCQUF5QjtTQUNqQyxDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCx1Q0FBdUM7UUFDckMsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDbkMsSUFBSSxDQUFDLE9BQU8sQ0FBQyx1QkFBdUIsQ0FBQztZQUNuQyxLQUFLLEVBQUUsNEJBQTRCO1NBQ3BDLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVELHNCQUFzQjtRQUNwQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsWUFBWSxDQUNwQyxrQkFBa0IsRUFDbEIsd0JBQWUsQ0FBQyxPQUFPLEVBQ3ZCLGVBQWUsRUFDZjtZQUNFLFdBQVcsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLFdBQVc7WUFDckMsV0FBVyxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsT0FBTyxDQUFDLFdBQVc7U0FDOUMsRUFDRCxTQUFTLEVBQ1QsNkJBQTZCLENBQzlCLENBQUM7SUFDSixDQUFDOztBQXhDSCw0REF5Q0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBCYXNlU2VydmljZSB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtZWNzXCI7XG5cbmltcG9ydCB7IE1ldHJpY0ZhY3RvcnksIE1ldHJpY1N0YXRpc3RpYyB9IGZyb20gXCIuLi8uLi9jb21tb25cIjtcblxuY29uc3QgRWNzQ29udGFpbmVySW5zaWdodHNOYW1lc3BhY2UgPSBcIkVDUy9Db250YWluZXJJbnNpZ2h0c1wiO1xuXG4vKipcbiAqIFByb3BzIHRvIGNyZWF0ZSBCYXNlU2VydmljZU1ldHJpY0ZhY3RvcnkuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgQmFzZVNlcnZpY2VNZXRyaWNGYWN0b3J5UHJvcHMge1xuICByZWFkb25seSBzZXJ2aWNlOiBCYXNlU2VydmljZTtcbn1cblxuLyoqXG4gKiBNZXRyaWMgZmFjdG9yeSBmb3IgYSBiYXNlIHNlcnZpY2UgKHBhcmVudCBjbGFzcyBmb3IgZS5nLiBGYXJnYXRlIGFuZCBFQzIgc2VydmljZXMpLlxuICovXG5leHBvcnQgY2xhc3MgQmFzZVNlcnZpY2VNZXRyaWNGYWN0b3J5IHtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IG1ldHJpY0ZhY3Rvcnk6IE1ldHJpY0ZhY3Rvcnk7XG4gIHByb3RlY3RlZCByZWFkb25seSBzZXJ2aWNlOiBCYXNlU2VydmljZTtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBtZXRyaWNGYWN0b3J5OiBNZXRyaWNGYWN0b3J5LFxuICAgIHByb3BzOiBCYXNlU2VydmljZU1ldHJpY0ZhY3RvcnlQcm9wc1xuICApIHtcbiAgICB0aGlzLm1ldHJpY0ZhY3RvcnkgPSBtZXRyaWNGYWN0b3J5O1xuICAgIHRoaXMuc2VydmljZSA9IHByb3BzLnNlcnZpY2U7XG4gIH1cblxuICBtZXRyaWNDbHVzdGVyQ3B1VXRpbGlzYXRpb25JblBlcmNlbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuc2VydmljZS5tZXRyaWNDcHVVdGlsaXphdGlvbih7XG4gICAgICAgIGxhYmVsOiBcIkNsdXN0ZXIgQ1BVIFV0aWxpemF0aW9uXCIsXG4gICAgICB9KVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNDbHVzdGVyTWVtb3J5VXRpbGlzYXRpb25JblBlcmNlbnQoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuc2VydmljZS5tZXRyaWNNZW1vcnlVdGlsaXphdGlvbih7XG4gICAgICAgIGxhYmVsOiBcIkNsdXN0ZXIgTWVtb3J5IFV0aWxpemF0aW9uXCIsXG4gICAgICB9KVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNSdW5uaW5nVGFza0NvdW50KCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkuY3JlYXRlTWV0cmljKFxuICAgICAgXCJSdW5uaW5nVGFza0NvdW50XCIsXG4gICAgICBNZXRyaWNTdGF0aXN0aWMuQVZFUkFHRSxcbiAgICAgIFwiUnVubmluZyBUYXNrc1wiLFxuICAgICAge1xuICAgICAgICBTZXJ2aWNlTmFtZTogdGhpcy5zZXJ2aWNlLnNlcnZpY2VOYW1lLFxuICAgICAgICBDbHVzdGVyTmFtZTogdGhpcy5zZXJ2aWNlLmNsdXN0ZXIuY2x1c3Rlck5hbWUsXG4gICAgICB9LFxuICAgICAgdW5kZWZpbmVkLFxuICAgICAgRWNzQ29udGFpbmVySW5zaWdodHNOYW1lc3BhY2VcbiAgICApO1xuICB9XG59XG4iXX0=