"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FargateServiceMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const aws_loadbalancing_1 = require("../aws-loadbalancing");
const BaseServiceMetricFactory_1 = require("./BaseServiceMetricFactory");
class FargateServiceMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        this.hasLoadBalancer =
            props.loadBalancer !== undefined && props.targetGroup !== undefined;
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.fargateService,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.metricFactory = scope.createMetricFactory();
        this.baseServiceMetricFactory = new BaseServiceMetricFactory_1.BaseServiceMetricFactory(this.metricFactory, { service: props.fargateService });
        if (this.hasLoadBalancer) {
            this.loadBalancerMetricFactory = aws_loadbalancing_1.createLoadBalancerMetricFactory(this.metricFactory, props.loadBalancer, props.targetGroup);
            this.healthyTaskCountMetric =
                this.loadBalancerMetricFactory.metricHealthyTaskCount();
            this.unhealthyTaskCountMetric =
                this.loadBalancerMetricFactory.metricUnhealthyTaskCount();
            this.healthyTaskPercentMetric =
                this.loadBalancerMetricFactory.metricHealthyTaskInPercent();
            this.activeTcpFlowCountMetric =
                this.loadBalancerMetricFactory.metricActiveConnectionCount();
            this.newTcpFlowCountMetric =
                this.loadBalancerMetricFactory.metricNewConnectionCount();
            this.processedBytesMetric =
                this.loadBalancerMetricFactory.metricProcessedBytesMin();
        }
        this.runningTaskCountMetric =
            this.baseServiceMetricFactory.metricRunningTaskCount();
        this.cpuUtilisationMetric =
            this.baseServiceMetricFactory.metricClusterCpuUtilisationInPercent();
        this.memoryUtilisationMetric =
            this.baseServiceMetricFactory.metricClusterMemoryUtilisationInPercent();
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.taskHealthAlarmFactory = new common_1.TaskHealthAlarmFactory(alarmFactory);
        this.throughputAlarmFactory = new common_1.ThroughputAlarmFactory(alarmFactory);
        this.taskHealthAnnotations = [];
        this.usageAlarmFactory = new common_1.UsageAlarmFactory(alarmFactory);
        this.cpuUsageAnnotations = [];
        this.memoryUsageAnnotations = [];
        this.processedBytesAnnotations = [];
        if (props.minAutoScalingTaskCount) {
            // TODO: use annotation strategy to create neutral annotation
            this.taskHealthAnnotations.push({
                value: props.minAutoScalingTaskCount,
                label: "AutoScaling: Min",
                color: common_1.NeutralColor,
            });
        }
        if (props.maxAutoScalingTaskCount) {
            // TODO: use annotation strategy to create neutral annotation
            this.taskHealthAnnotations.push({
                value: props.maxAutoScalingTaskCount,
                label: "AutoScaling: Max",
                color: common_1.NeutralColor,
            });
        }
        if (this.hasLoadBalancer) {
            for (const disambiguator in props.addHealthyTaskCountAlarm) {
                const alarmProps = props.addHealthyTaskCountAlarm[disambiguator];
                const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskCountAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.healthyTaskCountMetric, alarmProps, disambiguator);
                this.taskHealthAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addUnhealthyTaskCountAlarm) {
                const alarmProps = props.addUnhealthyTaskCountAlarm[disambiguator];
                const createdAlarm = this.taskHealthAlarmFactory.addUnhealthyTaskCountAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.unhealthyTaskCountMetric, alarmProps, disambiguator);
                this.taskHealthAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addHealthyTaskPercentAlarm) {
                const alarmProps = props.addHealthyTaskPercentAlarm[disambiguator];
                const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskPercentAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.healthyTaskPercentMetric, alarmProps, disambiguator);
                this.addAlarm(createdAlarm);
            }
        }
        for (const disambiguator in props.addRunningTaskCountAlarm) {
            const alarmProps = props.addRunningTaskCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addRunningTaskCountAlarm(this.runningTaskCountMetric, alarmProps, disambiguator);
            this.taskHealthAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addCpuUsageAlarm) {
            const alarmProps = props.addCpuUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxCpuUsagePercentAlarm(this.cpuUtilisationMetric, alarmProps, disambiguator);
            this.cpuUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMemoryUsageAlarm) {
            const alarmProps = props.addMemoryUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxMemoryUsagePercentAlarm(this.memoryUtilisationMetric, alarmProps, disambiguator);
            this.memoryUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        if (this.hasLoadBalancer) {
            for (const disambiguator in props.addMinProcessedBytesAlarm) {
                const alarmProps = props.addMinProcessedBytesAlarm[disambiguator];
                const createdAlarm = this.throughputAlarmFactory.addMinProcessedBytesAlarm(
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                this.processedBytesMetric, alarmProps, disambiguator);
                this.processedBytesAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createCpuWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createMemoryWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createTaskHealthWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        const baseWidget = [
            this.createTitleWidget(),
            this.createCpuWidget(this.hasLoadBalancer ? common_1.QuarterWidth : common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createMemoryWidget(this.hasLoadBalancer ? common_1.QuarterWidth : common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
        ];
        if (this.hasLoadBalancer) {
            return baseWidget.concat([
                this.createTpcFlowsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
                this.createTaskHealthWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            ]);
        }
        else {
            return baseWidget.concat(this.createTaskHealthWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight));
        }
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Fargate Service",
            title: this.title,
        });
    }
    createCpuWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "CPU Utilization",
            left: [this.cpuUtilisationMetric],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
            leftAnnotations: this.cpuUsageAnnotations,
        });
    }
    createMemoryWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Memory Utilization",
            left: [this.memoryUtilisationMetric],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
            leftAnnotations: this.memoryUsageAnnotations,
        });
    }
    createTaskHealthWidget(width, height) {
        const left = [this.runningTaskCountMetric];
        if (this.healthyTaskCountMetric) {
            left.push(this.healthyTaskCountMetric);
        }
        if (this.unhealthyTaskCountMetric) {
            left.push(this.unhealthyTaskCountMetric);
        }
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: this.hasLoadBalancer ? "Task Health" : "Task Count",
            left,
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.taskHealthAnnotations,
        });
    }
    createTpcFlowsWidget(width, height) {
        const left = [];
        const right = [];
        if (this.activeTcpFlowCountMetric) {
            left.push(this.activeTcpFlowCountMetric);
        }
        if (this.newTcpFlowCountMetric) {
            left.push(this.newTcpFlowCountMetric);
        }
        if (this.processedBytesMetric) {
            right.push(this.processedBytesMetric);
        }
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "TCP Flows",
            left,
            leftYAxis: common_1.CountAxisFromZero,
            right,
            rightYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
}
exports.FargateServiceMonitoring = FargateServiceMonitoring;
_a = JSII_RTTI_SYMBOL_1;
FargateServiceMonitoring[_a] = { fqn: "cdk-monitoring-constructs.FargateServiceMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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