import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, ElastiCacheAlarmFactory, MaxItemsCountThreshold, MaxUsedSwapMemoryThreshold, MetricWithAlarmSupport, MinFreeableMemoryThreshold, Monitoring, MonitoringScope, UsageAlarmFactory, UsageThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { ElastiCacheClusterMetricFactoryProps, ElastiCacheClusterType } from "./ElastiCacheClusterMetricFactory";
export interface ElastiCacheClusterMonitoringOptions extends BaseMonitoringProps {
    /**
     * Cluster type (needed, since each type has their own specific metrics)
     */
    readonly clusterType: ElastiCacheClusterType;
    /**
     * Add CPU usage alarm
     */
    readonly addCpuUsageAlarm?: Record<string, UsageThreshold>;
    /**
     * Add alarm on total number of items
     */
    readonly addMaxItemsCountAlarm?: Record<string, MaxItemsCountThreshold>;
    /**
     * Add alarm on number of evicted items
     */
    readonly addMaxEvictedItemsCountAlarm?: Record<string, MaxItemsCountThreshold>;
    /**
     * Add alarm on amount of freeable memory
     */
    readonly addMinFreeableMemoryAlarm?: Record<string, MinFreeableMemoryThreshold>;
    /**
     * Add alarm on amount of used swap memory
     */
    readonly addMaxUsedSwapMemoryAlarm?: Record<string, MaxUsedSwapMemoryThreshold>;
}
export interface ElastiCacheClusterMonitoringProps extends ElastiCacheClusterMetricFactoryProps, ElastiCacheClusterMonitoringOptions {
}
export declare class ElastiCacheClusterMonitoring extends Monitoring {
    readonly title: string;
    readonly clusterUrl?: string;
    readonly connectionsMetric: MetricWithAlarmSupport;
    readonly cpuUsageMetric: MetricWithAlarmSupport;
    readonly freeableMemoryMetric: MetricWithAlarmSupport;
    readonly unusedMemoryMetric: MetricWithAlarmSupport;
    readonly swapMemoryMetric: MetricWithAlarmSupport;
    readonly itemsMemoryMetric: MetricWithAlarmSupport;
    readonly itemsCountMetrics: MetricWithAlarmSupport;
    readonly itemsEvictedMetrics: MetricWithAlarmSupport;
    readonly usageAlarmFactory: UsageAlarmFactory;
    readonly elastiCacheAlarmFactory: ElastiCacheAlarmFactory;
    readonly cpuUsageAnnotations: HorizontalAnnotation[];
    readonly itemsCountAnnotations: HorizontalAnnotation[];
    readonly evictedItemsCountAnnotations: HorizontalAnnotation[];
    readonly memoryUsageAnnotations: HorizontalAnnotation[];
    constructor(scope: MonitoringScope, props: ElastiCacheClusterMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    createTitleWidget(): MonitoringHeaderWidget;
    createCpuUsageWidget(width: number, height: number): GraphWidget;
    createMemoryUsageWidget(width: number, height: number): GraphWidget;
    createItemCountWidget(width: number, height: number): GraphWidget;
    createConnectionsWidget(width: number, height: number): GraphWidget;
}
