"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ElastiCacheClusterMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const ElastiCacheClusterMetricFactory_1 = require("./ElastiCacheClusterMetricFactory");
class ElastiCacheClusterMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const clusterType = common_1.capitalizeFirstLetterOnly(ElastiCacheClusterMetricFactory_1.ElastiCacheClusterType[props.clusterType]);
        const fallbackConstructName = [clusterType, props.clusterId ?? "ALL"].join("-");
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        if (props.clusterId) {
            this.clusterUrl = scope
                .createAwsConsoleUrlFactory()
                .getElastiCacheClusterUrl(props.clusterId, props.clusterType);
        }
        const metricFactory = new ElastiCacheClusterMetricFactory_1.ElastiCacheClusterMetricFactory(scope.createMetricFactory(), props);
        this.connectionsMetric = metricFactory.metricAverageConnections();
        this.cpuUsageMetric = metricFactory.metricMaxCpuUtilizationInPercent();
        this.freeableMemoryMetric =
            metricFactory.metricAverageFreeableMemoryInBytes();
        this.unusedMemoryMetric = metricFactory.metricAverageUnusedMemoryInBytes();
        this.swapMemoryMetric = metricFactory.metricAverageSwapUsageInBytes();
        this.itemsMemoryMetric =
            metricFactory.metricAverageCachedItemsSizeInBytes();
        this.itemsCountMetrics = metricFactory.metricMaxItemCount();
        this.itemsEvictedMetrics = metricFactory.metricEvictions();
        this.cpuUsageAnnotations = [];
        this.itemsCountAnnotations = [];
        this.evictedItemsCountAnnotations = [];
        this.memoryUsageAnnotations = [];
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.usageAlarmFactory = new common_1.UsageAlarmFactory(alarmFactory);
        this.elastiCacheAlarmFactory = new common_1.ElastiCacheAlarmFactory(alarmFactory);
        for (const disambiguator in props.addCpuUsageAlarm) {
            const alarmProps = props.addCpuUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxCpuUsagePercentAlarm(this.cpuUsageMetric, alarmProps, disambiguator);
            this.cpuUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxItemsCountAlarm) {
            const alarmProps = props.addMaxItemsCountAlarm[disambiguator];
            const createdAlarm = this.elastiCacheAlarmFactory.addMaxItemsCountAlarm(this.itemsCountMetrics, alarmProps, disambiguator);
            this.itemsCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxEvictedItemsCountAlarm) {
            const alarmProps = props.addMaxEvictedItemsCountAlarm[disambiguator];
            const createdAlarm = this.elastiCacheAlarmFactory.addMaxEvictedItemsCountAlarm(this.itemsEvictedMetrics, alarmProps, disambiguator);
            this.evictedItemsCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMinFreeableMemoryAlarm) {
            const alarmProps = props.addMinFreeableMemoryAlarm[disambiguator];
            const createdAlarm = this.elastiCacheAlarmFactory.addMinFreeableMemoryAlarm(this.freeableMemoryMetric, alarmProps, disambiguator);
            this.memoryUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxUsedSwapMemoryAlarm) {
            const alarmProps = props.addMaxUsedSwapMemoryAlarm[disambiguator];
            const createdAlarm = this.elastiCacheAlarmFactory.addMaxUsedSwapMemoryAlarm(this.swapMemoryMetric, alarmProps, disambiguator);
            this.memoryUsageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createCpuUsageWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createMemoryUsageWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createItemCountWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createCpuUsageWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createMemoryUsageWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createConnectionsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createItemCountWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "ElastiCache Cluster",
            title: this.title,
            goToLinkUrl: this.clusterUrl,
        });
    }
    createCpuUsageWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "CPU Utilization",
            left: [this.cpuUsageMetric],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
            leftAnnotations: this.cpuUsageAnnotations,
        });
    }
    createMemoryUsageWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Memory Utilization",
            left: [
                this.freeableMemoryMetric,
                this.unusedMemoryMetric,
                this.swapMemoryMetric,
            ],
            leftYAxis: common_1.SizeAxisBytesFromZero,
            leftAnnotations: this.memoryUsageAnnotations,
        });
    }
    createItemCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Items",
            left: [this.itemsCountMetrics],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.itemsCountAnnotations,
            right: [this.itemsEvictedMetrics],
            rightYAxis: common_1.CountAxisFromZero,
            rightAnnotations: this.evictedItemsCountAnnotations,
        });
    }
    createConnectionsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Connections",
            left: [this.connectionsMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
}
exports.ElastiCacheClusterMonitoring = ElastiCacheClusterMonitoring;
_a = JSII_RTTI_SYMBOL_1;
ElastiCacheClusterMonitoring[_a] = { fqn: "cdk-monitoring-constructs.ElastiCacheClusterMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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