"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GlueJobMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const GlueNamespace = "Glue";
class GlueJobMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.rateComputationMethod =
            props.rateComputationMethod ?? common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            Type: "gauge",
            JobRunId: "ALL",
            JobName: props.jobName,
        };
        this.typeCountDimensionsMap = {
            ...this.dimensionsMap,
            Type: "count",
        };
    }
    metricTotalReadBytesFromS3() {
        return this.metricFactory.createMetric("glue.ALL.s3.filesystem.read_bytes", common_1.MetricStatistic.SUM, "Read (S3)", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricTotalWrittenBytesToS3() {
        return this.metricFactory.createMetric("glue.ALL.s3.filesystem.write_bytes", common_1.MetricStatistic.SUM, "Write (S3)", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricAverageExecutorCpuUsagePercentage() {
        const label = "CPU Usage (executor average)";
        const metric = this.metricFactory.createMetric("glue.ALL.system.cpuSystemLoad", common_1.MetricStatistic.AVERAGE, label, this.dimensionsMap, undefined, GlueNamespace);
        return this.metricFactory.multiplyMetric(metric, 100, label, "cpu");
    }
    metricAverageExecutorMemoryUsagePercentage() {
        const label = "JVM Heap usage (executor average)";
        const metric = this.metricFactory.createMetric("glue.ALL.jvm.heap.usage", common_1.MetricStatistic.AVERAGE, label, this.dimensionsMap, undefined, GlueNamespace);
        return this.metricFactory.multiplyMetric(metric, 100, label, "heap");
    }
    metricActiveExecutorsAverage() {
        return this.metricFactory.createMetric("glue.driver.ExecutorAllocationManager.executors.numberAllExecutors", common_1.MetricStatistic.AVERAGE, "Active Executors", this.dimensionsMap, undefined, GlueNamespace);
    }
    metricCompletedStagesSum() {
        return this.metricFactory.createMetric("glue.driver.aggregate.numCompletedStages", common_1.MetricStatistic.SUM, "Completed Stages", this.typeCountDimensionsMap, undefined, GlueNamespace);
    }
    metricCompletedTasksSum() {
        return this.metricFactory.createMetric("glue.driver.aggregate.numCompletedTasks", common_1.MetricStatistic.SUM, "Completed Tasks", this.typeCountDimensionsMap, undefined, GlueNamespace);
    }
    metricFailedTasksSum() {
        return this.metricFactory.createMetric("glue.driver.aggregate.numFailedTasks", common_1.MetricStatistic.SUM, "Failed Tasks", this.typeCountDimensionsMap, undefined, GlueNamespace);
    }
    metricFailedTasksRate() {
        return this.metricFactory.toRate(this.metricFailedTasksSum(), this.rateComputationMethod, true, "killed", false);
    }
    metricKilledTasksSum() {
        return this.metricFactory.createMetric("glue.driver.aggregate.numKilledTasks", common_1.MetricStatistic.SUM, "Killed Tasks", this.typeCountDimensionsMap, undefined, GlueNamespace);
    }
    metricKilledTasksRate() {
        return this.metricFactory.toRate(this.metricKilledTasksSum(), this.rateComputationMethod, true, "killed", false);
    }
    metricMaximumNeededExecutors() {
        return this.metricFactory.createMetric("glue.driver.ExecutorAllocationManager.executors.numberMaxNeededExecutors", common_1.MetricStatistic.MAX, "Maximum Needed Executors", this.dimensionsMap, undefined, GlueNamespace);
    }
}
exports.GlueJobMetricFactory = GlueJobMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
GlueJobMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.GlueJobMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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