"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisDataStreamMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const KinesisDataStreamMetricFactory_1 = require("./KinesisDataStreamMetricFactory");
class KinesisDataStreamMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName: props.streamName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.streamUrl = scope
            .createAwsConsoleUrlFactory()
            .getKinesisDataStreamUrl(props.streamName);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.kinesisAlarmFactory = new common_1.KinesisAlarmFactory(alarmFactory);
        this.provisionedCapacityAnnotations = [];
        this.ageAnnotations = [];
        this.recordCountAnnotations = [];
        const metricFactory = new KinesisDataStreamMetricFactory_1.KinesisDataStreamMetricFactory(scope.createMetricFactory(), props);
        this.metricGetRecordSumBytes = metricFactory.metricGetRecordsSumBytes();
        this.metricGetRecordsIteratorAge =
            metricFactory.metricGetRecordsIteratorAgeMaxMs();
        this.metricGetRecordsLatencyAverage =
            metricFactory.metricGetRecordsLatencyAverageMs();
        this.metricGetRecordsSumCount = metricFactory.metricGetRecordsSumCount();
        this.metricGetRecordsSuccessCount =
            metricFactory.metricGetRecordsSuccessCount();
        this.incomingDataSumBytesMetric =
            metricFactory.metricIncomingDataSumBytes();
        this.incomingDataSumCountMetric =
            metricFactory.metricIncomingDataSumCount();
        this.putRecordSumBytesMetric = metricFactory.metricPutRecordSumBytes();
        this.putRecordLatencyAverageMetric =
            metricFactory.metricPutRecordLatencyAverageMs();
        this.putRecordSuccessCountMetric =
            metricFactory.metricPutRecordSuccessCount();
        this.putRecordsSumBytesMetric = metricFactory.metricPutRecordsSumBytes();
        this.putRecordsLatencyAverageMetric =
            metricFactory.metricPutRecordsLatencyAverageMs();
        this.putRecordsSuccessCountMetric =
            metricFactory.metricPutRecordsSuccessCount();
        this.putRecordsTotalRecordsCountMetric =
            metricFactory.metricPutRecordsTotalRecordsCount();
        this.putRecordsSuccessfulRecordsCountMetric =
            metricFactory.metricPutRecordsSuccessfulRecordsCount();
        this.putRecordsThrottledRecordsCountMetric =
            metricFactory.metricPutRecordsThrottledRecordsCount();
        this.putRecordsFailedRecordsCountMetric =
            metricFactory.metricPutRecordsFailedRecordsCount();
        this.readProvisionedThroughputExceededMetric =
            metricFactory.metricReadProvisionedThroughputExceededPercent();
        this.writeProvisionedThroughputExceededMetric =
            metricFactory.metricWriteProvisionedThroughputExceededPercent();
        for (const disambiguator in props.addIteratorMaxAgeAlarm) {
            const alarmProps = props.addIteratorMaxAgeAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addIteratorMaxAgeAlarm(this.metricGetRecordsIteratorAge, alarmProps, disambiguator);
            this.ageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addPutRecordsThrottledAlarm) {
            const alarmProps = props.addPutRecordsThrottledAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addPutRecordsThrottledAlarm(this.putRecordsThrottledRecordsCountMetric, alarmProps, disambiguator);
            this.recordCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addPutRecordsFailedAlarm) {
            const alarmProps = props.addPutRecordsFailedAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addPutRecordsFailedAlarm(this.putRecordsFailedRecordsCountMetric, alarmProps, disambiguator);
            this.recordCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addReadProvisionedThroughputExceededAlarm) {
            const alarmProps = props.addReadProvisionedThroughputExceededAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addProvisionedReadThroughputExceededAlarm(this.readProvisionedThroughputExceededMetric, alarmProps, disambiguator);
            this.provisionedCapacityAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addWriteProvisionedThroughputExceededAlarm) {
            const alarmProps = props.addWriteProvisionedThroughputExceededAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addProvisionedWriteThroughputExceededAlarm(this.writeProvisionedThroughputExceededMetric, alarmProps, disambiguator);
            this.provisionedCapacityAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createIncomingDataWidget(common_1.QuarterWidth, common_1.DefaultSummaryWidgetHeight), this.createIteratorAgeWidget(common_1.QuarterWidth, common_1.DefaultSummaryWidgetHeight), this.createLatencyWidget(common_1.QuarterWidth, common_1.DefaultSummaryWidgetHeight), this.createCapacityWidget(common_1.QuarterWidth, common_1.DefaultSummaryWidgetHeight)),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createIncomingDataWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createIteratorAgeWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createLatencyWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createCapacityWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight)),
            this.createFirstAdditionalRow(),
            this.createSecondAdditionalRow(),
        ];
    }
    createFirstAdditionalRow() {
        return new aws_cloudwatch_1.Row(this.createRecordSizeWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight), this.createOperationWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight));
    }
    createSecondAdditionalRow() {
        return new aws_cloudwatch_1.Row(this.createRecordNumberWidget(common_1.FullWidth, common_1.DefaultGraphWidgetHeight));
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Kinesis Data Stream",
            title: this.title,
            goToLinkUrl: this.streamUrl,
        });
    }
    createIncomingDataWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Incoming",
            left: [this.incomingDataSumCountMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createIteratorAgeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Iterator",
            left: [this.metricGetRecordsIteratorAge],
            leftAnnotations: this.ageAnnotations,
            leftYAxis: common_1.TimeAxisMillisFromZero,
        });
    }
    createLatencyWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Latency (Average)",
            left: [
                this.metricGetRecordsLatencyAverage,
                this.putRecordLatencyAverageMetric,
                this.putRecordsLatencyAverageMetric,
            ],
            leftYAxis: common_1.TimeAxisMillisFromZero,
        });
    }
    createCapacityWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Provisioned Capacity Exceeded",
            left: [
                this.readProvisionedThroughputExceededMetric,
                this.writeProvisionedThroughputExceededMetric,
            ],
            leftYAxis: common_1.TimeAxisMillisFromZero,
            leftAnnotations: this.provisionedCapacityAnnotations,
        });
    }
    createRecordSizeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Bytes",
            left: [
                this.metricGetRecordSumBytes,
                this.putRecordSumBytesMetric,
                this.putRecordsSumBytesMetric,
            ],
            leftYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
    createOperationWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Successful Operations",
            left: [
                this.metricGetRecordsSuccessCount,
                this.putRecordSuccessCountMetric,
                this.putRecordsSuccessCountMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createRecordNumberWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Records",
            left: [
                this.metricGetRecordsSumCount,
                this.putRecordsTotalRecordsCountMetric,
                this.putRecordsSuccessfulRecordsCountMetric,
                this.putRecordsFailedRecordsCountMetric,
                this.putRecordsThrottledRecordsCountMetric,
            ],
            leftAnnotations: this.recordCountAnnotations,
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
}
exports.KinesisDataStreamMonitoring = KinesisDataStreamMonitoring;
_a = JSII_RTTI_SYMBOL_1;
KinesisDataStreamMonitoring[_a] = { fqn: "cdk-monitoring-constructs.KinesisDataStreamMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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