"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisFirehoseMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const FirehoseNamespace = "AWS/Firehose";
/**
 * @see https://docs.aws.amazon.com/firehose/latest/dev/monitoring-with-cloudwatch-metrics.html
 */
class KinesisFirehoseMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.dimensionsMap = {
            DeliveryStreamName: props.deliveryStreamName,
        };
    }
    metricSuccessfulConversionCount() {
        return this.metricFactory.createMetric("SucceedConversion.Records", common_1.MetricStatistic.SUM, "Succeed", this.dimensionsMap, undefined, FirehoseNamespace);
    }
    metricFailedConversionCount() {
        return this.metricFactory.createMetric("FailedConversion.Records", common_1.MetricStatistic.SUM, "Failed", this.dimensionsMap, undefined, FirehoseNamespace);
    }
    metricIncomingBytes() {
        return this.metricFactory.createMetric("IncomingBytes", common_1.MetricStatistic.SUM, "Incoming (bytes)", this.dimensionsMap, undefined, FirehoseNamespace);
    }
    metricIncomingPutRequests() {
        return this.metricFactory.createMetric("IncomingPutRequests", common_1.MetricStatistic.SUM, "Incoming (PutRequest)", this.dimensionsMap, undefined, FirehoseNamespace);
    }
    metricIncomingRecordCount() {
        return this.metricFactory.createMetric("IncomingRecords", common_1.MetricStatistic.SUM, "Incoming", this.dimensionsMap, undefined, FirehoseNamespace);
    }
    metricThrottledRecordCount() {
        return this.metricFactory.createMetric("ThrottledRecords", common_1.MetricStatistic.SUM, "Throttled", this.dimensionsMap, undefined, FirehoseNamespace);
    }
    metricPutRecordLatencyP90InMillis() {
        return this.metricFactory.createMetric("PutRecord.Latency", common_1.MetricStatistic.P90, "PutRecord P90", this.dimensionsMap, undefined, FirehoseNamespace);
    }
    metricPutRecordBatchLatencyP90InMillis() {
        return this.metricFactory.createMetric("PutRecordBatch.Latency", common_1.MetricStatistic.P90, "PutRecordBatch P90", this.dimensionsMap, undefined, FirehoseNamespace);
    }
    metricIncomingBytesToLimitRate() {
        return this.metricFactory.createMetricMath("(bytes_in / PERIOD(bytes_in)) / bytes_max", {
            bytes_in: this.metricIncomingBytes(),
            bytes_max: this.metricBytesPerSecondLimit(),
        }, "Incoming Bytes / Limit");
    }
    metricIncomingRecordsToLimitRate() {
        return this.metricFactory.createMetricMath("(records_in / PERIOD(records_in)) / records_max", {
            records_in: this.metricIncomingRecordCount(),
            records_max: this.metricRecordsPerSecondLimit(),
        }, "Incoming Records / Limit");
    }
    metricIncomingPutRequestsToLimitRate() {
        return this.metricFactory.createMetricMath("(requests_in / PERIOD(requests_in)) / requests_max", {
            requests_in: this.metricIncomingPutRequests(),
            requests_max: this.metricPutRequestsPerSecondLimit(),
        }, "Incoming PutRequests / Limit");
    }
    metricBytesPerSecondLimit() {
        return this.metricFactory.createMetric("BytesPerSecondLimit", common_1.MetricStatistic.AVERAGE, "Incoming Bytes/s Limit", undefined, undefined, FirehoseNamespace);
    }
    metricRecordsPerSecondLimit() {
        return this.metricFactory.createMetric("RecordsPerSecondLimit", common_1.MetricStatistic.AVERAGE, "Records/s Limit", undefined, undefined, FirehoseNamespace);
    }
    metricPutRequestsPerSecondLimit() {
        return this.metricFactory.createMetric("PutRequestsPerSecondLimit", common_1.MetricStatistic.AVERAGE, "PutRequests/s Limit", undefined, undefined, FirehoseNamespace);
    }
}
exports.KinesisFirehoseMetricFactory = KinesisFirehoseMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
KinesisFirehoseMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.KinesisFirehoseMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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