import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { BaseMonitoringProps, KinesisAlarmFactory, MetricWithAlarmSupport, Monitoring, MonitoringScope, RecordsThrottledThreshold } from "../../common";
import { MonitoringHeaderWidget } from "../../dashboard";
import { KinesisFirehoseMetricFactoryProps } from "./KinesisFirehoseMetricFactory";
export interface KinesisFirehoseMonitoringOptions extends BaseMonitoringProps {
    readonly addRecordsThrottledAlarm?: Record<string, RecordsThrottledThreshold>;
}
export interface KinesisFirehoseMonitoringProps extends KinesisFirehoseMetricFactoryProps, KinesisFirehoseMonitoringOptions {
}
export declare class KinesisFirehoseMonitoring extends Monitoring {
    readonly title: string;
    readonly streamUrl?: string;
    readonly kinesisAlarmFactory: KinesisAlarmFactory;
    readonly recordCountAnnotations: HorizontalAnnotation[];
    readonly incomingBytesMetric: MetricWithAlarmSupport;
    readonly incomingRecordsMetric: MetricWithAlarmSupport;
    readonly throttledRecordsMetric: MetricWithAlarmSupport;
    readonly successfulConversionMetric: MetricWithAlarmSupport;
    readonly failedConversionMetric: MetricWithAlarmSupport;
    readonly putRecordLatency: MetricWithAlarmSupport;
    readonly putRecordBatchLatency: MetricWithAlarmSupport;
    readonly incomingBytesToLimitRate: MetricWithAlarmSupport;
    readonly incomingRecordsToLimitRate: MetricWithAlarmSupport;
    readonly incomingPutRequestsToLimitRate: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: KinesisFirehoseMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    createTitleWidget(): MonitoringHeaderWidget;
    createIncomingRecordWidget(width: number, height: number): GraphWidget;
    createLatencyWidget(width: number, height: number): GraphWidget;
    createConversionWidget(width: number, height: number): GraphWidget;
    createLimitWidget(width: number, height: number): GraphWidget;
}
