"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.KinesisFirehoseMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const KinesisFirehoseMetricFactory_1 = require("./KinesisFirehoseMetricFactory");
class KinesisFirehoseMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName: props.deliveryStreamName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.streamUrl = scope
            .createAwsConsoleUrlFactory()
            .getKinesisFirehoseDeliveryStreamUrl(props.deliveryStreamName);
        const metricFactory = new KinesisFirehoseMetricFactory_1.KinesisFirehoseMetricFactory(scope.createMetricFactory(), props);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.kinesisAlarmFactory = new common_1.KinesisAlarmFactory(alarmFactory);
        this.recordCountAnnotations = [];
        this.incomingBytesMetric = metricFactory.metricIncomingBytes();
        this.incomingRecordsMetric = metricFactory.metricIncomingRecordCount();
        this.throttledRecordsMetric = metricFactory.metricThrottledRecordCount();
        this.successfulConversionMetric =
            metricFactory.metricSuccessfulConversionCount();
        this.failedConversionMetric = metricFactory.metricFailedConversionCount();
        this.putRecordLatency = metricFactory.metricPutRecordLatencyP90InMillis();
        this.putRecordBatchLatency =
            metricFactory.metricPutRecordBatchLatencyP90InMillis();
        this.incomingBytesToLimitRate =
            metricFactory.metricIncomingBytesToLimitRate();
        this.incomingRecordsToLimitRate =
            metricFactory.metricIncomingRecordsToLimitRate();
        this.incomingPutRequestsToLimitRate =
            metricFactory.metricIncomingPutRequestsToLimitRate();
        for (const disambiguator in props.addRecordsThrottledAlarm) {
            const alarmProps = props.addRecordsThrottledAlarm[disambiguator];
            const createdAlarm = this.kinesisAlarmFactory.addPutRecordsThrottledAlarm(this.throttledRecordsMetric, alarmProps, disambiguator);
            this.recordCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createIncomingRecordWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            this.createConversionWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createIncomingRecordWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createLatencyWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createConversionWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createLimitWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Firehose Delivery Stream",
            title: this.title,
            goToLinkUrl: this.streamUrl,
        });
    }
    createIncomingRecordWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Records",
            left: [this.incomingRecordsMetric, this.throttledRecordsMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.recordCountAnnotations,
        });
    }
    createLatencyWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Latency (P90)",
            left: [this.putRecordLatency, this.putRecordBatchLatency],
            leftYAxis: common_1.TimeAxisMillisFromZero,
        });
    }
    createConversionWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Conversions",
            left: [this.successfulConversionMetric, this.failedConversionMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createLimitWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Limits (rate)",
            left: [
                this.incomingBytesToLimitRate.with({ label: "Bytes" }),
                this.incomingRecordsToLimitRate.with({ label: "Records" }),
                this.incomingPutRequestsToLimitRate.with({ label: "PutRequests" }),
            ],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: [{ value: 1, label: "100% usage" }],
        });
    }
}
exports.KinesisFirehoseMonitoring = KinesisFirehoseMonitoring;
_a = JSII_RTTI_SYMBOL_1;
KinesisFirehoseMonitoring[_a] = { fqn: "cdk-monitoring-constructs.KinesisFirehoseMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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