"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
class LambdaFunctionMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.lambdaFunction = props.lambdaFunction;
        this.fillTpsWithZeroes = props.fillTpsWithZeroes ?? true;
        this.rateComputationMethod =
            props.rateComputationMethod ?? common_1.RateComputationMethod.AVERAGE;
    }
    /**
     * @deprecated use metricInvocationRate
     */
    metricTps() {
        return this.metricFactory.toRate(this.metricInvocationCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests", this.fillTpsWithZeroes);
    }
    metricInvocationRate() {
        return this.metricFactory.toRate(this.metricInvocationCount(), this.rateComputationMethod, false, "requests", this.fillTpsWithZeroes);
    }
    metricInvocationCount() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricInvocations({
            label: "Invocations",
        }));
    }
    metricThrottlesCount() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricThrottles({
            label: "Throttles",
        }));
    }
    metricThrottlesRate() {
        const metric = this.metricThrottlesCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "throttles");
    }
    metricFaultCount() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricErrors({
            label: "Faults",
        }));
    }
    metricFaultRate() {
        const metric = this.metricFaultCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    metricLatencyP99InMillis() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricDuration({
            statistic: common_1.MetricStatistic.P99,
            label: "P99",
        }));
    }
    metricLatencyP90InMillis() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricDuration({
            statistic: common_1.MetricStatistic.P90,
            label: "P90",
        }));
    }
    metricLatencyP50InMillis() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metricDuration({
            statistic: common_1.MetricStatistic.P50,
            label: "P50",
        }));
    }
    metricConcurrentExecutions() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metric("ConcurrentExecutions", {
            statistic: common_1.MetricStatistic.MAX,
            label: "Concurrent",
        }));
    }
    metricProvisionedConcurrencySpilloverInvocations() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metric("ProvisionedConcurrencySpilloverInvocations", {
            statistic: common_1.MetricStatistic.SUM,
            label: "Provisioned Concurrency Spillovers",
        }));
    }
    metricProvisionedConcurrencySpilloverRate() {
        const metric = this.metricProvisionedConcurrencySpilloverInvocations();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "pcsi");
    }
    metricMaxIteratorAgeInMillis() {
        return this.metricFactory.adaptMetric(this.lambdaFunction.metric("IteratorAge", {
            statistic: common_1.MetricStatistic.MAX,
            label: "Iterator Age",
        }));
    }
}
exports.LambdaFunctionMetricFactory = LambdaFunctionMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.LambdaFunctionMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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