import { GraphWidget, HorizontalAnnotation, IWidget } from "aws-cdk-lib/aws-cloudwatch";
import { AgeAlarmFactory, AlarmFactory, BaseMonitoringProps, DurationThreshold, ErrorAlarmFactory, ErrorCountThreshold, ErrorRateThreshold, HighTpsThreshold, LatencyAlarmFactory, LatencyThreshold, LowTpsThreshold, MaxAgeThreshold, MetricWithAlarmSupport, MinUsageCountThreshold, Monitoring, MonitoringScope, RunningTaskCountThreshold, RunningTaskRateThreshold, TaskHealthAlarmFactory, TpsAlarmFactory, UsageAlarmFactory, UsageThreshold } from "../../common";
import { MonitoringHeaderWidget, MonitoringNamingStrategy } from "../../dashboard";
import { LambdaFunctionEnhancedMetricFactory } from "./LambdaFunctionEnhancedMetricFactory";
import { LambdaFunctionMetricFactory, LambdaFunctionMetricFactoryProps } from "./LambdaFunctionMetricFactory";
export interface LambdaFunctionMonitoringOptions extends BaseMonitoringProps {
    readonly addLatencyP50Alarm?: Record<string, LatencyThreshold>;
    readonly addLatencyP90Alarm?: Record<string, LatencyThreshold>;
    readonly addLatencyP99Alarm?: Record<string, LatencyThreshold>;
    readonly addFaultCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addFaultRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addLowTpsAlarm?: Record<string, LowTpsThreshold>;
    readonly addHighTpsAlarm?: Record<string, HighTpsThreshold>;
    readonly addThrottlesCountAlarm?: Record<string, ErrorCountThreshold>;
    readonly addThrottlesRateAlarm?: Record<string, ErrorRateThreshold>;
    readonly addMinInvocationsCountAlarm?: Record<string, MinUsageCountThreshold>;
    readonly addConcurrentExecutionsCountAlarm?: Record<string, RunningTaskCountThreshold>;
    readonly addProvisionedConcurrencySpilloverInvocationsCountAlarm?: Record<string, RunningTaskCountThreshold>;
    readonly addProvisionedConcurrencySpilloverInvocationsRateAlarm?: Record<string, RunningTaskRateThreshold>;
    readonly addMaxIteratorAgeAlarm?: Record<string, MaxAgeThreshold>;
    readonly addEnhancedMonitoringMaxCpuTotalTimeAlarm?: Record<string, DurationThreshold>;
    readonly addEnhancedMonitoringP90CpuTotalTimeAlarm?: Record<string, DurationThreshold>;
    readonly addEnhancedMonitoringAvgCpuTotalTimeAlarm?: Record<string, DurationThreshold>;
    readonly addEnhancedMonitoringMaxMemoryUtilizationAlarm?: Record<string, UsageThreshold>;
    readonly addEnhancedMonitoringP90MemoryUtilizationAlarm?: Record<string, UsageThreshold>;
    readonly addEnhancedMonitoringAvgMemoryUtilizationAlarm?: Record<string, UsageThreshold>;
}
export interface LambdaFunctionMonitoringProps extends LambdaFunctionMetricFactoryProps, LambdaFunctionMonitoringOptions {
}
export declare class LambdaFunctionMonitoring extends Monitoring {
    readonly title: string;
    readonly functionUrl?: string;
    readonly namingStrategy: MonitoringNamingStrategy;
    readonly metricFactory: LambdaFunctionMetricFactory;
    readonly alarmFactory: AlarmFactory;
    readonly errorAlarmFactory: ErrorAlarmFactory;
    readonly latencyAlarmFactory: LatencyAlarmFactory;
    readonly tpsAlarmFactory: TpsAlarmFactory;
    readonly taskHealthAlarmFactory: TaskHealthAlarmFactory;
    readonly ageAlarmFactory: AgeAlarmFactory;
    readonly usageAlarmFactory: UsageAlarmFactory;
    readonly latencyAnnotations: HorizontalAnnotation[];
    readonly errorCountAnnotations: HorizontalAnnotation[];
    readonly errorRateAnnotations: HorizontalAnnotation[];
    readonly invocationCountAnnotations: HorizontalAnnotation[];
    readonly invocationRateAnnotations: HorizontalAnnotation[];
    readonly tpsAnnotations: HorizontalAnnotation[];
    readonly cpuTotalTimeAnnotations: HorizontalAnnotation[];
    readonly memoryUsageAnnotations: HorizontalAnnotation[];
    readonly maxIteratorAgeAnnotations: HorizontalAnnotation[];
    readonly tpsMetric: MetricWithAlarmSupport;
    readonly p50LatencyMetric: MetricWithAlarmSupport;
    readonly p90LatencyMetric: MetricWithAlarmSupport;
    readonly p99LatencyMetric: MetricWithAlarmSupport;
    readonly faultCountMetric: MetricWithAlarmSupport;
    readonly faultRateMetric: MetricWithAlarmSupport;
    readonly invocationCountMetric: MetricWithAlarmSupport;
    readonly throttlesCountMetric: MetricWithAlarmSupport;
    readonly throttlesRateMetric: MetricWithAlarmSupport;
    readonly concurrentExecutionsCountMetric: MetricWithAlarmSupport;
    readonly provisionedConcurrencySpilloverInvocationsCountMetric: MetricWithAlarmSupport;
    readonly provisionedConcurrencySpilloverInvocationsRateMetric: MetricWithAlarmSupport;
    readonly maxIteratorAgeMetric: MetricWithAlarmSupport;
    readonly lambdaInsightsEnabled: boolean;
    readonly enhancedMetricFactory?: LambdaFunctionEnhancedMetricFactory;
    readonly enhancedMonitoringMaxCpuTotalTimeMetric?: MetricWithAlarmSupport;
    readonly enhancedMonitoringP90CpuTotalTimeMetric?: MetricWithAlarmSupport;
    readonly enhancedMonitoringAvgCpuTotalTimeMetric?: MetricWithAlarmSupport;
    readonly enhancedMonitoringMaxMemoryUtilizationMetric?: MetricWithAlarmSupport;
    readonly enhancedMonitoringP90MemoryUtilizationMetric?: MetricWithAlarmSupport;
    readonly enhancedMonitoringAvgMemoryUtilizationMetric?: MetricWithAlarmSupport;
    readonly enhancedMetricFunctionCostMetric?: MetricWithAlarmSupport;
    constructor(scope: MonitoringScope, props: LambdaFunctionMonitoringProps);
    summaryWidgets(): IWidget[];
    widgets(): IWidget[];
    createTitleWidget(): MonitoringHeaderWidget;
    createTpsWidget(width: number, height: number): GraphWidget;
    createLatencyWidget(width: number, height: number): GraphWidget;
    createErrorCountWidget(width: number, height: number): GraphWidget;
    createErrorRateWidget(width: number, height: number): GraphWidget;
    createRateWidget(width: number, height: number): GraphWidget;
    createInvocationWidget(width: number, height: number): GraphWidget;
    createIteratorAgeWidget(width: number, height: number): GraphWidget;
    createLambdaInsightsCpuWidget(width: number, height: number): GraphWidget;
    createLambdaInsightsMemoryWidget(width: number, height: number): GraphWidget;
    createLambdaInsightsFunctionCostWidget(width: number, height: number): GraphWidget;
    private resolveFunctionName;
}
