"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const LambdaFunctionEnhancedMetricFactory_1 = require("./LambdaFunctionEnhancedMetricFactory");
const LambdaFunctionMetricFactory_1 = require("./LambdaFunctionMetricFactory");
class LambdaFunctionMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        this.namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.lambdaFunction,
            fallbackConstructName: this.resolveFunctionName(props.lambdaFunction),
        });
        this.title = this.namingStrategy.resolveHumanReadableName();
        this.functionUrl = scope
            .createAwsConsoleUrlFactory()
            .getLambdaFunctionUrl(props.lambdaFunction.functionName);
        this.alarmFactory = this.createAlarmFactory(this.namingStrategy.resolveAlarmFriendlyName());
        this.errorAlarmFactory = new common_1.ErrorAlarmFactory(this.alarmFactory);
        this.latencyAlarmFactory = new common_1.LatencyAlarmFactory(this.alarmFactory);
        this.tpsAlarmFactory = new common_1.TpsAlarmFactory(this.alarmFactory);
        this.taskHealthAlarmFactory = new common_1.TaskHealthAlarmFactory(this.alarmFactory);
        this.ageAlarmFactory = new common_1.AgeAlarmFactory(this.alarmFactory);
        this.usageAlarmFactory = new common_1.UsageAlarmFactory(this.alarmFactory);
        this.latencyAnnotations = [];
        this.errorCountAnnotations = [];
        this.errorRateAnnotations = [];
        this.invocationCountAnnotations = [];
        this.invocationRateAnnotations = [];
        this.tpsAnnotations = [];
        this.cpuTotalTimeAnnotations = [];
        this.memoryUsageAnnotations = [];
        this.maxIteratorAgeAnnotations = [];
        this.metricFactory = new LambdaFunctionMetricFactory_1.LambdaFunctionMetricFactory(scope.createMetricFactory(), props);
        this.tpsMetric = this.metricFactory.metricTps();
        this.p50LatencyMetric = this.metricFactory.metricLatencyP50InMillis();
        this.p90LatencyMetric = this.metricFactory.metricLatencyP90InMillis();
        this.p99LatencyMetric = this.metricFactory.metricLatencyP99InMillis();
        this.faultCountMetric = this.metricFactory.metricFaultCount();
        this.faultRateMetric = this.metricFactory.metricFaultRate();
        this.invocationCountMetric = this.metricFactory.metricInvocationCount();
        this.throttlesCountMetric = this.metricFactory.metricThrottlesCount();
        this.throttlesRateMetric = this.metricFactory.metricThrottlesRate();
        this.concurrentExecutionsCountMetric =
            this.metricFactory.metricConcurrentExecutions();
        this.provisionedConcurrencySpilloverInvocationsCountMetric =
            this.metricFactory.metricProvisionedConcurrencySpilloverInvocations();
        this.provisionedConcurrencySpilloverInvocationsRateMetric =
            this.metricFactory.metricProvisionedConcurrencySpilloverRate();
        this.maxIteratorAgeMetric =
            this.metricFactory.metricMaxIteratorAgeInMillis();
        this.lambdaInsightsEnabled = props.lambdaInsightsEnabled ?? false;
        if (props.lambdaInsightsEnabled) {
            this.enhancedMetricFactory = new LambdaFunctionEnhancedMetricFactory_1.LambdaFunctionEnhancedMetricFactory(scope.createMetricFactory(), props.lambdaFunction);
            this.enhancedMonitoringMaxCpuTotalTimeMetric =
                this.enhancedMetricFactory.enhancedMetricMaxCpuTotalTime();
            this.enhancedMonitoringP90CpuTotalTimeMetric =
                this.enhancedMetricFactory.enhancedMetricP90CpuTotalTime();
            this.enhancedMonitoringAvgCpuTotalTimeMetric =
                this.enhancedMetricFactory.enhancedMetricAvgCpuTotalTime();
            this.enhancedMonitoringMaxMemoryUtilizationMetric =
                this.enhancedMetricFactory.enhancedMetricMaxMemoryUtilization();
            this.enhancedMonitoringP90MemoryUtilizationMetric =
                this.enhancedMetricFactory.enhancedMetricP90MemoryUtilization();
            this.enhancedMonitoringAvgMemoryUtilizationMetric =
                this.enhancedMetricFactory.enhancedMetricAvgMemoryUtilization();
            this.enhancedMetricFunctionCostMetric =
                this.enhancedMetricFactory.enhancedMetricFunctionCost();
            for (const disambiguator in props.addEnhancedMonitoringMaxCpuTotalTimeAlarm) {
                const alarmProps = props.addEnhancedMonitoringMaxCpuTotalTimeAlarm[disambiguator];
                const createdAlarm = this.latencyAlarmFactory.addDurationAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringMaxCpuTotalTimeMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                common_1.LatencyType.P100, alarmProps, disambiguator);
                this.cpuTotalTimeAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringP90CpuTotalTimeAlarm) {
                const alarmProps = props.addEnhancedMonitoringP90CpuTotalTimeAlarm[disambiguator];
                const createdAlarm = this.latencyAlarmFactory.addDurationAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringP90CpuTotalTimeMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                common_1.LatencyType.P90, alarmProps, disambiguator);
                this.cpuTotalTimeAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringAvgCpuTotalTimeAlarm) {
                const alarmProps = props.addEnhancedMonitoringAvgCpuTotalTimeAlarm[disambiguator];
                const createdAlarm = this.latencyAlarmFactory.addDurationAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringAvgCpuTotalTimeMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                common_1.LatencyType.AVERAGE, alarmProps, disambiguator);
                this.cpuTotalTimeAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringMaxMemoryUtilizationAlarm) {
                const alarmProps = props.addEnhancedMonitoringMaxMemoryUtilizationAlarm[disambiguator];
                const createdAlarm = this.usageAlarmFactory.addMaxMemoryUsagePercentAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringMaxMemoryUtilizationMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                alarmProps, disambiguator);
                this.memoryUsageAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringP90MemoryUtilizationAlarm) {
                const alarmProps = props.addEnhancedMonitoringP90MemoryUtilizationAlarm[disambiguator];
                const createdAlarm = this.usageAlarmFactory.addMemoryUsagePercentAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringP90MemoryUtilizationMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                alarmProps, common_1.UsageType.P90, disambiguator);
                this.memoryUsageAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
            for (const disambiguator in props.addEnhancedMonitoringAvgMemoryUtilizationAlarm) {
                const alarmProps = props.addEnhancedMonitoringAvgMemoryUtilizationAlarm[disambiguator];
                const createdAlarm = this.usageAlarmFactory.addMemoryUsagePercentAlarm(
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringAvgMemoryUtilizationMetric, 
                /* eslint-enable @typescript-eslint/no-non-null-assertion */
                alarmProps, common_1.UsageType.AVERAGE, disambiguator);
                this.memoryUsageAnnotations.push(createdAlarm.annotation);
                this.addAlarm(createdAlarm);
            }
        }
        for (const disambiguator in props.addLatencyP50Alarm) {
            const alarmProps = props.addLatencyP50Alarm[disambiguator];
            const createdAlarm = this.latencyAlarmFactory.addLatencyAlarm(this.p50LatencyMetric, common_1.LatencyType.P50, alarmProps, disambiguator);
            this.latencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addLatencyP90Alarm) {
            const alarmProps = props.addLatencyP90Alarm[disambiguator];
            const createdAlarm = this.latencyAlarmFactory.addLatencyAlarm(this.p90LatencyMetric, common_1.LatencyType.P90, alarmProps, disambiguator);
            this.latencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addLatencyP99Alarm) {
            const alarmProps = props.addLatencyP99Alarm[disambiguator];
            const createdAlarm = this.latencyAlarmFactory.addLatencyAlarm(this.p99LatencyMetric, common_1.LatencyType.P99, alarmProps, disambiguator);
            this.latencyAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addFaultCountAlarm) {
            const alarmProps = props.addFaultCountAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorCountAlarm(this.faultCountMetric, common_1.ErrorType.FAULT, alarmProps, disambiguator);
            this.errorCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addFaultRateAlarm) {
            const alarmProps = props.addFaultRateAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorRateAlarm(this.faultRateMetric, common_1.ErrorType.FAULT, alarmProps, disambiguator);
            this.errorRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addLowTpsAlarm) {
            const alarmProps = props.addLowTpsAlarm[disambiguator];
            const createdAlarm = this.tpsAlarmFactory.addMinTpsAlarm(this.tpsMetric, alarmProps, disambiguator);
            this.tpsAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addHighTpsAlarm) {
            const alarmProps = props.addHighTpsAlarm[disambiguator];
            const createdAlarm = this.tpsAlarmFactory.addMaxTpsAlarm(this.tpsMetric, alarmProps, disambiguator);
            this.tpsAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addThrottlesCountAlarm) {
            const alarmProps = props.addThrottlesCountAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorCountAlarm(this.throttlesCountMetric, common_1.ErrorType.THROTTLED, alarmProps, disambiguator);
            this.invocationCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addThrottlesRateAlarm) {
            const alarmProps = props.addThrottlesRateAlarm[disambiguator];
            const createdAlarm = this.errorAlarmFactory.addErrorRateAlarm(this.throttlesRateMetric, common_1.ErrorType.THROTTLED, alarmProps, disambiguator);
            this.invocationRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMinInvocationsCountAlarm) {
            const alarmProps = props.addMinInvocationsCountAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMinUsageCountAlarm(this.invocationCountMetric, alarmProps, disambiguator);
            this.invocationCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addConcurrentExecutionsCountAlarm) {
            const alarmProps = props.addConcurrentExecutionsCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addRunningTaskCountAlarm(this.concurrentExecutionsCountMetric, alarmProps, disambiguator);
            this.invocationCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addProvisionedConcurrencySpilloverInvocationsCountAlarm) {
            const alarmProps = props.addProvisionedConcurrencySpilloverInvocationsCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addRunningTaskCountAlarm(this.provisionedConcurrencySpilloverInvocationsCountMetric, alarmProps, disambiguator);
            this.invocationCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addProvisionedConcurrencySpilloverInvocationsRateAlarm) {
            const alarmProps = props.addProvisionedConcurrencySpilloverInvocationsRateAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addRunningTaskRateAlarm(this.provisionedConcurrencySpilloverInvocationsRateMetric, alarmProps, disambiguator);
            this.invocationRateAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxIteratorAgeAlarm) {
            const alarmProps = props.addMaxIteratorAgeAlarm[disambiguator];
            const createdAlarm = this.ageAlarmFactory.addIteratorMaxAgeAlarm(this.maxIteratorAgeMetric, alarmProps, disambiguator);
            this.maxIteratorAgeAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createTpsWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createLatencyWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createErrorRateWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        const widgets = [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createTpsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createLatencyWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createErrorRateWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight), this.createRateWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight)),
            new aws_cloudwatch_1.Row(this.createInvocationWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createIteratorAgeWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createErrorCountWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight)),
        ];
        if (this.lambdaInsightsEnabled) {
            widgets.push(new aws_cloudwatch_1.Row(this.createLambdaInsightsCpuWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createLambdaInsightsMemoryWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createLambdaInsightsFunctionCostWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight)));
        }
        return widgets;
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Lambda Function",
            title: this.title,
            goToLinkUrl: this.functionUrl,
        });
    }
    createTpsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "TPS",
            left: [this.tpsMetric],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: this.tpsAnnotations,
        });
    }
    createLatencyWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Latency",
            left: [
                this.p50LatencyMetric,
                this.p90LatencyMetric,
                this.p99LatencyMetric,
            ],
            leftYAxis: common_1.TimeAxisMillisFromZero,
            leftAnnotations: this.latencyAnnotations,
        });
    }
    createErrorCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Errors",
            left: [this.faultCountMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.errorCountAnnotations,
        });
    }
    createErrorRateWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Errors (rate)",
            left: [this.faultRateMetric],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: this.errorRateAnnotations,
        });
    }
    createRateWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Rates",
            left: [
                this.throttlesRateMetric,
                this.provisionedConcurrencySpilloverInvocationsRateMetric,
            ],
            leftYAxis: common_1.RateAxisFromZero,
            leftAnnotations: this.invocationRateAnnotations,
        });
    }
    createInvocationWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Invocations",
            left: [
                this.invocationCountMetric,
                this.throttlesCountMetric,
                this.concurrentExecutionsCountMetric,
                this.provisionedConcurrencySpilloverInvocationsCountMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.invocationCountAnnotations,
        });
    }
    createIteratorAgeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Iterator",
            left: [this.maxIteratorAgeMetric],
            leftYAxis: common_1.TimeAxisMillisFromZero,
            leftAnnotations: this.maxIteratorAgeAnnotations,
        });
    }
    createLambdaInsightsCpuWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "CPU Total Time",
            left: [
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringMaxCpuTotalTimeMetric,
                this.enhancedMonitoringP90CpuTotalTimeMetric,
                this.enhancedMonitoringAvgCpuTotalTimeMetric,
            ],
            leftYAxis: common_1.TimeAxisMillisFromZero,
        });
    }
    createLambdaInsightsMemoryWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Memory Utilization",
            left: [
                /* eslint-disable @typescript-eslint/no-non-null-assertion */
                this.enhancedMonitoringMaxMemoryUtilizationMetric,
                this.enhancedMonitoringP90MemoryUtilizationMetric,
                this.enhancedMonitoringAvgMemoryUtilizationMetric,
            ],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
        });
    }
    createLambdaInsightsFunctionCostWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Function Cost",
            /* eslint-disable @typescript-eslint/no-non-null-assertion */
            left: [this.enhancedMetricFunctionCostMetric],
            /* eslint-enable @typescript-eslint/no-non-null-assertion */
            leftYAxis: common_1.MegabyteMillisecondAxisFromZero,
        });
    }
    resolveFunctionName(lambdaFunction) {
        // try to take the name (if specified) instead of token
        return lambdaFunction.node.defaultChild?.functionName;
    }
}
exports.LambdaFunctionMonitoring = LambdaFunctionMonitoring;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionMonitoring[_a] = { fqn: "cdk-monitoring-constructs.LambdaFunctionMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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