"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationLoadBalancerMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
/**
 * Metric factory to create metrics for application load-balanced service.
 */
class ApplicationLoadBalancerMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.applicationLoadBalancer = props.applicationLoadBalancer;
        this.applicationTargetGroup = props.applicationTargetGroup;
    }
    metricHealthyTaskCount() {
        return this.metricFactory.adaptMetric(this.applicationTargetGroup.metricHealthyHostCount({
            label: "Healthy Tasks",
            color: common_1.HealthyMetricColor,
            statistic: common_1.MetricStatistic.MIN,
        }));
    }
    metricUnhealthyTaskCount() {
        return this.metricFactory.adaptMetric(this.applicationTargetGroup.metricUnhealthyHostCount({
            label: "Unhealthy Tasks",
            color: common_1.UnhealthyMetricColor,
            statistic: common_1.MetricStatistic.MAX,
        }));
    }
    metricHealthyTaskInPercent() {
        const healthyTaskCount = this.metricHealthyTaskCount();
        const unhealthyTaskCount = this.metricUnhealthyTaskCount();
        return this.metricFactory.createMetricMath("(healthyTaskCount / (healthyTaskCount + unhealthyTaskCount)) * 100", { healthyTaskCount, unhealthyTaskCount }, "Healthy Task Percent (avg: ${AVG})");
    }
    metricActiveConnectionCount() {
        return this.metricFactory.adaptMetric(this.applicationLoadBalancer.metricActiveConnectionCount({
            label: "Active",
        }));
    }
    metricNewConnectionCount() {
        return this.metricFactory.adaptMetric(this.applicationLoadBalancer.metricNewConnectionCount({
            label: "New",
        }));
    }
    metricProcessedBytesMin() {
        return this.metricFactory.adaptMetric(this.applicationLoadBalancer.metricProcessedBytes({
            statistic: common_1.MetricStatistic.MIN,
            label: "Processed Bytes (min)",
        }));
    }
}
exports.ApplicationLoadBalancerMetricFactory = ApplicationLoadBalancerMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
ApplicationLoadBalancerMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.ApplicationLoadBalancerMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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