import { MetricFactory, MetricWithAlarmSupport } from "../../common";
/**
 * Factory method to create appropriate metric factory based on the load balancer and target group type.
 * @param metricFactory metric factory
 * @param loadBalancer load balancer
 * @param targetGroup target group
 */
export declare function createLoadBalancerMetricFactory(metricFactory: MetricFactory, loadBalancer: any, targetGroup: any): ILoadBalancerMetricFactory;
/**
 * Common interface for load-balancer based service metric factories.
 */
export interface ILoadBalancerMetricFactory {
    metricHealthyTaskCount(): MetricWithAlarmSupport;
    metricUnhealthyTaskCount(): MetricWithAlarmSupport;
    metricHealthyTaskInPercent(): MetricWithAlarmSupport;
    metricActiveConnectionCount(): MetricWithAlarmSupport;
    metricNewConnectionCount(): MetricWithAlarmSupport;
    metricProcessedBytesMin(): MetricWithAlarmSupport;
}
