import { NetworkLoadBalancer, NetworkTargetGroup } from "aws-cdk-lib/aws-elasticloadbalancingv2";
import { MetricFactory } from "../../common";
import { ILoadBalancerMetricFactory } from "./LoadBalancerMetricFactory";
/**
 * Props to create NetworkLoadBalancerMetricFactory.
 */
export interface NetworkLoadBalancerMetricFactoryProps {
    readonly networkLoadBalancer: NetworkLoadBalancer;
    readonly networkTargetGroup: NetworkTargetGroup;
}
/**
 * Metric factory to create metrics for network load-balanced service.
 */
export declare class NetworkLoadBalancerMetricFactory implements ILoadBalancerMetricFactory {
    protected readonly metricFactory: MetricFactory;
    protected readonly networkLoadBalancer: NetworkLoadBalancer;
    protected readonly networkTargetGroup: NetworkTargetGroup;
    constructor(metricFactory: MetricFactory, props: NetworkLoadBalancerMetricFactoryProps);
    metricHealthyTaskCount(): import("../../common").MetricWithAlarmSupport;
    metricUnhealthyTaskCount(): import("../../common").MetricWithAlarmSupport;
    metricHealthyTaskInPercent(): import("../../common").MetricWithAlarmSupport;
    metricActiveConnectionCount(): import("../../common").MetricWithAlarmSupport;
    metricNewConnectionCount(): import("../../common").MetricWithAlarmSupport;
    metricProcessedBytesMin(): import("../../common").MetricWithAlarmSupport;
}
