"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NetworkLoadBalancerMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const NetworkLoadBalancerMetricFactory_1 = require("./NetworkLoadBalancerMetricFactory");
class NetworkLoadBalancerMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const fallbackConstructName = `${props.networkLoadBalancer}-${props.networkTargetGroup}`;
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName,
        });
        this.humanReadableName = namingStrategy.resolveHumanReadableName();
        this.metricFactory = new NetworkLoadBalancerMetricFactory_1.NetworkLoadBalancerMetricFactory(scope.createMetricFactory(), props);
        this.healthyTaskCountMetric = this.metricFactory.metricHealthyTaskCount();
        this.unhealthyTaskCountMetric =
            this.metricFactory.metricUnhealthyTaskCount();
        this.healthyTaskPercentMetric =
            this.metricFactory.metricHealthyTaskInPercent();
        this.activeTcpFlowCountMetric =
            this.metricFactory.metricActiveConnectionCount();
        this.newTcpFlowCountMetric = this.metricFactory.metricNewConnectionCount();
        this.processedBytesMetric = this.metricFactory.metricProcessedBytesMin();
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.taskHealthAlarmFactory = new common_1.TaskHealthAlarmFactory(alarmFactory);
        this.throughputAlarmFactory = new common_1.ThroughputAlarmFactory(alarmFactory);
        this.taskHealthAnnotations = [];
        this.processedBytesAnnotations = [];
        for (const disambiguator in props.addHealthyTaskCountAlarm) {
            const alarmProps = props.addHealthyTaskCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskCountAlarm(this.healthyTaskCountMetric, alarmProps, disambiguator);
            this.taskHealthAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addUnhealthyTaskCountAlarm) {
            const alarmProps = props.addUnhealthyTaskCountAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addUnhealthyTaskCountAlarm(this.unhealthyTaskCountMetric, alarmProps, disambiguator);
            this.taskHealthAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addHealthyTaskPercentAlarm) {
            const alarmProps = props.addHealthyTaskPercentAlarm[disambiguator];
            const createdAlarm = this.taskHealthAlarmFactory.addHealthyTaskPercentAlarm(this.healthyTaskPercentMetric, alarmProps, disambiguator);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMinProcessedBytesAlarm) {
            const alarmProps = props.addMinProcessedBytesAlarm[disambiguator];
            const createdAlarm = this.throughputAlarmFactory.addMinProcessedBytesAlarm(this.processedBytesMetric, alarmProps, disambiguator);
            this.processedBytesAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createTcpFlowsWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            this.createTaskHealthWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createTcpFlowsWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
            this.createTaskHealthWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Network Load Balancer",
            title: this.humanReadableName,
        });
    }
    createTaskHealthWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Task Health",
            left: [this.healthyTaskCountMetric, this.unhealthyTaskCountMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.taskHealthAnnotations,
        });
    }
    createTcpFlowsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "TCP Flows",
            left: [this.activeTcpFlowCountMetric, this.newTcpFlowCountMetric],
            leftYAxis: common_1.CountAxisFromZero,
            right: [this.processedBytesMetric],
            rightYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
}
exports.NetworkLoadBalancerMonitoring = NetworkLoadBalancerMonitoring;
_a = JSII_RTTI_SYMBOL_1;
NetworkLoadBalancerMonitoring[_a] = { fqn: "cdk-monitoring-constructs.NetworkLoadBalancerMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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