"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchClusterMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const OpenSearchBackportedMetrics_1 = require("./OpenSearchBackportedMetrics");
class OpenSearchClusterMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.domainMetrics = new OpenSearchBackportedMetrics_1.OpenSearchBackportedMetrics(props.domain);
        this.fillTpsWithZeroes = props.fillTpsWithZeroes ?? true;
        this.rateComputationMethod =
            props.rateComputationMethod ?? common_1.RateComputationMethod.AVERAGE;
    }
    metricSearchCount() {
        return this.domainMetrics.metric("SearchRate", {
            statistic: aws_cloudwatch_1.Statistic.SUM,
        });
    }
    metricSearchRate() {
        return this.metricFactory.toRate(this.metricSearchCount(), this.rateComputationMethod, false, "requests", this.fillTpsWithZeroes);
    }
    /**
     * @deprecated use metricSearchRate
     */
    metricTps() {
        return this.metricFactory.toRate(this.metricSearchCount(), common_1.RateComputationMethod.PER_SECOND, false, "requests", this.fillTpsWithZeroes);
    }
    metricIndexingLatencyP50InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricIndexingLatency({
            statistic: common_1.MetricStatistic.P50,
            label: "P50",
        }));
    }
    metricIndexingLatencyP90InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricIndexingLatency({
            statistic: common_1.MetricStatistic.P90,
            label: "P90",
        }));
    }
    metricIndexingLatencyP99InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricIndexingLatency({
            statistic: common_1.MetricStatistic.P99,
            label: "P99",
        }));
    }
    metricSearchLatencyP50InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricSearchLatency({
            statistic: common_1.MetricStatistic.P50,
            label: "P50",
        }));
    }
    metricSearchLatencyP90InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricSearchLatency({
            statistic: common_1.MetricStatistic.P90,
            label: "P90",
        }));
    }
    metricSearchLatencyP99InMillis() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricSearchLatency({
            statistic: common_1.MetricStatistic.P99,
            label: "P99",
        }));
    }
    metricClusterStatusRed() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricClusterStatusRed({
            label: "Red",
        }));
    }
    metricClusterStatusYellow() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricClusterStatusYellow({
            label: "Yellow",
        }));
    }
    metricDiskSpaceUsageInPercent() {
        const used = this.domainMetrics.metric("ClusterUsedSpace", {
            statistic: aws_cloudwatch_1.Statistic.SUM,
        });
        const free = this.domainMetrics.metric("FreeStorageSpace", {
            statistic: aws_cloudwatch_1.Statistic.SUM,
        });
        return this.metricFactory.createMetricMath("100 * (used/(used+free))", { used, free }, "Disk Usage");
    }
    metricCpuUsage() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricCPUUtilization({
            label: "CPU Usage",
        }));
    }
    metricMasterCpuUsage() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricMasterCPUUtilization({
            label: "Master CPU Usage",
        }));
    }
    metricJvmMemoryPressure() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricJVMMemoryPressure({
            label: "JVM Memory Pressure",
        }));
    }
    metricMasterJvmMemoryPressure() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricMasterJVMMemoryPressure({
            label: "Master JVM Memory Pressure",
        }));
    }
    metricClusterIndexWritesBlocked() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricClusterIndexWritesBlocked({
            label: "Index Writes Blocked",
        }));
    }
    /**
     * @deprecated use metricClusterIndexWritesBlocked instead
     */
    metricClusterIndexWriteBlocked() {
        return this.metricClusterIndexWritesBlocked();
    }
    metricNodes() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricNodes({
            label: "Nodes",
        }));
    }
    metricAutomatedSnapshotFailure() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricAutomatedSnapshotFailure({
            label: "Automated Snapshot Failures",
        }));
    }
    metricKmsKeyError() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricKMSKeyError({
            label: "KMS Key Error",
        }));
    }
    metricKmsKeyInaccessible() {
        return this.metricFactory.adaptMetric(this.domainMetrics.metricKMSKeyInaccessible({
            label: "KMS Key Inaccessible",
        }));
    }
}
exports.OpenSearchClusterMetricFactory = OpenSearchClusterMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
OpenSearchClusterMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.OpenSearchClusterMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiT3BlblNlYXJjaENsdXN0ZXJNZXRyaWNGYWN0b3J5LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiT3BlblNlYXJjaENsdXN0ZXJNZXRyaWNGYWN0b3J5LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0RBQXVEO0FBRXZELHlDQUlzQjtBQUN0QiwrRUFHdUM7QUFjdkMsTUFBYSw4QkFBOEI7SUFNekMsWUFDRSxhQUE0QixFQUM1QixLQUEwQztRQUUxQyxJQUFJLENBQUMsYUFBYSxHQUFHLGFBQWEsQ0FBQztRQUNuQyxJQUFJLENBQUMsYUFBYSxHQUFHLElBQUkseURBQTJCLENBQUMsS0FBSyxDQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ25FLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxLQUFLLENBQUMsaUJBQWlCLElBQUksSUFBSSxDQUFDO1FBQ3pELElBQUksQ0FBQyxxQkFBcUI7WUFDeEIsS0FBSyxDQUFDLHFCQUFxQixJQUFJLDhCQUFxQixDQUFDLE9BQU8sQ0FBQztJQUNqRSxDQUFDO0lBRUQsaUJBQWlCO1FBQ2YsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxZQUFZLEVBQUU7WUFDN0MsU0FBUyxFQUFFLDBCQUFTLENBQUMsR0FBRztTQUN6QixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsZ0JBQWdCO1FBQ2QsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FDOUIsSUFBSSxDQUFDLGlCQUFpQixFQUFFLEVBQ3hCLElBQUksQ0FBQyxxQkFBcUIsRUFDMUIsS0FBSyxFQUNMLFVBQVUsRUFDVixJQUFJLENBQUMsaUJBQWlCLENBQ3ZCLENBQUM7SUFDSixDQUFDO0lBRUQ7O09BRUc7SUFDSCxTQUFTO1FBQ1AsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FDOUIsSUFBSSxDQUFDLGlCQUFpQixFQUFFLEVBQ3hCLDhCQUFxQixDQUFDLFVBQVUsRUFDaEMsS0FBSyxFQUNMLFVBQVUsRUFDVixJQUFJLENBQUMsaUJBQWlCLENBQ3ZCLENBQUM7SUFDSixDQUFDO0lBRUQsZ0NBQWdDO1FBQzlCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQ25DLElBQUksQ0FBQyxhQUFhLENBQUMscUJBQXFCLENBQUM7WUFDdkMsU0FBUyxFQUFFLHdCQUFlLENBQUMsR0FBRztZQUM5QixLQUFLLEVBQUUsS0FBSztTQUNiLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVELGdDQUFnQztRQUM5QixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUNuQyxJQUFJLENBQUMsYUFBYSxDQUFDLHFCQUFxQixDQUFDO1lBQ3ZDLFNBQVMsRUFBRSx3QkFBZSxDQUFDLEdBQUc7WUFDOUIsS0FBSyxFQUFFLEtBQUs7U0FDYixDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCxnQ0FBZ0M7UUFDOUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDbkMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxxQkFBcUIsQ0FBQztZQUN2QyxTQUFTLEVBQUUsd0JBQWUsQ0FBQyxHQUFHO1lBQzlCLEtBQUssRUFBRSxLQUFLO1NBQ2IsQ0FBQyxDQUNILENBQUM7SUFDSixDQUFDO0lBRUQsOEJBQThCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQ25DLElBQUksQ0FBQyxhQUFhLENBQUMsbUJBQW1CLENBQUM7WUFDckMsU0FBUyxFQUFFLHdCQUFlLENBQUMsR0FBRztZQUM5QixLQUFLLEVBQUUsS0FBSztTQUNiLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVELDhCQUE4QjtRQUM1QixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUNuQyxJQUFJLENBQUMsYUFBYSxDQUFDLG1CQUFtQixDQUFDO1lBQ3JDLFNBQVMsRUFBRSx3QkFBZSxDQUFDLEdBQUc7WUFDOUIsS0FBSyxFQUFFLEtBQUs7U0FDYixDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCw4QkFBOEI7UUFDNUIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDbkMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxtQkFBbUIsQ0FBQztZQUNyQyxTQUFTLEVBQUUsd0JBQWUsQ0FBQyxHQUFHO1lBQzlCLEtBQUssRUFBRSxLQUFLO1NBQ2IsQ0FBQyxDQUNILENBQUM7SUFDSixDQUFDO0lBRUQsc0JBQXNCO1FBQ3BCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQ25DLElBQUksQ0FBQyxhQUFhLENBQUMsc0JBQXNCLENBQUM7WUFDeEMsS0FBSyxFQUFFLEtBQUs7U0FDYixDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCx5QkFBeUI7UUFDdkIsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDbkMsSUFBSSxDQUFDLGFBQWEsQ0FBQyx5QkFBeUIsQ0FBQztZQUMzQyxLQUFLLEVBQUUsUUFBUTtTQUNoQixDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCw2QkFBNkI7UUFDM0IsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsa0JBQWtCLEVBQUU7WUFDekQsU0FBUyxFQUFFLDBCQUFTLENBQUMsR0FBRztTQUN6QixDQUFDLENBQUM7UUFDSCxNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsYUFBYSxDQUFDLE1BQU0sQ0FBQyxrQkFBa0IsRUFBRTtZQUN6RCxTQUFTLEVBQUUsMEJBQVMsQ0FBQyxHQUFHO1NBQ3pCLENBQUMsQ0FBQztRQUNILE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxnQkFBZ0IsQ0FDeEMsMEJBQTBCLEVBQzFCLEVBQUUsSUFBSSxFQUFFLElBQUksRUFBRSxFQUNkLFlBQVksQ0FDYixDQUFDO0lBQ0osQ0FBQztJQUVELGNBQWM7UUFDWixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUNuQyxJQUFJLENBQUMsYUFBYSxDQUFDLG9CQUFvQixDQUFDO1lBQ3RDLEtBQUssRUFBRSxXQUFXO1NBQ25CLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVELG9CQUFvQjtRQUNsQixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUNuQyxJQUFJLENBQUMsYUFBYSxDQUFDLDBCQUEwQixDQUFDO1lBQzVDLEtBQUssRUFBRSxrQkFBa0I7U0FDMUIsQ0FBQyxDQUNILENBQUM7SUFDSixDQUFDO0lBRUQsdUJBQXVCO1FBQ3JCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQ25DLElBQUksQ0FBQyxhQUFhLENBQUMsdUJBQXVCLENBQUM7WUFDekMsS0FBSyxFQUFFLHFCQUFxQjtTQUM3QixDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCw2QkFBNkI7UUFDM0IsT0FBTyxJQUFJLENBQUMsYUFBYSxDQUFDLFdBQVcsQ0FDbkMsSUFBSSxDQUFDLGFBQWEsQ0FBQyw2QkFBNkIsQ0FBQztZQUMvQyxLQUFLLEVBQUUsNEJBQTRCO1NBQ3BDLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVELCtCQUErQjtRQUM3QixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUNuQyxJQUFJLENBQUMsYUFBYSxDQUFDLCtCQUErQixDQUFDO1lBQ2pELEtBQUssRUFBRSxzQkFBc0I7U0FDOUIsQ0FBQyxDQUNILENBQUM7SUFDSixDQUFDO0lBRUQ7O09BRUc7SUFDSCw4QkFBOEI7UUFDNUIsT0FBTyxJQUFJLENBQUMsK0JBQStCLEVBQUUsQ0FBQztJQUNoRCxDQUFDO0lBRUQsV0FBVztRQUNULE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQ25DLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUFDO1lBQzdCLEtBQUssRUFBRSxPQUFPO1NBQ2YsQ0FBQyxDQUNILENBQUM7SUFDSixDQUFDO0lBRUQsOEJBQThCO1FBQzVCLE9BQU8sSUFBSSxDQUFDLGFBQWEsQ0FBQyxXQUFXLENBQ25DLElBQUksQ0FBQyxhQUFhLENBQUMsOEJBQThCLENBQUM7WUFDaEQsS0FBSyxFQUFFLDZCQUE2QjtTQUNyQyxDQUFDLENBQ0gsQ0FBQztJQUNKLENBQUM7SUFFRCxpQkFBaUI7UUFDZixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUNuQyxJQUFJLENBQUMsYUFBYSxDQUFDLGlCQUFpQixDQUFDO1lBQ25DLEtBQUssRUFBRSxlQUFlO1NBQ3ZCLENBQUMsQ0FDSCxDQUFDO0lBQ0osQ0FBQztJQUVELHdCQUF3QjtRQUN0QixPQUFPLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUNuQyxJQUFJLENBQUMsYUFBYSxDQUFDLHdCQUF3QixDQUFDO1lBQzFDLEtBQUssRUFBRSxzQkFBc0I7U0FDOUIsQ0FBQyxDQUNILENBQUM7SUFDSixDQUFDOztBQS9NSCx3RUFnTkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTdGF0aXN0aWMgfSBmcm9tIFwiYXdzLWNkay1saWIvYXdzLWNsb3Vkd2F0Y2hcIjtcblxuaW1wb3J0IHtcbiAgTWV0cmljRmFjdG9yeSxcbiAgTWV0cmljU3RhdGlzdGljLFxuICBSYXRlQ29tcHV0YXRpb25NZXRob2QsXG59IGZyb20gXCIuLi8uLi9jb21tb25cIjtcbmltcG9ydCB7XG4gIERvbWFpbixcbiAgT3BlblNlYXJjaEJhY2twb3J0ZWRNZXRyaWNzLFxufSBmcm9tIFwiLi9PcGVuU2VhcmNoQmFja3BvcnRlZE1ldHJpY3NcIjtcblxuZXhwb3J0IGludGVyZmFjZSBPcGVuU2VhcmNoQ2x1c3Rlck1ldHJpY0ZhY3RvcnlQcm9wcyB7XG4gIHJlYWRvbmx5IGRvbWFpbjogRG9tYWluO1xuICAvKipcbiAgICogQGRlZmF1bHQgLSB0cnVlXG4gICAqL1xuICByZWFkb25seSBmaWxsVHBzV2l0aFplcm9lcz86IGJvb2xlYW47XG4gIC8qKlxuICAgKiBAZGVmYXVsdCAtIGF2ZXJhZ2VcbiAgICovXG4gIHJlYWRvbmx5IHJhdGVDb21wdXRhdGlvbk1ldGhvZD86IFJhdGVDb21wdXRhdGlvbk1ldGhvZDtcbn1cblxuZXhwb3J0IGNsYXNzIE9wZW5TZWFyY2hDbHVzdGVyTWV0cmljRmFjdG9yeSB7XG4gIHByb3RlY3RlZCByZWFkb25seSBtZXRyaWNGYWN0b3J5OiBNZXRyaWNGYWN0b3J5O1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgZG9tYWluTWV0cmljczogT3BlblNlYXJjaEJhY2twb3J0ZWRNZXRyaWNzO1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgZmlsbFRwc1dpdGhaZXJvZXM6IGJvb2xlYW47XG4gIHByb3RlY3RlZCByZWFkb25seSByYXRlQ29tcHV0YXRpb25NZXRob2Q6IFJhdGVDb21wdXRhdGlvbk1ldGhvZDtcblxuICBjb25zdHJ1Y3RvcihcbiAgICBtZXRyaWNGYWN0b3J5OiBNZXRyaWNGYWN0b3J5LFxuICAgIHByb3BzOiBPcGVuU2VhcmNoQ2x1c3Rlck1ldHJpY0ZhY3RvcnlQcm9wc1xuICApIHtcbiAgICB0aGlzLm1ldHJpY0ZhY3RvcnkgPSBtZXRyaWNGYWN0b3J5O1xuICAgIHRoaXMuZG9tYWluTWV0cmljcyA9IG5ldyBPcGVuU2VhcmNoQmFja3BvcnRlZE1ldHJpY3MocHJvcHMuZG9tYWluKTtcbiAgICB0aGlzLmZpbGxUcHNXaXRoWmVyb2VzID0gcHJvcHMuZmlsbFRwc1dpdGhaZXJvZXMgPz8gdHJ1ZTtcbiAgICB0aGlzLnJhdGVDb21wdXRhdGlvbk1ldGhvZCA9XG4gICAgICBwcm9wcy5yYXRlQ29tcHV0YXRpb25NZXRob2QgPz8gUmF0ZUNvbXB1dGF0aW9uTWV0aG9kLkFWRVJBR0U7XG4gIH1cblxuICBtZXRyaWNTZWFyY2hDb3VudCgpIHtcbiAgICByZXR1cm4gdGhpcy5kb21haW5NZXRyaWNzLm1ldHJpYyhcIlNlYXJjaFJhdGVcIiwge1xuICAgICAgc3RhdGlzdGljOiBTdGF0aXN0aWMuU1VNLFxuICAgIH0pO1xuICB9XG5cbiAgbWV0cmljU2VhcmNoUmF0ZSgpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LnRvUmF0ZShcbiAgICAgIHRoaXMubWV0cmljU2VhcmNoQ291bnQoKSxcbiAgICAgIHRoaXMucmF0ZUNvbXB1dGF0aW9uTWV0aG9kLFxuICAgICAgZmFsc2UsXG4gICAgICBcInJlcXVlc3RzXCIsXG4gICAgICB0aGlzLmZpbGxUcHNXaXRoWmVyb2VzXG4gICAgKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAZGVwcmVjYXRlZCB1c2UgbWV0cmljU2VhcmNoUmF0ZVxuICAgKi9cbiAgbWV0cmljVHBzKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkudG9SYXRlKFxuICAgICAgdGhpcy5tZXRyaWNTZWFyY2hDb3VudCgpLFxuICAgICAgUmF0ZUNvbXB1dGF0aW9uTWV0aG9kLlBFUl9TRUNPTkQsXG4gICAgICBmYWxzZSxcbiAgICAgIFwicmVxdWVzdHNcIixcbiAgICAgIHRoaXMuZmlsbFRwc1dpdGhaZXJvZXNcbiAgICApO1xuICB9XG5cbiAgbWV0cmljSW5kZXhpbmdMYXRlbmN5UDUwSW5NaWxsaXMoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNJbmRleGluZ0xhdGVuY3koe1xuICAgICAgICBzdGF0aXN0aWM6IE1ldHJpY1N0YXRpc3RpYy5QNTAsXG4gICAgICAgIGxhYmVsOiBcIlA1MFwiLFxuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgbWV0cmljSW5kZXhpbmdMYXRlbmN5UDkwSW5NaWxsaXMoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNJbmRleGluZ0xhdGVuY3koe1xuICAgICAgICBzdGF0aXN0aWM6IE1ldHJpY1N0YXRpc3RpYy5QOTAsXG4gICAgICAgIGxhYmVsOiBcIlA5MFwiLFxuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgbWV0cmljSW5kZXhpbmdMYXRlbmN5UDk5SW5NaWxsaXMoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNJbmRleGluZ0xhdGVuY3koe1xuICAgICAgICBzdGF0aXN0aWM6IE1ldHJpY1N0YXRpc3RpYy5QOTksXG4gICAgICAgIGxhYmVsOiBcIlA5OVwiLFxuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgbWV0cmljU2VhcmNoTGF0ZW5jeVA1MEluTWlsbGlzKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkuYWRhcHRNZXRyaWMoXG4gICAgICB0aGlzLmRvbWFpbk1ldHJpY3MubWV0cmljU2VhcmNoTGF0ZW5jeSh7XG4gICAgICAgIHN0YXRpc3RpYzogTWV0cmljU3RhdGlzdGljLlA1MCxcbiAgICAgICAgbGFiZWw6IFwiUDUwXCIsXG4gICAgICB9KVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNTZWFyY2hMYXRlbmN5UDkwSW5NaWxsaXMoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNTZWFyY2hMYXRlbmN5KHtcbiAgICAgICAgc3RhdGlzdGljOiBNZXRyaWNTdGF0aXN0aWMuUDkwLFxuICAgICAgICBsYWJlbDogXCJQOTBcIixcbiAgICAgIH0pXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpY1NlYXJjaExhdGVuY3lQOTlJbk1pbGxpcygpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmFkYXB0TWV0cmljKFxuICAgICAgdGhpcy5kb21haW5NZXRyaWNzLm1ldHJpY1NlYXJjaExhdGVuY3koe1xuICAgICAgICBzdGF0aXN0aWM6IE1ldHJpY1N0YXRpc3RpYy5QOTksXG4gICAgICAgIGxhYmVsOiBcIlA5OVwiLFxuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgbWV0cmljQ2x1c3RlclN0YXR1c1JlZCgpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmFkYXB0TWV0cmljKFxuICAgICAgdGhpcy5kb21haW5NZXRyaWNzLm1ldHJpY0NsdXN0ZXJTdGF0dXNSZWQoe1xuICAgICAgICBsYWJlbDogXCJSZWRcIixcbiAgICAgIH0pXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpY0NsdXN0ZXJTdGF0dXNZZWxsb3coKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNDbHVzdGVyU3RhdHVzWWVsbG93KHtcbiAgICAgICAgbGFiZWw6IFwiWWVsbG93XCIsXG4gICAgICB9KVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNEaXNrU3BhY2VVc2FnZUluUGVyY2VudCgpIHtcbiAgICBjb25zdCB1c2VkID0gdGhpcy5kb21haW5NZXRyaWNzLm1ldHJpYyhcIkNsdXN0ZXJVc2VkU3BhY2VcIiwge1xuICAgICAgc3RhdGlzdGljOiBTdGF0aXN0aWMuU1VNLFxuICAgIH0pO1xuICAgIGNvbnN0IGZyZWUgPSB0aGlzLmRvbWFpbk1ldHJpY3MubWV0cmljKFwiRnJlZVN0b3JhZ2VTcGFjZVwiLCB7XG4gICAgICBzdGF0aXN0aWM6IFN0YXRpc3RpYy5TVU0sXG4gICAgfSk7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5jcmVhdGVNZXRyaWNNYXRoKFxuICAgICAgXCIxMDAgKiAodXNlZC8odXNlZCtmcmVlKSlcIixcbiAgICAgIHsgdXNlZCwgZnJlZSB9LFxuICAgICAgXCJEaXNrIFVzYWdlXCJcbiAgICApO1xuICB9XG5cbiAgbWV0cmljQ3B1VXNhZ2UoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNDUFVVdGlsaXphdGlvbih7XG4gICAgICAgIGxhYmVsOiBcIkNQVSBVc2FnZVwiLFxuICAgICAgfSlcbiAgICApO1xuICB9XG5cbiAgbWV0cmljTWFzdGVyQ3B1VXNhZ2UoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNNYXN0ZXJDUFVVdGlsaXphdGlvbih7XG4gICAgICAgIGxhYmVsOiBcIk1hc3RlciBDUFUgVXNhZ2VcIixcbiAgICAgIH0pXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpY0p2bU1lbW9yeVByZXNzdXJlKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkuYWRhcHRNZXRyaWMoXG4gICAgICB0aGlzLmRvbWFpbk1ldHJpY3MubWV0cmljSlZNTWVtb3J5UHJlc3N1cmUoe1xuICAgICAgICBsYWJlbDogXCJKVk0gTWVtb3J5IFByZXNzdXJlXCIsXG4gICAgICB9KVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNNYXN0ZXJKdm1NZW1vcnlQcmVzc3VyZSgpIHtcbiAgICByZXR1cm4gdGhpcy5tZXRyaWNGYWN0b3J5LmFkYXB0TWV0cmljKFxuICAgICAgdGhpcy5kb21haW5NZXRyaWNzLm1ldHJpY01hc3RlckpWTU1lbW9yeVByZXNzdXJlKHtcbiAgICAgICAgbGFiZWw6IFwiTWFzdGVyIEpWTSBNZW1vcnkgUHJlc3N1cmVcIixcbiAgICAgIH0pXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpY0NsdXN0ZXJJbmRleFdyaXRlc0Jsb2NrZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNDbHVzdGVySW5kZXhXcml0ZXNCbG9ja2VkKHtcbiAgICAgICAgbGFiZWw6IFwiSW5kZXggV3JpdGVzIEJsb2NrZWRcIixcbiAgICAgIH0pXG4gICAgKTtcbiAgfVxuXG4gIC8qKlxuICAgKiBAZGVwcmVjYXRlZCB1c2UgbWV0cmljQ2x1c3RlckluZGV4V3JpdGVzQmxvY2tlZCBpbnN0ZWFkXG4gICAqL1xuICBtZXRyaWNDbHVzdGVySW5kZXhXcml0ZUJsb2NrZWQoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljQ2x1c3RlckluZGV4V3JpdGVzQmxvY2tlZCgpO1xuICB9XG5cbiAgbWV0cmljTm9kZXMoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNOb2Rlcyh7XG4gICAgICAgIGxhYmVsOiBcIk5vZGVzXCIsXG4gICAgICB9KVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNBdXRvbWF0ZWRTbmFwc2hvdEZhaWx1cmUoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNBdXRvbWF0ZWRTbmFwc2hvdEZhaWx1cmUoe1xuICAgICAgICBsYWJlbDogXCJBdXRvbWF0ZWQgU25hcHNob3QgRmFpbHVyZXNcIixcbiAgICAgIH0pXG4gICAgKTtcbiAgfVxuXG4gIG1ldHJpY0ttc0tleUVycm9yKCkge1xuICAgIHJldHVybiB0aGlzLm1ldHJpY0ZhY3RvcnkuYWRhcHRNZXRyaWMoXG4gICAgICB0aGlzLmRvbWFpbk1ldHJpY3MubWV0cmljS01TS2V5RXJyb3Ioe1xuICAgICAgICBsYWJlbDogXCJLTVMgS2V5IEVycm9yXCIsXG4gICAgICB9KVxuICAgICk7XG4gIH1cblxuICBtZXRyaWNLbXNLZXlJbmFjY2Vzc2libGUoKSB7XG4gICAgcmV0dXJuIHRoaXMubWV0cmljRmFjdG9yeS5hZGFwdE1ldHJpYyhcbiAgICAgIHRoaXMuZG9tYWluTWV0cmljcy5tZXRyaWNLTVNLZXlJbmFjY2Vzc2libGUoe1xuICAgICAgICBsYWJlbDogXCJLTVMgS2V5IEluYWNjZXNzaWJsZVwiLFxuICAgICAgfSlcbiAgICApO1xuICB9XG59XG4iXX0=