"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RdsClusterMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const RdsNamespace = "AWS/RDS";
class RdsClusterMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.clusterIdentifier =
            RdsClusterMetricFactory.resolveDbClusterIdentifier(props);
        this.dimensionsMap = { DBClusterIdentifier: this.clusterIdentifier };
    }
    static resolveDbClusterIdentifier(props) {
        if (props.clusterIdentifier !== undefined && props.cluster === undefined) {
            return props.clusterIdentifier;
        }
        else if (props.clusterIdentifier === undefined &&
            props.cluster !== undefined) {
            return props.cluster.clusterIdentifier;
        }
        else if (props.cluster !== undefined && props.cluster !== undefined) {
            throw Error("Only one of `clusterIdentifier` and `cluster` is supported");
        }
        else {
            throw Error("At least one of `clusterIdentifier` or `cluster` is required");
        }
    }
    metricTotalConnectionCount() {
        return this.metric("DatabaseConnections", common_1.MetricStatistic.AVERAGE, "Connections");
    }
    metricFreeStorageInBytes() {
        return this.metric("FreeLocalStorage", common_1.MetricStatistic.MIN, "Free");
    }
    metricUsedStorageInBytes() {
        return this.metric("VolumeBytesUsed", common_1.MetricStatistic.MAX, "Used");
    }
    metricDiskSpaceUsageInPercent() {
        const used = this.metricUsedStorageInBytes();
        const free = this.metricFreeStorageInBytes();
        return this.metricFactory.createMetricMath("100 * (used/(used+free))", { used, free }, "Disk Usage");
    }
    metricAverageCpuUsageInPercent() {
        return this.metric("CPUUtilization", common_1.MetricStatistic.AVERAGE, "CPU Usage");
    }
    metricSelectLatencyP90InMillis() {
        return this.metric("SelectLatency", common_1.MetricStatistic.P90, "Select");
    }
    metricInsertLatencyP90InMillis() {
        return this.metric("InsertLatency", common_1.MetricStatistic.P90, "Insert");
    }
    metricUpdateLatencyP90InMillis() {
        return this.metric("UpdateLatency", common_1.MetricStatistic.P90, "Update");
    }
    metricDeleteLatencyP90InMillis() {
        return this.metric("DeleteLatency", common_1.MetricStatistic.P90, "Delete");
    }
    metricCommitLatencyP90InMillis() {
        return this.metric("CommitLatency", common_1.MetricStatistic.P90, "Commit");
    }
    metric(metricName, statistic, label) {
        return this.metricFactory.createMetric(metricName, statistic, label, this.dimensionsMap, undefined, RdsNamespace);
    }
}
exports.RdsClusterMetricFactory = RdsClusterMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
RdsClusterMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.RdsClusterMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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