"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RedshiftClusterMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const RedshiftClusterMetricFactory_1 = require("./RedshiftClusterMetricFactory");
class RedshiftClusterMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            fallbackConstructName: props.clusterIdentifier,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.url = scope
            .createAwsConsoleUrlFactory()
            .getRedshiftClusterUrl(props.clusterIdentifier);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.usageAlarmFactory = new common_1.UsageAlarmFactory(alarmFactory);
        this.latencyAlarmFactory = new common_1.LatencyAlarmFactory(alarmFactory);
        this.connectionAlarmFactory = new common_1.ConnectionAlarmFactory(alarmFactory);
        this.queryDurationAnnotations = [];
        this.connectionAnnotations = [];
        this.usageAnnotations = [];
        const metricFactory = new RedshiftClusterMetricFactory_1.RedshiftClusterMetricFactory(scope.createMetricFactory(), props);
        this.connectionsMetric = metricFactory.metricTotalConnectionCount();
        this.diskSpaceUsageMetric =
            metricFactory.metricAverageDiskSpaceUsageInPercent();
        this.cpuUsageMetric = metricFactory.metricAverageCpuUsageInPercent();
        this.shortQueryDurationMetric =
            metricFactory.metricShortQueryDurationP90InMillis();
        this.mediumQueryDurationMetric =
            metricFactory.metricMediumQueryDurationP90InMillis();
        this.longQueryDurationMetric =
            metricFactory.metricLongQueryDurationP90InMillis();
        this.readLatencyMetric = metricFactory.metricReadLatencyP90InMillis();
        this.writeLatencyMetric = metricFactory.metricWriteLatencyP90InMillis();
        this.maintenanceModeMetric = metricFactory.metricMaintenanceModeEnabled();
        for (const disambiguator in props.addDiskSpaceUsageAlarm) {
            const alarmProps = props.addDiskSpaceUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxDiskUsagePercentAlarm(this.diskSpaceUsageMetric, alarmProps, disambiguator);
            this.usageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addCpuUsageAlarm) {
            const alarmProps = props.addCpuUsageAlarm[disambiguator];
            const createdAlarm = this.usageAlarmFactory.addMaxCpuUsagePercentAlarm(this.cpuUsageMetric, alarmProps, disambiguator);
            this.usageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxLongQueryDurationAlarm) {
            const alarmProps = props.addMaxLongQueryDurationAlarm[disambiguator];
            const createdAlarm = this.latencyAlarmFactory.addDurationAlarm(this.longQueryDurationMetric, common_1.LatencyType.P90, alarmProps, disambiguator);
            this.queryDurationAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMinConnectionCountAlarm) {
            const alarmProps = props.addMinConnectionCountAlarm[disambiguator];
            const createdAlarm = this.connectionAlarmFactory.addMinConnectionCountAlarm(this.connectionsMetric, alarmProps, disambiguator);
            this.connectionAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxConnectionCountAlarm) {
            const alarmProps = props.addMaxConnectionCountAlarm[disambiguator];
            const createdAlarm = this.connectionAlarmFactory.addMaxConnectionCountAlarm(this.connectionsMetric, alarmProps, disambiguator);
            this.connectionAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createCpuAndDiskUsageWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createConnectionsWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createQueryDurationWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createCpuAndDiskUsageWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createConnectionsWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createQueryDurationWidget(common_1.QuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createLatencyWidget(common_1.HalfQuarterWidth, common_1.DefaultGraphWidgetHeight),
            this.createMaintenanceWidget(common_1.HalfQuarterWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Redshift Cluster",
            title: this.title,
            goToLinkUrl: this.url,
        });
    }
    createCpuAndDiskUsageWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "CPU/Disk Usage",
            left: [this.cpuUsageMetric, this.diskSpaceUsageMetric],
            leftYAxis: common_1.PercentageAxisFromZeroToHundred,
            leftAnnotations: this.usageAnnotations,
        });
    }
    createConnectionsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Connections",
            left: [this.connectionsMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.connectionAnnotations,
        });
    }
    createQueryDurationWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Query Duration",
            left: [
                this.shortQueryDurationMetric,
                this.mediumQueryDurationMetric,
                this.longQueryDurationMetric,
            ],
            leftYAxis: common_1.TimeAxisMillisFromZero,
            leftAnnotations: this.queryDurationAnnotations,
        });
    }
    createLatencyWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Latency",
            left: [this.readLatencyMetric, this.writeLatencyMetric],
            leftYAxis: common_1.TimeAxisMillisFromZero,
        });
    }
    createMaintenanceWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Maintenance",
            left: [this.maintenanceModeMetric],
            leftYAxis: common_1.BooleanAxisFromZeroToOne,
        });
    }
}
exports.RedshiftClusterMonitoring = RedshiftClusterMonitoring;
_a = JSII_RTTI_SYMBOL_1;
RedshiftClusterMonitoring[_a] = { fqn: "cdk-monitoring-constructs.RedshiftClusterMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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