"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3BucketMetricFactory = exports.StorageType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/S3";
var StorageType;
(function (StorageType) {
    StorageType["DEEP_ARCHIVE_OBJECT_OVERHEAD"] = "DeepArchiveObjectOverhead";
    StorageType["DEEP_ARCHIVE_S3_OBJECT_OVERHEAD"] = "DeepArchiveS3ObjectOverhead";
    StorageType["DEEP_ARCHIVE_STAGING_STORAGE"] = "DeepArchiveStagingStorage";
    StorageType["DEEP_ARCHIVE_STORAGE"] = "DeepArchiveStorage";
    StorageType["GLACIER_OBJECT_OVERHEAD"] = "GlacierObjectOverhead";
    StorageType["GLACIER_S3_OBJECT_OVERHEAD"] = "GlacierS3ObjectOverhead";
    StorageType["GLACIER_STAGING_STORAGE"] = "GlacierStagingStorage";
    StorageType["GLACIER_STORAGE"] = "GlacierStorage";
    StorageType["INTELLIGENT_TIERING_FA_STORAGE"] = "IntelligentTieringFAStorage";
    StorageType["INTELLIGENT_TIERING_IA_STORAGE"] = "IntelligentTieringIAStorage";
    StorageType["ONE_ZONE_IA_SIZE_OVERHEAD"] = "OneZoneIASizeOverhead";
    StorageType["ONE_ZONE_IA_STORAGE"] = "OneZoneIAStorage";
    StorageType["REDUCED_REDUNDANCY_STORAGE"] = "ReducedRedundancyStorage";
    StorageType["STANDARD_IA_SIZE_OVERHEAD"] = "StandardIASizeOverhead";
    StorageType["STANDARD_IA_STORAGE"] = "StandardIAStorage";
    StorageType["STANDARD_STORAGE"] = "StandardStorage";
})(StorageType = exports.StorageType || (exports.StorageType = {}));
class S3BucketMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.props = props;
    }
    metricBucketSizeBytes() {
        return this.metricFactory.createMetric("BucketSizeBytes", common_1.MetricStatistic.AVERAGE, "BucketSizeBytes", {
            BucketName: this.props.bucket.bucketName,
            StorageType: this.props.storageType ?? StorageType.STANDARD_STORAGE,
        }, undefined, Namespace);
    }
    metricNumberOfObjects() {
        return this.metricFactory.createMetric("NumberOfObjects", common_1.MetricStatistic.AVERAGE, "NumberOfObjects", {
            BucketName: this.props.bucket.bucketName,
            StorageType: "AllStorageTypes",
        }, undefined, Namespace);
    }
}
exports.S3BucketMetricFactory = S3BucketMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
S3BucketMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.S3BucketMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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