"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretsManagerMetricsPublisher = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_events_1 = require("aws-cdk-lib/aws-events");
const aws_events_targets_1 = require("aws-cdk-lib/aws-events-targets");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const constructs_1 = require("constructs");
const SecretsManagerSecretMetricFactory_1 = require("./SecretsManagerSecretMetricFactory");
class SecretsManagerMetricsPublisher extends constructs_1.Construct {
    constructor(scope) {
        super(scope, "SecretsManagerMetricsPublisher");
        this.lambda = new aws_lambda_1.Function(this, "Lambda", {
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, "..", "..", "..", "assets", "SecretsManagerMetricsPublisher")),
            description: "Custom metrics publisher for SecretsManager Secrets (MonitoringCDKConstructs)",
            handler: "index.handler",
            memorySize: 128,
            runtime: aws_lambda_1.Runtime.NODEJS_14_X,
            timeout: aws_cdk_lib_1.Duration.seconds(60),
            logRetention: aws_logs_1.RetentionDays.ONE_DAY,
        });
        this.lambda.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ["secretsmanager:DescribeSecret"],
            resources: ["*"],
        }));
        this.lambda.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ["cloudwatch:PutMetricData"],
            resources: ["*"],
            conditions: {
                StringEquals: {
                    "cloudwatch:namespace": SecretsManagerSecretMetricFactory_1.SecretsManagerSecretMetricFactory.Namespace,
                },
            },
        }));
    }
    static getInstance(scope) {
        const key = aws_cdk_lib_1.Names.nodeUniqueId(scope.node);
        let instance = SecretsManagerMetricsPublisher.instances[key];
        if (!instance) {
            instance = new SecretsManagerMetricsPublisher(scope);
            SecretsManagerMetricsPublisher.instances[key] = instance;
        }
        return instance;
    }
    addSecret(secret) {
        // run 1/hr so alarms can recover automatically
        const rule = new aws_events_1.Rule(this, `RuleFor${aws_cdk_lib_1.Names.nodeUniqueId(secret.node)}`, {
            schedule: aws_events_1.Schedule.cron({
                minute: "0",
            }),
        });
        rule.addTarget(new aws_events_targets_1.LambdaFunction(this.lambda, {
            event: aws_events_1.RuleTargetInput.fromObject({
                secretId: secret.secretArn,
            }),
        }));
    }
}
exports.SecretsManagerMetricsPublisher = SecretsManagerMetricsPublisher;
_a = JSII_RTTI_SYMBOL_1;
SecretsManagerMetricsPublisher[_a] = { fqn: "cdk-monitoring-constructs.SecretsManagerMetricsPublisher", version: "1.27.0" };
SecretsManagerMetricsPublisher.instances = {};
//# sourceMappingURL=data:application/json;base64,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