"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretsManagerSecretMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const SecretsManagerMetricsPublisher_1 = require("./SecretsManagerMetricsPublisher");
const SecretsManagerSecretMetricFactory_1 = require("./SecretsManagerSecretMetricFactory");
class SecretsManagerSecretMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope);
        const publisher = SecretsManagerMetricsPublisher_1.SecretsManagerMetricsPublisher.getInstance(scope);
        publisher.addSecret(props.secret);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.secret,
            fallbackConstructName: props.secret.secretName,
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.showLastRotationWidget = !!(props.showLastRotationWidget || props.addDaysSinceLastRotationAlarm);
        const metricFactory = new SecretsManagerSecretMetricFactory_1.SecretsManagerSecretMetricFactory(scope.createMetricFactory(), props);
        this.daysSinceLastChangeMetric = metricFactory.metricDaysSinceLastChange();
        this.daysSinceLastRotationMetric =
            metricFactory.metricDaysSinceLastRotation();
        this.alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        const ageAlarmFactory = new common_1.AgeAlarmFactory(this.alarmFactory);
        this.daysSinceLastChangeAnnotations = [];
        this.daysSinceLastRotationAnnotations = [];
        for (const disambiguator in props.addDaysSinceLastChangeAlarm) {
            const alarmProps = props.addDaysSinceLastChangeAlarm[disambiguator];
            const createdAlarm = ageAlarmFactory.addDaysSinceUpdateAlarm(this.daysSinceLastChangeMetric, alarmProps, disambiguator);
            this.daysSinceLastChangeAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDaysSinceLastRotationAlarm) {
            const alarmProps = props.addDaysSinceLastRotationAlarm[disambiguator];
            const createdAlarm = ageAlarmFactory.addDaysSinceUpdateAlarm(this.daysSinceLastRotationMetric, alarmProps, disambiguator);
            this.daysSinceLastRotationAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
        props.usePublisher?.consume(publisher.lambda);
    }
    createDaysSinceLastChangeWidget() {
        return new aws_cloudwatch_1.GraphWidget({
            width: common_1.HalfWidth,
            height: common_1.DefaultGraphWidgetHeight,
            title: "Days since last change",
            left: [this.daysSinceLastChangeMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.daysSinceLastChangeAnnotations,
        });
    }
    createDaysSinceLastRotationWidget() {
        return new aws_cloudwatch_1.GraphWidget({
            width: common_1.HalfWidth,
            height: common_1.DefaultGraphWidgetHeight,
            title: "Days since last rotation",
            left: [this.daysSinceLastRotationMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.daysSinceLastRotationAnnotations,
        });
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Secret",
            title: this.title,
        });
    }
    widgets() {
        const widgets = [
            this.createTitleWidget(),
            this.createDaysSinceLastChangeWidget(),
        ];
        if (this.showLastRotationWidget) {
            widgets.push(this.createDaysSinceLastRotationWidget());
        }
        return widgets;
    }
    summaryWidgets() {
        // TODO verify dimensions, mainly height
        return this.widgets();
    }
}
exports.SecretsManagerSecretMonitoring = SecretsManagerSecretMonitoring;
_a = JSII_RTTI_SYMBOL_1;
SecretsManagerSecretMonitoring[_a] = { fqn: "cdk-monitoring-constructs.SecretsManagerSecretMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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