"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsTopicMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
class SnsTopicMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.topic = props.topic;
    }
    metricIncomingMessageCount() {
        return this.metricFactory.adaptMetric(this.topic.metricNumberOfMessagesPublished({
            label: "Incoming",
        }));
    }
    metricOutgoingMessageCount() {
        return this.metricFactory.adaptMetric(this.topic.metricNumberOfNotificationsDelivered({
            label: "Outgoing",
        }));
    }
    metricAverageMessageSizeInBytes() {
        return this.metricFactory.adaptMetric(this.topic.metricPublishSize({
            label: "Size",
        }));
    }
    metricNumberOfNotificationsFailed() {
        return this.metricFactory.adaptMetric(this.topic.metricNumberOfNotificationsFailed({
            label: "Failed",
        }));
    }
}
exports.SnsTopicMetricFactory = SnsTopicMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
SnsTopicMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.SnsTopicMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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