"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsTopicMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const SnsTopicMetricFactory_1 = require("./SnsTopicMetricFactory");
class SnsTopicMonitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.topic,
            fallbackConstructName: this.resolveTopicName(props.topic),
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.topicUrl = scope
            .createAwsConsoleUrlFactory()
            .getSnsTopicUrl(props.topic.topicArn);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.topicAlarmFactory = new common_1.TopicAlarmFactory(alarmFactory);
        this.failedDeliveryAnnotations = [];
        this.incomingMessagesAnnotations = [];
        const metricFactory = new SnsTopicMetricFactory_1.SnsTopicMetricFactory(scope.createMetricFactory(), props);
        this.incomingMessagesMetric = metricFactory.metricIncomingMessageCount();
        this.outgoingMessagesMetric = metricFactory.metricOutgoingMessageCount();
        this.messageSizeMetric = metricFactory.metricAverageMessageSizeInBytes();
        this.messagesFailedMetric =
            metricFactory.metricNumberOfNotificationsFailed();
        for (const disambiguator in props.addMessageNotificationsFailedAlarm) {
            const alarmProps = props.addMessageNotificationsFailedAlarm[disambiguator];
            const createdAlarm = this.topicAlarmFactory.addMessageNotificationsFailedAlarm(this.messagesFailedMetric, alarmProps, disambiguator);
            this.failedDeliveryAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMinNumberOfMessagesPublishedAlarm) {
            const alarmProps = props.addMinNumberOfMessagesPublishedAlarm[disambiguator];
            const createdAlarm = this.topicAlarmFactory.addMinMessagesPublishedAlarm(this.incomingMessagesMetric, alarmProps, disambiguator);
            this.incomingMessagesAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addMaxNumberOfMessagesPublishedAlarm) {
            const alarmProps = props.addMaxNumberOfMessagesPublishedAlarm[disambiguator];
            const createdAlarm = this.topicAlarmFactory.addMaxMessagesPublishedAlarm(this.incomingMessagesMetric, alarmProps, disambiguator);
            this.incomingMessagesAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createMessageCountWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            this.createMessageFailedWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createMessageCountWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createMessageSizeWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createMessageFailedWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "SNS Topic",
            title: this.title,
            goToLinkUrl: this.topicUrl,
        });
    }
    createMessageCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Count",
            left: [this.incomingMessagesMetric, this.outgoingMessagesMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.incomingMessagesAnnotations,
        });
    }
    createMessageSizeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Size",
            left: [this.messageSizeMetric],
            leftYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
    createMessageFailedWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Delivery Failed",
            left: [this.messagesFailedMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.failedDeliveryAnnotations,
        });
    }
    resolveTopicName(snsTopic) {
        // try to take the name (if specified) instead of token
        return snsTopic.node.defaultChild?.topicName;
    }
}
exports.SnsTopicMonitoring = SnsTopicMonitoring;
_a = JSII_RTTI_SYMBOL_1;
SnsTopicMonitoring[_a] = { fqn: "cdk-monitoring-constructs.SnsTopicMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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