"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsQueueMonitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const SqsQueueMetricFactory_1 = require("./SqsQueueMetricFactory");
class SqsQueueMonitoring extends common_1.Monitoring {
    constructor(scope, props, invokedFromSuper) {
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.queue,
            fallbackConstructName: this.resolveQueueName(props.queue),
        });
        this.title = namingStrategy.resolveHumanReadableName();
        this.queueUrl = scope
            .createAwsConsoleUrlFactory()
            .getSqsQueueUrl(props.queue.queueUrl);
        const alarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName());
        this.queueAlarmFactory = new common_1.QueueAlarmFactory(alarmFactory);
        this.countAnnotations = [];
        this.ageAnnotations = [];
        this.timeToDrainAnnotations = [];
        const metricFactory = new SqsQueueMetricFactory_1.SqsQueueMetricFactory(scope.createMetricFactory(), props);
        this.visibleMessagesMetric =
            metricFactory.metricApproximateVisibleMessageCount();
        this.incomingMessagesMetric = metricFactory.metricIncomingMessageCount();
        this.deletedMessagesMetric = metricFactory.metricDeletedMessageCount();
        this.oldestMessageAgeMetric =
            metricFactory.metricApproximateAgeOfOldestMessageInSeconds();
        this.messageSizeMetric = metricFactory.metricAverageMessageSizeInBytes();
        this.productionRateMetric = metricFactory.metricProductionRate();
        this.consumptionRateMetric = metricFactory.metricConsumptionRate();
        this.timeToDrainMetric = metricFactory.metricTimeToDrain();
        for (const disambiguator in props.addQueueMinSizeAlarm) {
            const alarmProps = props.addQueueMinSizeAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMinQueueMessageCountAlarm(this.visibleMessagesMetric, alarmProps, disambiguator);
            this.countAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMaxSizeAlarm) {
            const alarmProps = props.addQueueMaxSizeAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMaxQueueMessageCountAlarm(this.visibleMessagesMetric, alarmProps, disambiguator);
            this.countAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMaxMessageAgeAlarm) {
            const alarmProps = props.addQueueMaxMessageAgeAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMaxQueueMessageAgeAlarm(this.oldestMessageAgeMetric, alarmProps, disambiguator);
            this.ageAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMaxTimeToDrainMessagesAlarm) {
            const alarmProps = props.addQueueMaxTimeToDrainMessagesAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMaxQueueTimeToDrainMessagesAlarm(this.timeToDrainMetric, alarmProps, disambiguator);
            this.timeToDrainAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMinIncomingMessagesAlarm) {
            const alarmProps = props.addQueueMinIncomingMessagesAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMinQueueIncomingMessagesCountAlarm(this.incomingMessagesMetric, alarmProps, disambiguator);
            this.countAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addQueueMaxIncomingMessagesAlarm) {
            const alarmProps = props.addQueueMaxIncomingMessagesAlarm[disambiguator];
            const createdAlarm = this.queueAlarmFactory.addMaxQueueIncomingMessagesCountAlarm(this.incomingMessagesMetric, alarmProps, disambiguator);
            this.countAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        if (!(invokedFromSuper ?? false)) {
            // invoke only when not called from super class, so it is not called twice
            // TODO: find a more elegant solution for this
            props.useCreatedAlarms?.consume(this.createdAlarms());
        }
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createProducerAndConsumerRateWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight), this.createTimeToDrainWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight)),
            new aws_cloudwatch_1.Row(this.createMessageCountWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight), this.createMessageAgeWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight)),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            new aws_cloudwatch_1.Row(this.createMessageCountWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createMessageAgeWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight), this.createMessageSizeWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight)),
            new aws_cloudwatch_1.Row(this.createProducerAndConsumerRateWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight), this.createTimeToDrainWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight)),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "SQS Queue",
            title: this.title,
            goToLinkUrl: this.queueUrl,
        });
    }
    createMessageCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Count",
            left: [this.visibleMessagesMetric, this.incomingMessagesMetric],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.countAnnotations,
        });
    }
    createMessageAgeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Oldest Message Age",
            left: [this.oldestMessageAgeMetric],
            leftYAxis: common_1.TimeAxisSecondsFromZero,
            leftAnnotations: this.ageAnnotations,
        });
    }
    createMessageSizeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Message Size",
            left: [this.messageSizeMetric],
            leftYAxis: common_1.SizeAxisBytesFromZero,
        });
    }
    createProducerAndConsumerRateWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Producer vs Consumer (rate)",
            left: [this.productionRateMetric, this.consumptionRateMetric],
            leftYAxis: common_1.RateAxisFromZero,
        });
    }
    createTimeToDrainWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Time to drain",
            left: [this.timeToDrainMetric],
            leftYAxis: common_1.TimeAxisSecondsFromZero,
        });
    }
    resolveQueueName(queue) {
        // try to take the name (if specified) instead of token
        return queue.node.defaultChild?.queueName;
    }
}
exports.SqsQueueMonitoring = SqsQueueMonitoring;
_a = JSII_RTTI_SYMBOL_1;
SqsQueueMonitoring[_a] = { fqn: "cdk-monitoring-constructs.SqsQueueMonitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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