"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsQueueMonitoringWithDlq = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const SqsQueueMetricFactory_1 = require("./SqsQueueMetricFactory");
const SqsQueueMonitoring_1 = require("./SqsQueueMonitoring");
class SqsQueueMonitoringWithDlq extends SqsQueueMonitoring_1.SqsQueueMonitoring {
    constructor(scope, props) {
        super(scope, props, true);
        const deadLetterMetricFactory = new SqsQueueMetricFactory_1.SqsQueueMetricFactory(scope.createMetricFactory(), {
            ...props,
            queue: props.deadLetterQueue,
        });
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.deadLetterQueue,
            fallbackConstructName: this.resolveQueueName(props.deadLetterQueue),
        });
        this.deadLetterTitle = namingStrategy.resolveHumanReadableName();
        this.deadLetterUrl = scope
            .createAwsConsoleUrlFactory()
            .getSqsQueueUrl(props.deadLetterQueue.queueUrl);
        this.addDeadLetterQueueToSummaryDashboard =
            props.addDeadLetterQueueToSummaryDashboard ?? false;
        const deadLetterAlarmFactory = this.createAlarmFactory(namingStrategy.resolveAlarmFriendlyName() + "-DLQ");
        this.deadLetterCountAnnotations = [];
        this.deadLetterAgeAnnotations = [];
        this.deadLetterQueueAlarmFactory = new common_1.QueueAlarmFactory(deadLetterAlarmFactory);
        this.deadLetterQueueVisibleMessagesMetric =
            deadLetterMetricFactory.metricApproximateVisibleMessageCount();
        this.deadLetterQueueIncomingMessagesMetric =
            deadLetterMetricFactory.metricIncomingMessageCount();
        this.deadLetterQueueOldestMessageAgeMetric =
            deadLetterMetricFactory.metricApproximateAgeOfOldestMessageInSeconds();
        for (const disambiguator in props.addDeadLetterQueueMaxSizeAlarm) {
            const alarmProps = props.addDeadLetterQueueMaxSizeAlarm[disambiguator];
            const createdAlarm = this.deadLetterQueueAlarmFactory.addMaxQueueMessageCountAlarm(this.deadLetterQueueVisibleMessagesMetric, alarmProps, disambiguator);
            this.deadLetterCountAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDeadLetterQueueMaxMessageAgeAlarm) {
            const alarmProps = props.addDeadLetterQueueMaxMessageAgeAlarm[disambiguator];
            const createdAlarm = this.deadLetterQueueAlarmFactory.addMaxQueueMessageAgeAlarm(this.deadLetterQueueOldestMessageAgeMetric, alarmProps, disambiguator);
            this.deadLetterAgeAnnotations.push(createdAlarm.annotation);
            this.addAlarm(createdAlarm);
        }
        for (const disambiguator in props.addDeadLetterQueueMaxIncomingMessagesAlarm) {
            const alarmProps = props.addDeadLetterQueueMaxIncomingMessagesAlarm[disambiguator];
            const createdAlarm = this.deadLetterQueueAlarmFactory.addMaxQueueIncomingMessagesCountAlarm(this.deadLetterQueueIncomingMessagesMetric, alarmProps, disambiguator);
            this.addAlarm(createdAlarm);
        }
        props.useCreatedAlarms?.consume(this.createdAlarms());
    }
    summaryWidgets() {
        const addToSummary = this.addDeadLetterQueueToSummaryDashboard ?? true;
        if (!addToSummary) {
            // do not show the DLQ widgets at all
            return super.summaryWidgets();
        }
        return [
            ...super.summaryWidgets(),
            this.createDeadLetterMessageCountWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
            this.createDeadLetterMessageAgeWidget(common_1.HalfWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            ...super.widgets(),
            this.createDeadLetterTitleWidget(),
            this.createDeadLetterMessageCountWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
            this.createDeadLetterMessageAgeWidget(common_1.HalfWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createDeadLetterTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "SQS Dead-Letter Queue",
            title: this.deadLetterTitle,
            goToLinkUrl: this.deadLetterUrl,
        });
    }
    createDeadLetterMessageCountWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "DLQ: Message Count",
            left: [
                this.deadLetterQueueVisibleMessagesMetric,
                this.deadLetterQueueIncomingMessagesMetric,
            ],
            leftYAxis: common_1.CountAxisFromZero,
            leftAnnotations: this.deadLetterCountAnnotations,
        });
    }
    createDeadLetterMessageAgeWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "DLQ: Oldest Message Age",
            left: [this.deadLetterQueueOldestMessageAgeMetric],
            leftYAxis: common_1.TimeAxisSecondsFromZero,
            leftAnnotations: this.deadLetterAgeAnnotations,
        });
    }
}
exports.SqsQueueMonitoringWithDlq = SqsQueueMonitoringWithDlq;
_a = JSII_RTTI_SYMBOL_1;
SqsQueueMonitoringWithDlq[_a] = { fqn: "cdk-monitoring-constructs.SqsQueueMonitoringWithDlq", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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