"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionActivityMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/States";
class StepFunctionActivityMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.rateComputationMethod = common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            ActivityArn: props.activity.activityArn,
        };
    }
    metricActivityRunTimeP99InMillis() {
        return this.metricFactory.createMetric("ActivityRunTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityRunTimeP90InMillis() {
        return this.metricFactory.createMetric("ActivityRunTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityRunTimeP50InMillis() {
        return this.metricFactory.createMetric("ActivityRunTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityScheduleTimeP99InMillis() {
        return this.metricFactory.createMetric("ActivityScheduleTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityScheduleTimeP90InMillis() {
        return this.metricFactory.createMetric("ActivityScheduleTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityScheduleTimeP50InMillis() {
        return this.metricFactory.createMetric("ActivityScheduleTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityTimeP99InMillis() {
        return this.metricFactory.createMetric("ActivityTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityTimeP90InMillis() {
        return this.metricFactory.createMetric("ActivityTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricActivityTimeP50InMillis() {
        return this.metricFactory.createMetric("ActivityTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesFailed() {
        return this.metricFactory.createMetric("ActivitiesFailed", common_1.MetricStatistic.SUM, "Failed", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesFailedRate() {
        const metric = this.metricActivitiesFailed();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    metricActivitiesHeartbeatTimedOut() {
        return this.metricFactory.createMetric("ActivitiesHeartbeatTimedOut", common_1.MetricStatistic.SUM, "HeartbeatTimedOut", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesScheduled() {
        return this.metricFactory.createMetric("ActivitiesScheduled", common_1.MetricStatistic.SUM, "Scheduled", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesStarted() {
        return this.metricFactory.createMetric("ActivitiesStarted", common_1.MetricStatistic.SUM, "Started", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesSucceeded() {
        return this.metricFactory.createMetric("ActivitiesSucceeded", common_1.MetricStatistic.SUM, "Succeeded", this.dimensionsMap, undefined, Namespace);
    }
    metricActivitiesTimedOut() {
        return this.metricFactory.createMetric("ActivitiesTimedOut", common_1.MetricStatistic.SUM, "Timeout", this.dimensionsMap, undefined, Namespace);
    }
}
exports.StepFunctionActivityMetricFactory = StepFunctionActivityMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionActivityMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.StepFunctionActivityMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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