"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/States";
class StepFunctionMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.rateComputationMethod = common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            StateMachineArn: props.stateMachine.stateMachineArn,
        };
    }
    metricExecutionTimeP99InMillis() {
        return this.metricFactory.createMetric("ExecutionTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionTimeP90InMillis() {
        return this.metricFactory.createMetric("ExecutionTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionTimeP50InMillis() {
        return this.metricFactory.createMetric("ExecutionTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsFailed() {
        return this.metricFactory.createMetric("ExecutionsFailed", common_1.MetricStatistic.SUM, "Failed", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsFailedRate() {
        const metric = this.metricExecutionsFailed();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    metricExecutionsTimedOut() {
        return this.metricFactory.createMetric("ExecutionsTimedOut", common_1.MetricStatistic.SUM, "Timeout", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionThrottled() {
        return this.metricFactory.createMetric("ExecutionThrottled", common_1.MetricStatistic.SUM, "Throttled", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsAborted() {
        return this.metricFactory.createMetric("ExecutionsAborted", common_1.MetricStatistic.SUM, "Aborted", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsStarted() {
        return this.metricFactory.createMetric("ExecutionsStarted", common_1.MetricStatistic.SUM, "Started", this.dimensionsMap, undefined, Namespace);
    }
    metricExecutionsSucceeded() {
        return this.metricFactory.createMetric("ExecutionsSucceeded", common_1.MetricStatistic.SUM, "Succeeded", this.dimensionsMap, undefined, Namespace);
    }
}
exports.StepFunctionMetricFactory = StepFunctionMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.StepFunctionMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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