"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepFunctionServiceIntegrationMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const Namespace = "AWS/States";
class StepFunctionServiceIntegrationMetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.rateComputationMethod = common_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            ServiceIntegrationResourceArn: props.serviceIntegrationResourceArn,
        };
    }
    metricServiceIntegrationRunTimeP99InMillis() {
        return this.metricFactory.createMetric("ServiceIntegrationRunTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationRunTimeP90InMillis() {
        return this.metricFactory.createMetric("ServiceIntegrationRunTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationRunTimeP50InMillis() {
        return this.metricFactory.createMetric("ServiceIntegrationRunTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationScheduleTimeP99InMillis() {
        return this.metricFactory.createMetric("ServiceIntegrationScheduleTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationScheduleTimeP90InMillis() {
        return this.metricFactory.createMetric("ServiceIntegrationScheduleTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationScheduleTimeP50InMillis() {
        return this.metricFactory.createMetric("ServiceIntegrationScheduleTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationTimeP99InMillis() {
        return this.metricFactory.createMetric("ServiceIntegrationTime", common_1.MetricStatistic.P99, "P99", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationTimeP90InMillis() {
        return this.metricFactory.createMetric("ServiceIntegrationTime", common_1.MetricStatistic.P90, "P90", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationTimeP50InMillis() {
        return this.metricFactory.createMetric("ServiceIntegrationTime", common_1.MetricStatistic.P50, "P50", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationsFailed() {
        return this.metricFactory.createMetric("ServiceIntegrationsFailed", common_1.MetricStatistic.SUM, "Failed", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationsFailedRate() {
        const metric = this.metricServiceIntegrationsFailed();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
    metricServiceIntegrationsScheduled() {
        return this.metricFactory.createMetric("ServiceIntegrationsScheduled", common_1.MetricStatistic.SUM, "Scheduled", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationsStarted() {
        return this.metricFactory.createMetric("ServiceIntegrationsStarted", common_1.MetricStatistic.SUM, "Started", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationsSucceeded() {
        return this.metricFactory.createMetric("ServiceIntegrationsSucceeded", common_1.MetricStatistic.SUM, "Succeeded", this.dimensionsMap, undefined, Namespace);
    }
    metricServiceIntegrationsTimedOut() {
        return this.metricFactory.createMetric("ServiceIntegrationsTimedOut", common_1.MetricStatistic.SUM, "Timeout", this.dimensionsMap, undefined, Namespace);
    }
}
exports.StepFunctionServiceIntegrationMetricFactory = StepFunctionServiceIntegrationMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
StepFunctionServiceIntegrationMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.StepFunctionServiceIntegrationMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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