"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyntheticsCanaryMetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const index_1 = require("../../common/index");
const MetricNamespace = "CloudWatchSynthetics";
class SyntheticsCanaryMetricFactory {
    constructor(metricFactory, props) {
        this.canary = props.canary;
        this.metricFactory = metricFactory;
        this.rateComputationMethod =
            props.rateComputationMethod ?? index_1.RateComputationMethod.AVERAGE;
        this.dimensionsMap = {
            CanaryName: props.canary.canaryName,
        };
    }
    metricLatencyAverageInMillis() {
        return this.metricFactory.adaptMetric(this.canary.metricDuration({
            label: "Average",
            statistic: index_1.MetricStatistic.AVERAGE,
        }));
    }
    metricSuccessInPercent() {
        return this.metricFactory.adaptMetric(this.canary.metricSuccessPercent({
            label: "Success Rate",
            statistic: index_1.MetricStatistic.AVERAGE,
        }));
    }
    metric4xxErrorCount() {
        return this.metricFactory.createMetric("4xx", index_1.MetricStatistic.SUM, "4xx", this.dimensionsMap, undefined, MetricNamespace);
    }
    metric4xxErrorRate() {
        const metric = this.metric4xxErrorCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "errors");
    }
    metric5xxFaultCount() {
        return this.metricFactory.createMetric("5xx", index_1.MetricStatistic.SUM, "5xx", this.dimensionsMap, undefined, MetricNamespace);
    }
    metric5xxFaultRate() {
        const metric = this.metric5xxFaultCount();
        return this.metricFactory.toRate(metric, this.rateComputationMethod, false, "faults");
    }
}
exports.SyntheticsCanaryMetricFactory = SyntheticsCanaryMetricFactory;
_a = JSII_RTTI_SYMBOL_1;
SyntheticsCanaryMetricFactory[_a] = { fqn: "cdk-monitoring-constructs.SyntheticsCanaryMetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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