"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafV2MetricFactory = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const common_1 = require("../../common");
const MetricNamespace = "AWS/WAFV2";
const AllRulesDimensionValue = "ALL";
/**
 * https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html
 */
class WafV2MetricFactory {
    constructor(metricFactory, props) {
        this.metricFactory = metricFactory;
        this.dimensions = {
            Rule: AllRulesDimensionValue,
            WebACL: props.acl.name,
        };
    }
    metricAllowedRequests() {
        return this.metricFactory.createMetric("AllowedRequests", common_1.MetricStatistic.SUM, "Allowed", this.dimensions, undefined, MetricNamespace);
    }
    metricBlockedRequests() {
        return this.metricFactory.createMetric("BlockedRequests", common_1.MetricStatistic.SUM, "Blocked", this.dimensions, undefined, MetricNamespace);
    }
    metricBlockedRequestsRate() {
        return this.metricFactory.createMetricMath("100 * (blocked / (allowed + blocked))", {
            allowed: this.metricAllowedRequests(),
            blocked: this.metricBlockedRequests(),
        }, "Blocked (rate)");
    }
}
exports.WafV2MetricFactory = WafV2MetricFactory;
_a = JSII_RTTI_SYMBOL_1;
WafV2MetricFactory[_a] = { fqn: "cdk-monitoring-constructs.WafV2MetricFactory", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,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