"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafV2Monitoring = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudwatch_1 = require("aws-cdk-lib/aws-cloudwatch");
const common_1 = require("../../common");
const dashboard_1 = require("../../dashboard");
const WafV2MetricFactory_1 = require("./WafV2MetricFactory");
/**
 * Monitoring for AWS Web Application Firewall.
 *
 * @see https://docs.aws.amazon.com/waf/latest/developerguide/monitoring-cloudwatch.html
 */
class WafV2Monitoring extends common_1.Monitoring {
    constructor(scope, props) {
        super(scope, props);
        const namingStrategy = new dashboard_1.MonitoringNamingStrategy({
            ...props,
            namedConstruct: props.acl,
        });
        this.humanReadableName = namingStrategy.resolveHumanReadableName();
        const metricFactory = new WafV2MetricFactory_1.WafV2MetricFactory(scope.createMetricFactory(), props);
        this.allowedRequestsMetric = metricFactory.metricAllowedRequests();
        this.blockedRequestsMetric = metricFactory.metricBlockedRequests();
        this.blockedRequestsRateMetric = metricFactory.metricBlockedRequestsRate();
    }
    summaryWidgets() {
        return [
            this.createTitleWidget(),
            this.createAllowedRequestsWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createBlockedRequestsWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
            this.createBlockedRequestsRateWidget(common_1.ThirdWidth, common_1.DefaultSummaryWidgetHeight),
        ];
    }
    widgets() {
        return [
            this.createTitleWidget(),
            this.createAllowedRequestsWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createBlockedRequestsWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
            this.createBlockedRequestsRateWidget(common_1.ThirdWidth, common_1.DefaultGraphWidgetHeight),
        ];
    }
    createTitleWidget() {
        return new dashboard_1.MonitoringHeaderWidget({
            family: "Web Application Firewall",
            title: this.humanReadableName,
        });
    }
    createAllowedRequestsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Allowed Requests",
            left: [this.allowedRequestsMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createBlockedRequestsWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Blocked Requests",
            left: [this.blockedRequestsMetric],
            leftYAxis: common_1.CountAxisFromZero,
        });
    }
    createBlockedRequestsRateWidget(width, height) {
        return new aws_cloudwatch_1.GraphWidget({
            width,
            height,
            title: "Blocked Requests (rate)",
            left: [this.blockedRequestsRateMetric],
            leftYAxis: common_1.RateAxisFromZero,
        });
    }
}
exports.WafV2Monitoring = WafV2Monitoring;
_a = JSII_RTTI_SYMBOL_1;
WafV2Monitoring[_a] = { fqn: "cdk-monitoring-constructs.WafV2Monitoring", version: "1.27.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiV2FmVjJNb25pdG9yaW5nLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiV2FmVjJNb25pdG9yaW5nLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsK0RBQWtFO0FBQ2xFLHlDQVVzQjtBQUN0QiwrQ0FHeUI7QUFDekIsNkRBRzhCO0FBUTlCOzs7O0dBSUc7QUFDSCxNQUFhLGVBQWdCLFNBQVEsbUJBQVU7SUFPN0MsWUFBWSxLQUFzQixFQUFFLEtBQTJCO1FBQzdELEtBQUssQ0FBQyxLQUFLLEVBQUUsS0FBSyxDQUFDLENBQUM7UUFFcEIsTUFBTSxjQUFjLEdBQUcsSUFBSSxvQ0FBd0IsQ0FBQztZQUNsRCxHQUFHLEtBQUs7WUFDUixjQUFjLEVBQUUsS0FBSyxDQUFDLEdBQUc7U0FDMUIsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLGlCQUFpQixHQUFHLGNBQWMsQ0FBQyx3QkFBd0IsRUFBRSxDQUFDO1FBRW5FLE1BQU0sYUFBYSxHQUFHLElBQUksdUNBQWtCLENBQzFDLEtBQUssQ0FBQyxtQkFBbUIsRUFBRSxFQUMzQixLQUFLLENBQ04sQ0FBQztRQUVGLElBQUksQ0FBQyxxQkFBcUIsR0FBRyxhQUFhLENBQUMscUJBQXFCLEVBQUUsQ0FBQztRQUNuRSxJQUFJLENBQUMscUJBQXFCLEdBQUcsYUFBYSxDQUFDLHFCQUFxQixFQUFFLENBQUM7UUFDbkUsSUFBSSxDQUFDLHlCQUF5QixHQUFHLGFBQWEsQ0FBQyx5QkFBeUIsRUFBRSxDQUFDO0lBQzdFLENBQUM7SUFFRCxjQUFjO1FBQ1osT0FBTztZQUNMLElBQUksQ0FBQyxpQkFBaUIsRUFBRTtZQUN4QixJQUFJLENBQUMsMkJBQTJCLENBQUMsbUJBQVUsRUFBRSxtQ0FBMEIsQ0FBQztZQUN4RSxJQUFJLENBQUMsMkJBQTJCLENBQUMsbUJBQVUsRUFBRSxtQ0FBMEIsQ0FBQztZQUN4RSxJQUFJLENBQUMsK0JBQStCLENBQ2xDLG1CQUFVLEVBQ1YsbUNBQTBCLENBQzNCO1NBQ0YsQ0FBQztJQUNKLENBQUM7SUFFRCxPQUFPO1FBQ0wsT0FBTztZQUNMLElBQUksQ0FBQyxpQkFBaUIsRUFBRTtZQUN4QixJQUFJLENBQUMsMkJBQTJCLENBQUMsbUJBQVUsRUFBRSxpQ0FBd0IsQ0FBQztZQUN0RSxJQUFJLENBQUMsMkJBQTJCLENBQUMsbUJBQVUsRUFBRSxpQ0FBd0IsQ0FBQztZQUN0RSxJQUFJLENBQUMsK0JBQStCLENBQ2xDLG1CQUFVLEVBQ1YsaUNBQXdCLENBQ3pCO1NBQ0YsQ0FBQztJQUNKLENBQUM7SUFFRCxpQkFBaUI7UUFDZixPQUFPLElBQUksa0NBQXNCLENBQUM7WUFDaEMsTUFBTSxFQUFFLDBCQUEwQjtZQUNsQyxLQUFLLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtTQUM5QixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsMkJBQTJCLENBQUMsS0FBYSxFQUFFLE1BQWM7UUFDdkQsT0FBTyxJQUFJLDRCQUFXLENBQUM7WUFDckIsS0FBSztZQUNMLE1BQU07WUFDTixLQUFLLEVBQUUsa0JBQWtCO1lBQ3pCLElBQUksRUFBRSxDQUFDLElBQUksQ0FBQyxxQkFBcUIsQ0FBQztZQUNsQyxTQUFTLEVBQUUsMEJBQWlCO1NBQzdCLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFRCwyQkFBMkIsQ0FBQyxLQUFhLEVBQUUsTUFBYztRQUN2RCxPQUFPLElBQUksNEJBQVcsQ0FBQztZQUNyQixLQUFLO1lBQ0wsTUFBTTtZQUNOLEtBQUssRUFBRSxrQkFBa0I7WUFDekIsSUFBSSxFQUFFLENBQUMsSUFBSSxDQUFDLHFCQUFxQixDQUFDO1lBQ2xDLFNBQVMsRUFBRSwwQkFBaUI7U0FDN0IsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVELCtCQUErQixDQUFDLEtBQWEsRUFBRSxNQUFjO1FBQzNELE9BQU8sSUFBSSw0QkFBVyxDQUFDO1lBQ3JCLEtBQUs7WUFDTCxNQUFNO1lBQ04sS0FBSyxFQUFFLHlCQUF5QjtZQUNoQyxJQUFJLEVBQUUsQ0FBQyxJQUFJLENBQUMseUJBQXlCLENBQUM7WUFDdEMsU0FBUyxFQUFFLHlCQUFnQjtTQUM1QixDQUFDLENBQUM7SUFDTCxDQUFDOztBQXJGSCwwQ0FzRkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBHcmFwaFdpZGdldCwgSVdpZGdldCB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtY2xvdWR3YXRjaFwiO1xuaW1wb3J0IHtcbiAgQmFzZU1vbml0b3JpbmdQcm9wcyxcbiAgQ291bnRBeGlzRnJvbVplcm8sXG4gIERlZmF1bHRHcmFwaFdpZGdldEhlaWdodCxcbiAgRGVmYXVsdFN1bW1hcnlXaWRnZXRIZWlnaHQsXG4gIE1ldHJpY1dpdGhBbGFybVN1cHBvcnQsXG4gIE1vbml0b3JpbmcsXG4gIE1vbml0b3JpbmdTY29wZSxcbiAgUmF0ZUF4aXNGcm9tWmVybyxcbiAgVGhpcmRXaWR0aCxcbn0gZnJvbSBcIi4uLy4uL2NvbW1vblwiO1xuaW1wb3J0IHtcbiAgTW9uaXRvcmluZ0hlYWRlcldpZGdldCxcbiAgTW9uaXRvcmluZ05hbWluZ1N0cmF0ZWd5LFxufSBmcm9tIFwiLi4vLi4vZGFzaGJvYXJkXCI7XG5pbXBvcnQge1xuICBXYWZWMk1ldHJpY0ZhY3RvcnksXG4gIFdhZlYyTWV0cmljRmFjdG9yeVByb3BzLFxufSBmcm9tIFwiLi9XYWZWMk1ldHJpY0ZhY3RvcnlcIjtcblxuZXhwb3J0IGludGVyZmFjZSBXYWZWMk1vbml0b3JpbmdPcHRpb25zIGV4dGVuZHMgQmFzZU1vbml0b3JpbmdQcm9wcyB7fVxuXG5leHBvcnQgaW50ZXJmYWNlIFdhZlYyTW9uaXRvcmluZ1Byb3BzXG4gIGV4dGVuZHMgV2FmVjJNZXRyaWNGYWN0b3J5UHJvcHMsXG4gICAgV2FmVjJNb25pdG9yaW5nT3B0aW9ucyB7fVxuXG4vKipcbiAqIE1vbml0b3JpbmcgZm9yIEFXUyBXZWIgQXBwbGljYXRpb24gRmlyZXdhbGwuXG4gKlxuICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vd2FmL2xhdGVzdC9kZXZlbG9wZXJndWlkZS9tb25pdG9yaW5nLWNsb3Vkd2F0Y2guaHRtbFxuICovXG5leHBvcnQgY2xhc3MgV2FmVjJNb25pdG9yaW5nIGV4dGVuZHMgTW9uaXRvcmluZyB7XG4gIHJlYWRvbmx5IGh1bWFuUmVhZGFibGVOYW1lOiBzdHJpbmc7XG5cbiAgcmVhZG9ubHkgYWxsb3dlZFJlcXVlc3RzTWV0cmljOiBNZXRyaWNXaXRoQWxhcm1TdXBwb3J0O1xuICByZWFkb25seSBibG9ja2VkUmVxdWVzdHNNZXRyaWM6IE1ldHJpY1dpdGhBbGFybVN1cHBvcnQ7XG4gIHJlYWRvbmx5IGJsb2NrZWRSZXF1ZXN0c1JhdGVNZXRyaWM6IE1ldHJpY1dpdGhBbGFybVN1cHBvcnQ7XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IE1vbml0b3JpbmdTY29wZSwgcHJvcHM6IFdhZlYyTW9uaXRvcmluZ1Byb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIHByb3BzKTtcblxuICAgIGNvbnN0IG5hbWluZ1N0cmF0ZWd5ID0gbmV3IE1vbml0b3JpbmdOYW1pbmdTdHJhdGVneSh7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIG5hbWVkQ29uc3RydWN0OiBwcm9wcy5hY2wsXG4gICAgfSk7XG4gICAgdGhpcy5odW1hblJlYWRhYmxlTmFtZSA9IG5hbWluZ1N0cmF0ZWd5LnJlc29sdmVIdW1hblJlYWRhYmxlTmFtZSgpO1xuXG4gICAgY29uc3QgbWV0cmljRmFjdG9yeSA9IG5ldyBXYWZWMk1ldHJpY0ZhY3RvcnkoXG4gICAgICBzY29wZS5jcmVhdGVNZXRyaWNGYWN0b3J5KCksXG4gICAgICBwcm9wc1xuICAgICk7XG5cbiAgICB0aGlzLmFsbG93ZWRSZXF1ZXN0c01ldHJpYyA9IG1ldHJpY0ZhY3RvcnkubWV0cmljQWxsb3dlZFJlcXVlc3RzKCk7XG4gICAgdGhpcy5ibG9ja2VkUmVxdWVzdHNNZXRyaWMgPSBtZXRyaWNGYWN0b3J5Lm1ldHJpY0Jsb2NrZWRSZXF1ZXN0cygpO1xuICAgIHRoaXMuYmxvY2tlZFJlcXVlc3RzUmF0ZU1ldHJpYyA9IG1ldHJpY0ZhY3RvcnkubWV0cmljQmxvY2tlZFJlcXVlc3RzUmF0ZSgpO1xuICB9XG5cbiAgc3VtbWFyeVdpZGdldHMoKTogSVdpZGdldFtdIHtcbiAgICByZXR1cm4gW1xuICAgICAgdGhpcy5jcmVhdGVUaXRsZVdpZGdldCgpLFxuICAgICAgdGhpcy5jcmVhdGVBbGxvd2VkUmVxdWVzdHNXaWRnZXQoVGhpcmRXaWR0aCwgRGVmYXVsdFN1bW1hcnlXaWRnZXRIZWlnaHQpLFxuICAgICAgdGhpcy5jcmVhdGVCbG9ja2VkUmVxdWVzdHNXaWRnZXQoVGhpcmRXaWR0aCwgRGVmYXVsdFN1bW1hcnlXaWRnZXRIZWlnaHQpLFxuICAgICAgdGhpcy5jcmVhdGVCbG9ja2VkUmVxdWVzdHNSYXRlV2lkZ2V0KFxuICAgICAgICBUaGlyZFdpZHRoLFxuICAgICAgICBEZWZhdWx0U3VtbWFyeVdpZGdldEhlaWdodFxuICAgICAgKSxcbiAgICBdO1xuICB9XG5cbiAgd2lkZ2V0cygpOiBJV2lkZ2V0W10ge1xuICAgIHJldHVybiBbXG4gICAgICB0aGlzLmNyZWF0ZVRpdGxlV2lkZ2V0KCksXG4gICAgICB0aGlzLmNyZWF0ZUFsbG93ZWRSZXF1ZXN0c1dpZGdldChUaGlyZFdpZHRoLCBEZWZhdWx0R3JhcGhXaWRnZXRIZWlnaHQpLFxuICAgICAgdGhpcy5jcmVhdGVCbG9ja2VkUmVxdWVzdHNXaWRnZXQoVGhpcmRXaWR0aCwgRGVmYXVsdEdyYXBoV2lkZ2V0SGVpZ2h0KSxcbiAgICAgIHRoaXMuY3JlYXRlQmxvY2tlZFJlcXVlc3RzUmF0ZVdpZGdldChcbiAgICAgICAgVGhpcmRXaWR0aCxcbiAgICAgICAgRGVmYXVsdEdyYXBoV2lkZ2V0SGVpZ2h0XG4gICAgICApLFxuICAgIF07XG4gIH1cblxuICBjcmVhdGVUaXRsZVdpZGdldCgpIHtcbiAgICByZXR1cm4gbmV3IE1vbml0b3JpbmdIZWFkZXJXaWRnZXQoe1xuICAgICAgZmFtaWx5OiBcIldlYiBBcHBsaWNhdGlvbiBGaXJld2FsbFwiLFxuICAgICAgdGl0bGU6IHRoaXMuaHVtYW5SZWFkYWJsZU5hbWUsXG4gICAgfSk7XG4gIH1cblxuICBjcmVhdGVBbGxvd2VkUmVxdWVzdHNXaWRnZXQod2lkdGg6IG51bWJlciwgaGVpZ2h0OiBudW1iZXIpIHtcbiAgICByZXR1cm4gbmV3IEdyYXBoV2lkZ2V0KHtcbiAgICAgIHdpZHRoLFxuICAgICAgaGVpZ2h0LFxuICAgICAgdGl0bGU6IFwiQWxsb3dlZCBSZXF1ZXN0c1wiLFxuICAgICAgbGVmdDogW3RoaXMuYWxsb3dlZFJlcXVlc3RzTWV0cmljXSxcbiAgICAgIGxlZnRZQXhpczogQ291bnRBeGlzRnJvbVplcm8sXG4gICAgfSk7XG4gIH1cblxuICBjcmVhdGVCbG9ja2VkUmVxdWVzdHNXaWRnZXQod2lkdGg6IG51bWJlciwgaGVpZ2h0OiBudW1iZXIpIHtcbiAgICByZXR1cm4gbmV3IEdyYXBoV2lkZ2V0KHtcbiAgICAgIHdpZHRoLFxuICAgICAgaGVpZ2h0LFxuICAgICAgdGl0bGU6IFwiQmxvY2tlZCBSZXF1ZXN0c1wiLFxuICAgICAgbGVmdDogW3RoaXMuYmxvY2tlZFJlcXVlc3RzTWV0cmljXSxcbiAgICAgIGxlZnRZQXhpczogQ291bnRBeGlzRnJvbVplcm8sXG4gICAgfSk7XG4gIH1cblxuICBjcmVhdGVCbG9ja2VkUmVxdWVzdHNSYXRlV2lkZ2V0KHdpZHRoOiBudW1iZXIsIGhlaWdodDogbnVtYmVyKSB7XG4gICAgcmV0dXJuIG5ldyBHcmFwaFdpZGdldCh7XG4gICAgICB3aWR0aCxcbiAgICAgIGhlaWdodCxcbiAgICAgIHRpdGxlOiBcIkJsb2NrZWQgUmVxdWVzdHMgKHJhdGUpXCIsXG4gICAgICBsZWZ0OiBbdGhpcy5ibG9ja2VkUmVxdWVzdHNSYXRlTWV0cmljXSxcbiAgICAgIGxlZnRZQXhpczogUmF0ZUF4aXNGcm9tWmVybyxcbiAgICB9KTtcbiAgfVxufVxuIl19