# Azure CIS Benchmarks v1.0.0
az_cis_metadata = {
        "1.1": { "category": "Identity and Access Management", "description": "Enable multi-factor authentication for all user credentials who have write access to Azure resources. These include roles like\n* Service Co-Administrators\n* Subscription Owners\n* Contributors", "rationale": "Multi-factor authentication requires an individual to present a minimum of two separate forms of authentication before access is granted. Multi-factor authentication provides additional assurance that the individual attempting to gain access is who they claim to be.  With multi-factor authentication, an attacker would need to compromise at least two different authentication mechanisms, increasing the difficulty of compromise and thus reducing the risk.", "remediation": "Follow Microsoft Azure documentation and setup multi-factor authentication in your environment.", "recommendation": "Ensure that multi-factor authentication is enabled for all privileged users"},
        "1.2": { "category": "Identity and Access Management", "description": "Enable multi-factor authentication for all non-privileged users.", "rationale": "Multi-factor authentication requires an individual to present a minimum of two separate forms of authentication before access is granted. Multi-factor authentication provides additional assurance that the individual attempting to gain access is who they claim to be.  With multi-factor authentication, an attacker would need to compromise at least two different authentication mechanisms, increasing the difficulty of compromise and thus reducing the risk.", "remediation": "Follow Microsoft Azure documentation and setup multi-factor authentication in your environment.", "recommendation": "Enable multi-factor authentication for all non-privileged users."},
        "1.3": { "category": "Identity and Access Management", "description": "Do not add guest users if not needed.", "rationale": "Azure AD is extended to include Azure AD B2B collaboration, allowing you to invite people from outside your organization to be guest users in your cloud account. Until you have a business need to provide guest access to any user, avoid creating guest users. Guest users are typically added outside your employee on-boarding/off-boarding process and could potentially be overlooked indefinitely leading to a potential vulnerability.", "remediation": "Delete the 'Guest' users.", "recommendation": "Ensure that there are no guest users. Do not add guest users if not needed."},
        "1.4": { "category": "Identity and Access Management", "description": "Do not allow users to remember multi-factor authentication on devices.", "rationale": "Remembering Multi-Factor Authentication (MFA) for devices and browsers allows users to have the option to by-pass MFA for a set number of days after performing a successful sign- in using MFA. This can enhance usability by minimizing the number of times a user may need to perform two-step verification on the same device. However, if an account or device is compromised, remembering MFA for trusted devices may affect security. Hence, it is recommended that users not be allowed to bypass MFA.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to All Users\n 4. Click on Multi-Factor 5. Click on service settings\n Authentication button on the top bar\n 6. Disable Allow users to remember multi-factor authentication on devices they trust", "recommendation": "Do not allow users to remember multi-factor authentication on devices."},
        "1.5": { "category": "Identity and Access Management", "description": "Ensure that two alternate forms of identification are provided before allowing a password reset.", "rationale": "Like multi-factor authentication, setting up dual identification before allowing a password reset ensures that the user identity is confirmed via two separate forms of identification.  With dual identification set, an attacker would require compromising both the identity forms before he/she could maliciously reset a user's password.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Password reset\n 4. Go to Authentication methods\n 5. Set the Number of methods required to reset to 2", "recommendation": "Ensure that two alternate forms of identification are provided before allowing a password reset."},
        "1.6": { "category": "Identity and Access Management", "description": "Ensure that the number of days before users are asked to re-confirm their authentication information is not set to 0.", "rationale": "If authentication re-confirmation is disabled, registered users will never be prompted to re- confirm their existing authentication information. If the authentication information for a user, such as a phone number or email changes, then the password reset information for that user reverts to the previously registered authentication information.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Password reset\n 4. Go to Registration\n 5. Set the Number of days before users are asked to re-confirm their authentication information to your organization defined frequency", "recommendation": "Ensure that the number of days before users are asked to re-confirm their authentication information is not set to 0."},
        "1.7": { "category": "Identity and Access Management", "description": "Ensure that users are notified on their primary and secondary emails on password resets.", "rationale": "User notification on password reset is a passive way of confirming password reset activity.  It helps the user to recognize unauthorized password reset activities.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Password reset\n 4. Go to Notification\n 5. Set Notify users on password resets? to Yes", "recommendation": "Ensure that users are notified on their primary and secondary emails on password resets."},
        "1.8": { "category": "Identity and Access Management", "description": "Ensure that all administrators are notified if any other administrator resets their password.", "rationale": "Administrator accounts are sensitive. Any password reset activity notification, when sent to all administrators, ensures that all administrators can passively confirm if such a reset is a common pattern within their group. For example, if all administrators change their password every 30 days, any password reset activity before that may require administrator(s) to evaluate any unusual activity and confirm its origin.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Password reset\n 4. Go to Notification\n 5. Set Notify all admins when other admins reset their password? to Yes", "recommendation": "Ensure that all administrators are notified if any other administrator resets their password."},
        "1.9": { "category": "Identity and Access Management", "description": "Require administrators to provide consent for the apps before use.", "rationale": "Unless Azure Active Directory is running as an identity provider for third-party applications, do not allow users to use their identity outside of the cloud environment. User profiles contain private information such as phone numbers and email addresses which could then be sold off to other third parties without requiring any further consent from the user.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to User settings\n 4. Set Users can consent to apps accessing company data on their behalf to No", "recommendation": "Require administrators to provide consent for the apps before use."},
        "1.10": { "category": "Identity and Access Management", "description": "Require administrators to provide consent for the apps before use.", "rationale": "Unless Azure Active Directory is running as an identity provider for third-party applications, do not allow users to use their identity outside of your cloud environment. User profiles contain private information such as phone numbers and email addresses which could then be sold off to other third parties without requiring any further consent from the user.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to User settings\n 4. Set Users can add gallery apps to their Access Panel to No", "recommendation": "Require administrators to provide consent for the apps before use."},
        "1.11": { "category": "Identity and Access Management", "description": "Require administrators to register third-party applications.", "rationale": "It is recommended to let administrator register custom-developed applications. This ensures that the application undergoes a security review before exposing active directory data to it.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to User settings\n 4. Set Users can register applications to No", "recommendation": "Require administrators to register third-party applications."},
        "1.12": { "category": "Identity and Access Management", "description": "Limit guest user permissions.", "rationale": "Limiting guest access ensures that guest accounts do not have permission for certain directory tasks, such as enumerating users, groups or other directory resources, and cannot be assigned to administrative roles in your directory.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to User settings\n 4. Set Guest users permissions are limited to Yes", "recommendation": "Limit guest user permissions."},
        "1.13": { "category": "Identity and Access Management", "description": "Restrict invitations through administrators only.", "rationale": "Restricting invitations to administrators ensures that only authorized accounts have access to cloud resources. This helps to maintain 'Need to Know' permissions and prevents inadvertent access to data.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to User settings\n 4. Set Members can invite to No", "recommendation": "Restrict invitations through administrators only."},
        "1.14": { "category": "Identity and Access Management", "description": "Restrict guest invitations.", "rationale": "Restricting invitations to administrators ensures that only authorized accounts have access to cloud resources. This helps to maintain 'Need to Know' permissions and prevents inadvertent access to data.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to User settings\n 4. Set Guests can invite to No", "recommendation": "Restrict guest invitations."},
        "1.15": { "category": "Identity and Access Management", "description": "Restrict access to the Azure AD administration portal to administrators only.", "rationale": "The Azure AD administrative portal has sensitive data. All non-administrators should be prohibited from accessing any Azure AD data in the administration portal to avoid exposure.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to User settings\n 4. Set Restrict access to Azure AD administration portal to Yes", "recommendation": "Restrict access to the Azure AD administration portal to administrators only."},
        "1.16": { "category": "Identity and Access Management", "description": "Restrict group creation to administrators only.", "rationale": "Self-service group management enables users to create and manage security groups or Office 365 groups in Azure Active Directory (Azure AD). Unless a business requires this day-to-day delegation for some users, self-service group management should be disabled.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Group settings\n 4. Set Self-service group management enabled to No", "recommendation": "Restrict group creation to administrators only."},
        "1.17": { "category": "Identity and Access Management", "description": "Restrict security group creation to administrators only.", "rationale": "When creating security groups is enabled, all users in the directory are allowed to create new security groups and add members to those groups. Unless a business requires this day-to-day delegation, security group creation should be restricted to administrators only.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Group settings\n 4. Set Users can create security groups to No", "recommendation": "Restrict security group creation to administrators only."},
        "1.18": { "category": "Identity and Access Management", "description": "Restrict security group management to administrators only.", "rationale": "Restricting security group management to administrators only prohibits users from making changes to security groups. This ensures that security groups are appropriately managed and their management is not delegated to non-administrators.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Group settings\n 4. Set Users who can manage security groups to None", "recommendation": "Restrict security group management to administrators only."},
        "1.19": { "category": "Identity and Access Management", "description": "Restrict Office 365 group creation to administrators only.", "rationale": "Restricting Office 365 group creation to administrators only ensures that creation of Office 365 groups is controlled by the administrator. Appropriate groups should be created and managed by the administrator and group creation rights should not be delegated to any other user.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Group settings\n 4. Set Users can create Office 365 groups to No", "recommendation": "Restrict Office 365 group creation to administrators only."},
        "1.20": { "category": "Identity and Access Management", "description": "Restrict Office 365 group management to administrators only.", "rationale": "Restricting Office 365 group management to administrators prohibits users from making changes to Office 365 groups. This ensures that Office 365 groups are appropriately managed and their management is not delegated to any other user.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Group settings\n 4. Set Users who can manage Office 365 groups to None", "recommendation": "Restrict Office 365 group management to administrators only."},
        "1.21": { "category": "Identity and Access Management", "description": "Enable All Users group for centralized administration of all users.", "rationale": "The All Users group can be used to assign the same permissions to all the users in the directory. For example, all users in a directory can be given access to a SaaS application by assigning access for the All Users dedicated group to this application. This ensures that there is a common policy created for all users and there is no need to restrict individual permissions.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Group settings\n 4. Set Enable 'All Users' group to Yes", "recommendation": "Enable All Users group for centralized administration of all users."},
        "1.22": { "category": "Identity and Access Management", "description": "Joining devices to the active directory should require Multi-factor authentication.", "rationale": "Multi-factor authentication is recommended when adding devices to Azure AD. When set to 'Yes', users who are adding devices from the internet must first use the second method of authentication before their device is successfully added to the directory. This ensures that rogue devices are not added to the directory for a compromised user account.", "remediation": "Azure Console\n 1. Go to Azure Active Directory\n 2. Go to Users and group\n 3. Go to Device settings\n 4. Set Require Multi-Factor Auth to join devices to Yes", "recommendation": "Joining devices to the active directory should require Multi-factor authentication."},
        "1.23": { "category": "Identity and Access Management", "description": "Do not create custom roles with subscription ownership. It is recommended to use the principle of least privilege, assigning only needed privileges instead of allowing full administrative access.", "rationale": "Classic subscription admin roles offer basic access management and include Account Administrator, Service Administrator, and Co-Administrators. It is recommended the least necessary permissions be given initially. Permissions can be added as needed by the account holder. This ensures the account holder cannot perform actions which were not intended.", "remediation": "", "recommendation": "Ensure that no custom subscription owner roles are created"},
        "2.1": { "category": "Security Center", "description": "The standard pricing tier enables threat detection for networks and virtual machines, providing threat intelligence, anomaly detection, and behavior analytics in the Azure Security Center.", "rationale": "Enabling the Standard pricing tier allows for greater defense-in-depth, with threat detection provided by the Microsoft Security Response Center (MSRC).", "remediation": "Azure Console\n 1. Go to Azure Security Center\n 2. Select Security policy blade\n 3. Click On Edit Settings to alter the the security policy for a subscription\n 4. Select the Pricing tier blade\n 5. Select Standard\n 6. Select Save", "recommendation": "Enable Standard pricing tier"},
        "2.2": { "category": "Security Center", "description": "Enable automatic provisioning of the monitoring agent to collect security data.", "rationale": "When Automatic provisioning of monitoring agent is turned on, Azure Security Center provisions the Microsoft Monitoring Agent on all existing supported Azure virtual machines and any new ones that are created. The Microsoft Monitoring Agent scans for various security-related configurations and events such as system updates, OS vulnerabilities, endpoint protection, and provides alerts.", "remediation": "Azure Console\n 1. Go to Security Center\n 2. Click on Security Policy\n 3. Click On 'Edit Settings' for each subscription\n 4. Click on Data Collection\n 5. Set Automatic provisioning of monitoring agent to On\n 6. Click Save", "recommendation": "Enable automatic provisioning of the monitoring agent to collect security data."},
        "2.3": { "category": "Security Center", "description": "Enable system updates recommendations for virtual machines.", "rationale": "When this setting is enabled, it retrieves a daily list of available security and critical updates from Windows Update or Windows Server Update Services. The retrieved list depends on the service that's configured for that virtual machine and recommends that the missing updates be applied. For Linux systems, the policy uses the distro-provided package management system to determine packages that have available updates. It also checks for security and critical updates from Azure Cloud Services virtual machines.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC Default (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor system updates to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable system updates recommendations for virtual machines."},
        "2.4": { "category": "Security Center", "description": "Enable OS vulnerabilities recommendations for virtual machines.", "rationale": "When this setting is enabled, it analyzes operating system configurations daily to determine issues that could make the virtual machine vulnerable to attack. The policy also recommends configuration changes to address these vulnerabilities.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor os Vulnerabilities to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable OS vulnerabilities recommendations for virtual machines."},
        "2.5": { "category": "Security Center", "description": "Enable Endpoint protection recommendations for virtual machines.", "rationale": "When this setting is enabled, it recommends endpoint protection be provisioned for all Windows virtual machines to help identify and remove viruses, spyware, and other malicious software.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor Endpoint Protection to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable Endpoint protection recommendations for virtual machines."},
        "2.6": { "category": "Security Center", "description": "Enable Disk encryption recommendations for virtual machines.", "rationale": "When this setting is enabled, it recommends enabling disk encryption in all virtual machines (Windows and Linux as well) to enhance data protection at rest.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor Disk Encryption to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable Disk encryption recommendations for virtual machines."},
        "2.7": { "category": "Security Center", "description": "Enable Network security group recommendations for virtual machines.", "rationale": "When this setting is enabled, it recommends that network security groups be configured to control inbound and outbound traffic to VMs that have public endpoints. Network security groups that are configured for a subnet are inherited by all virtual machine network interfaces unless otherwise specified. In addition to checking that a network security group has been configured, this policy assesses inbound security rules to identify rules that allow incoming traffic.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor Network Security Groups to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable Network security group recommendations for virtual machines."},
        "2.8": { "category": "Security Center", "description": "Enable Web application firewall recommendations for virtual machines.", "rationale": "When this setting is enabled, it recommends that a web application firewall is provisioned on virtual machines when either of the following is true:\n * Instance-level public IP (ILPIP) is used and the inbound security rules for the associated network security group are configured to allow access to port 80/443.\n *  Load-balanced IP is used and the associated load balancing and inbound network address translation (NAT) rules are configured to allow access to port 80/443.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor Web Application Firewall to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable Web application firewall recommendations for virtual machines."},
        "2.9": { "category": "Security Center", "description": "Enable next generation firewall recommendations for virtual machines.", "rationale": "When this setting is enabled, it extends network protections beyond network security groups, which are built into Azure. Security Center will search for deployments where a next generation firewall is recommended and enable a virtual appliance to be provisioned.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Enable Next Generation Firewall(NGFW) Monitoring to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable next generation firewall recommendations for virtual machines."},
        "2.10": { "category": "Security Center", "description": "Enable vulnerability assessment recommendations for virtual machines.", "rationale": "When this setting is enabled, it recommends a vulnerability assessment solution be installed on the VM.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID) Default\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor Vulnerability Assessment to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable vulnerability assessment recommendations for virtual machines."},
        "2.11": { "category": "Security Center", "description": "Enable storage encryption recommendations.", "rationale": "When this setting is enabled, any new data in Azure Blobs and Files will be encrypted.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor Storage Blob Encryption to Audit or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable storage encryption recommendations."},
        "2.12": { "category": "Security Center", "description": "Enable JIT Network Access for virtual machines.", "rationale": "When this setting is enabled, Security Center locks down inbound traffic to the Azure VMs by creating an NSG rule. The user can select the ports on the VM where inbound traffic should be locked down. Just in time virtual machine (VM) access can be used to lock down inbound traffic to the Azure VMs, reducing exposure to attacks while providing easy access to connect to VMs when needed.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor JIT Network Access to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable JIT Network Access for virtual machines."},
        "2.13": { "category": "Security Center", "description": "Enable adaptive application controls.", "rationale": "Adaptive application controls help control which applications can run on VMs located in Azure, which among other benefits helps harden those VMs against malware. The Security Center uses machine learning to analyze the processes running in the VM and helps to apply white-listing rules using this intelligence.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor Application Whitelisting to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable adaptive application controls."},
        "2.14": { "category": "Security Center", "description": "Enable SQL auditing & Threat detection recommendations.", "rationale": "When this setting is enabled, it recommends that access auditing for the Azure Database be enabled for compliance, advanced threat detection, and for investigation purposes.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC Default (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor SQL Auditing to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable SQL auditing & Threat detection recommendations."},
        "2.15": { "category": "Security Center", "description": "Enable SQL encryption recommendations.", "rationale": "When this setting is enabled, it recommends that encryption at rest be enabled for the Azure SQL Database, associated backups, and transaction log files. In the event of a data breach, it will not be readable.", "remediation": "Azure Console\n 1. Navigate to Azure Policy\n 2. On Policy 'Overview' blade, Click on Policy ASC Default (Subscription:Subscription_ID)\n 3. On 'ASC Default' blade, Click on Edit Assignments\n 4. In section PARAMETERS, Set Monitor SQL Encryption to AuditIfNotExists or any other available value than Disabled\n 5. Click Save", "recommendation": "Enable SQL encryption recommendations."},
        "2.16": { "category": "Security Center", "description": "Provide a security contact email address.", "rationale": "Microsoft reaches out to the designated security contact in case its security team finds that the organization's resources are compromised. This ensures that the proper people are aware of any potential compromise in order to mitigate the risk in a timely fashion.", "remediation": "Azure Console\n 1. Go to Security Center\n 2. Click on Security Policy\n 3. Click On Edit Settings for the security policy subscription\n 4. Click on Email notifications\n 5. Set a valid email address for the security contact\n 6. Click Save", "recommendation": "Provide a security contact email address."},
        "2.17": { "category": "Security Center", "description": "Provide a security contact phone number.", "rationale": "Microsoft reaches out to the designated security contact in case its security team finds that the organization's resources are compromised. This ensures that the proper people are aware of any potential compromise in order to mitigate the risk in a timely fashion.\n Before taking any action, make sure that the information provided is valid, as the communication is not digitally signed.", "remediation": "Azure Console\n 1. Go to Security Center\n 2. Click on Security Policy\n 3. Click On Edit Settings for the security policy subscription\n 4. Click on Email notifications\n 5. Set a valid security contact Phone number\n 6. Click Save", "recommendation": "Provide a security contact phone number."},
        "2.18": { "category": "Security Center", "description": "Enable emailing security alerts to the security contact.", "rationale": "Enabling security alert emails ensures that security alert emails are received from Microsoft. This ensures that the right people are aware of any potential security issues and are able to mitigate the risk.", "remediation": "Azure Console\n 1. Go to Security Center\n 2. Click on Security Policy\n 3. Click On Edit Settings for the security policy subscription\n 4. Click on Email notifications\n 5. Set Send email notification for high severity alerts to On\n 6. Click Save", "recommendation": "Enable emailing security alerts to the security contact."},
        "2.19": { "category": "Security Center", "description": "Enable security alert emails to subscription owners.", "rationale": "Enabling security alert emails to subscription owners ensures that they receive security alert emails from Microsoft. This ensures that they are aware of any potential security issues and can mitigate the risk in a timely fashion.", "remediation": "Azure Console\n 1. Go to Security Center\n 2. Click on Security Policy\n 3. Click On Edit Settings for the security policy subscription\n 4. Click on Email notifications\n 5. Set Send email also to subscription owners to On\n 6. Click Save", "recommendation": "Enable security alert emails to subscription owners."},
        "3.1": { "category": "Storage Accounts", "description": "Enable data encryption is transit.", "rationale": "The secure transfer option enhances the security of a storage account by only allowing requests to the storage account by a secure connection. For example, when calling REST APIs to access storage accounts, the connection must use HTTPS. Any requests using HTTP will be rejected when 'secure transfer required' is enabled. When using the Azure files service, connection without encryption will fail, including scenarios using SMB 2.1, SMB 3.0 without encryption, and some flavors of the Linux SMB client. Because Azure storage doesn’t support HTTPS for custom domain names, this option is not applied when using a custom domain name.", "remediation": "Azure Console\n 1. Go to Storage Accounts\n 2. For each storage account, go to Configuration\n 3. Set Secure transfer required to Enabled", "recommendation": "Enable data encryption is transit."},
        "3.2": { "category": "Storage Accounts", "description": "Enable data encryption at rest for blobs.", "rationale": "Storage service encryption protects your data at rest. Azure Storage encrypts your data as it's written in its datacenters, and automatically decrypts it for you as you access it.", "remediation": "Azure Console\n 1. Go to Storage Accounts\n 2. For each storage account, go to Encryption under BLOB SERVICE\n 3. Set Storage service encryption to Enabled", "recommendation":"Enable data encryption at rest for blobs."} ,
        "3.3": { "category": "Storage Accounts", "description": "Regenerate storage account access keys periodically.", "rationale": "When you create a storage account, Azure generates two 512-bit storage access keys, which are used for authentication when the storage account is accessed. Rotating these keys periodically ensures that any inadvertent access or exposure to these keys could be undermined.", "remediation": "Follow Microsoft Azure documentation for regenerating your storage account access keys.", "recommendation": "Regenerate storage account access keys periodically."},
        "3.4": { "category": "Storage Accounts", "description": "Expire shared access signature tokens within an hour.", "rationale": "A shared access signature (SAS) is a URI that grants restricted access rights to Azure Storage resources. You can provide a shared access signature to clients who should not be trusted with your storage account key but whom you wish to delegate access to certain storage account resources. By distributing a shared access signature URI to these clients, you grant them access to a resource for a specified period of time. This time should be set to as low as possible and preferably should be within an hour.", "remediation": "When generating shared access signature tokens, use start and end time such that it falls within an hour.", "recommendation": "Expire shared access signature tokens within an hour."},
        "3.5": { "category": "Storage Accounts", "description": "Shared access signature tokens should be allowed only over HTTPS protocol.", "rationale": "A shared access signature (SAS) is a URI that grants restricted access rights to Azure Storage resources. A shared access signature can be provided to clients who should not be trusted with the storage account key but for whom it may be necessary to delegate access to certain storage account resources. Providing a shared access signature URI to these clients allows them access to a resource for a specified period of time. It is recommended to allow such access requests over HTTPS protocol only.", "remediation": "Azure Console\n 1. Go to Storage Accounts\n 2. For each storage account, go to Shared access signature\n 3. Set Allowed protocols to HTTPS only", "recommendation": "Shared access signature tokens should be allowed only over HTTPS protocol."},
        "3.6": { "category": "Storage Accounts", "description": "Enable data encryption at rest for file service.", "rationale": "Storage service encryption protects your data at rest. Azure Storage encrypts your data as it's written in its datacenters, and automatically decrypts it for you as you access it.", "remediation": "Azure Console\n 1. Go to Storage Accounts\n 2. For each storage account, go to Encryption under FILE SERVICE\n 3. Set Storage service encryption to Enabled", "recommendation": "Enable data encryption at rest for file service."},
        "3.7": { "category": "Storage Accounts", "description": "Disable anonymous access to blob containers.", "rationale": "You can enable anonymous, public read access to a container and its blobs in Azure Blob storage. By doing so, you can grant read-only access to these resources without sharing your account key, and without requiring a shared access signature. It is recommended to not provide anonymous access to blob containers until and unless it is strongly desired. You should use shared access signature token for providing controlled and timed access to blob containers.", "remediation": "First, follow Microsoft documentation and created shared access signature tokens for your blob containers. Then,\n 1. Go to Storage Accounts\n 2. For each storage account, go to Containers under BLOB SERVICE\n 3. For each container, click Access policy\n 4. Set Public access level to Private (no anonymous access)", "recommendation": "Ensure default network access rule for Storage Accounts is set to deny"},
        "4.1.1": { "category": "SQL Services", "description": "Enable auditing on SQL Servers.", "rationale": "The Azure platform allows a SQL server to be created as a service. Enabling auditing at the server level ensures that all existing and newly created databases on the SQL server instance are audited. Auditing policy applied on the SQL database does not override auditing policy and settings applied on the particular SQL server where the database is hosted.\n Auditing tracks database events and writes them to an audit log in the Azure storage account. It also helps to maintain regulatory compliance, understand database activity, and gain insight into discrepancies and anomalies that could indicate business concerns or suspected security violations.", "remediation": "Azure Console\n 1. Go to SQL servers\n 2. For each server instance\n 3. Click on Auditing\n 4. Set Auditing to On", "recommendation": "Enable auditing on SQL Servers."},
        "4.1.2": { "category": "SQL Services", "description": "Enable threat detection on SQL Servers.", "rationale": "SQL Threat Detection provides a new layer of security, which enables customers to detect and respond to potential threats as they occur by providing security alerts on anomalous activities. Users will receive an alert upon suspicious database activities, potential vulnerabilities, and SQL injection attacks, as well as anomalous database access patterns.  SQL Threat Detection alerts provide details of suspicious activity and recommend action on how to investigate and mitigate the threat.", "remediation": "Azure Console\n 1. Go to SQL servers\n 2. For each server instance\n 3. Click on Auditing & Threat Detection\n 4. Set Threat Detection to On", "recommendation": "Enable threat detection on SQL Servers."},
        "4.1.3": { "category": "SQL Services", "description": "Enable all types of threat detection on SQL Servers.", "rationale": "Enabling all threat detection types, you are protected against SQL injection, database vulnerabilities and any other anomalous activities.", "remediation": "Azure Console\n 1. Go to SQL servers\n 2. For each server instance\n 3. Click on Auditing & Threat Detection\n 4. Set Threat Detection types to All", "recommendation": "Enable all types of threat detection on SQL Servers."},
        "4.1.4": { "category": "SQL Services", "description": "Provide the email address to which alerts will be sent upon detection of anomalous activities on SQL Servers.", "rationale": "Providing the email address to receive alerts ensures that any detection of anomalous activities is reported as soon as possible, making it more likely to mitigate any potential risk sooner.", "remediation": "Azure Console\n 1. Go to SQL servers\n 2. For each server instance\n 3. Click on Auditing & Threat Detection\n 4. Set Send alerts to as appropriate", "recommendation": "Provide the email address to which alerts will be sent upon detection of anomalous activities on SQL Servers."},
        "4.1.5": { "category": "SQL Services", "description": "Enable service and co-administrators to receive security alerts from the SQL server.", "rationale": "Providing the email address to receive alerts ensures that any detection of anomalous activities is reported as soon as possible, making it more likely to mitigate any potential risk sooner.", "remediation": "Azure Console\n 1. Go to SQL servers\n 2. For each server instance\n 3. Click on Advanced Data Security\n 4. At section Threat Detection Settings, Enable Email service and co-administrators", "recommendation": "Enable service and co-administrators to receive security alerts from the SQL server."},
        "4.1.6": { "category": "SQL Services", "description": "SQL Server Audit Retention should be configured to be greater than 90 days.", "rationale": "Audit Logs can be used to check for anomalies and give insight into suspected breaches or misuse of information and access.", "remediation": "Azure Console\n 1. Go to SQL servers\n 2. For each server instance\n 3. Click on Auditing & Threat Detection\n 4. Select Storage Details\n 5. Set Retention (days) setting greater than 90 days\n 6. Select OK\n 7. Select Save", "recommendation": "SQL Server Audit Retention should be configured to be greater than 90 days."},
        "4.1.7": { "category": "SQL Services", "description": "SQL Server Threat Detection Retention should be configured to be greater than 90 days.", "rationale": "Threat Detection Logs can be used to check for suspected attack attempts and breaches on a SQL server with known attack signatures.", "remediation": "Azure Console\n 1. Go to SQL servers\n 2. For each server instance\n 3. Click on Auditing & Threat Detection\n 4. In Threat Detection Section, Set Retention (days) setting greater than 90 days\n 5. Click OK\n 6. Click Save", "recommendation": "SQL Server Threat Detection Retention should be configured to be greater than 90 days."},
        "4.1.8": { "category": "SQL Services", "description": "Use Azure Active Directory Authentication for authentication with SQL Database.", "rationale": "Azure Active Directory authentication is a mechanism to connect to Microsoft Azure SQL Database and SQL Data Warehouse using identities in Azure Active Directory (Azure AD).  With Azure AD authentication, identities of database users and other Microsoft services can be managed in one central location. Central ID management provides a single place to manage database users and simplifies permission management.", "remediation": "Azure Console\n 1. Go to SQL servers\n 2. For each SQL server, click on Active Directory admin\n 3. Click on Set admin\n 4. Select an admin\n 5. Click Save", "recommendation": "Use Azure Active Directory Authentication for authentication with SQL Database."},
        "4.2.1": { "category": "SQL Services", "description": "Enable auditing on SQL databases.", "rationale": "Auditing tracks database events and writes them to an audit log in your Azure storage account. It also helps you to maintain regulatory compliance, understand database activity, and gain insight into discrepancies and anomalies that could indicate business concerns or suspected security violations.", "remediation": "Azure Console\n 1. Go to SQL databases\n 2. For each DB instance\n 3. Click on Auditing & Threat Detection\n 4. Set Auditing to On", "recommendation": "Enable auditing on SQL databases."},
        "4.2.2": { "category": "SQL Services", "description": "Enable threat detection on SQL databases.", "rationale": "SQL Threat Detection provides a new layer of security, which enables customers to detect and respond to potential threats as they occur by providing security alerts on anomalous activities. Users will receive an alert upon suspicious database activities, potential vulnerabilities, and SQL injection attacks, as well as anomalous database access patterns.  SQL Threat Detection alerts provide details of suspicious activity and recommend action on how to investigate and mitigate the threat.", "remediation": "Azure Console\n 1. Go to SQL databases\n 2. For each DB instance\n 3. Click on Auditing & Threat Detection\n 4. Set Threat Detection to On", "recommendation": "Enable threat detection on SQL databases."},
        "4.2.3": { "category": "SQL Services", "description": "Enable all types of threat detection on SQL databases.", "rationale": "Enabling all threat detection types, you are protected against SQL injection, database vulnerabilities and any other anomalous activities.", "remediation": "Azure Console\n 1. Go to SQL databases\n 2. For each DB instance\n 3. Click on Auditing & Threat Detection\n 4. Set Threat Detection types to All", "recommendation": "Enable all types of threat detection on SQL databases."},
        "4.2.4": { "category": "SQL Services", "description": "Provide the email address to which alerts will be sent upon detection of anomalous activities on SQL databases.", "rationale": "Providing the email address to receive alerts ensures that any detection of anomalous activities is reported as soon as possible, making it more likely to mitigate any potential risk sooner.", "remediation": "Azure Console\n 1. Go to SQL databases\n 2. For each DB instance\n 3. Click on Auditing & Threat Detection\n 4. Set Send alerts to as appropriate", "recommendation": "Provide the email address to which alerts will be sent upon detection of anomalous activities on SQL databases."},
        "4.2.5": { "category": "SQL Services", "description": "Enable service and co-administrators to receive security alerts from SQL databases.", "rationale": "Providing the email address to receive alerts ensures that any detection of anomalous activities is reported as soon as possible, making it more likely to mitigate any potential risk sooner.", "remediation": "Azure Console\n 1. Go to SQL databases\n 2. For each DB instance\n 3. Click on Advanced Data Security\n 4. At section Threat Detection Settings, Enable Email service and co-administrators", "recommendation": "Enable service and co-administrators to receive security alerts from SQL databases."},
        "4.2.6": { "category": "SQL Services", "description": "Encrypt database.", "rationale": "Azure SQL Database transparent data encryption helps protect against the threat of malicious activity by performing real-time encryption and decryption of the database, associated backups, and transaction log files at rest without requiring changes to the application.", "remediation": "Azure Console\n 1. Go to SQL databases\n 2. For each DB instance\n 3. Click on Transparent data encryption\n 4. Set Data encryption to On", "recommendation": "Encrypt database."},
        "4.2.7": { "category": "SQL Services", "description": "SQL Database Audit Retention should be configured to be greater than 90 days", "rationale": "Audit Logs can be used to check for anomalies and give insight into suspected breaches or misuse of information and access.", "remediation": "Azure Console\n 1. Go to SQL databases\n 2. For each database\n 3. Click on Auditing & Threat Detection\n 4. Select Storage Details\n 5. Set Retention (days) setting greater than 90 days\n 6. Select OK\n 7. Select Save", "recommendation": "SQL Database Audit Retention should be configured to be greater than 90 days."},
        "4.2.8": { "category": "SQL Services", "description": "SQL Database Threat Retention should be configured to be greater than 90 days.", "rationale": "Threat Logs can be used to check for anomalies and give insight into suspected breaches or misuse of information and access.", "remediation": "Azure Console\n 1. Go to SQL databases\n 2. For each database, click on Auditing & Threat Detection\n 3. Ensure that Auditing is set to ON\n 4. Click on Storage details\n 5. Configure an appropriate Storage account and Retention (Days) to 90 or above.", "recommendation": "SQL Database Threat Retention should be configured to be greater than 90 days."},
        "5.1": { "category": "Logging and Monitoring", "description": "Enable log profile for exporting activity logs.", "rationale": "A Log Profile controls how your Activity Log is exported. By default, activity logs are retained only for 90 days. It is thus recommended to define a log profile using which you could export the logs and store them for a longer duration for analyzing security activities within your Azure subscription.", "remediation":"Azure Console\n 1. Go to Activity log\n 2. Click on Export\n 3. Configure the setting\n 4. Click on Save", "recommendation": "Enable log profile for exporting activity logs."},
        "5.2": { "category": "Logging and Monitoring", "description": "Ensure activity log retention is set for 365 days or greater.", "rationale": "A log profile controls how the activity log is exported and retained. Since the average time to detect a breach is 210 days, the activity log should be retained for 365 days or more in order to have time to respond to any incidents.", "remediation":"Azure Console\n 1. Go to Activity log\n 2. Select Export\n 3. Set Retention (days) is set to 365 or greater\n 4. Select Save", "recommendation": "Ensure activity log retention is set for 365 days or greater."},
        "5.3": { "category": "Logging and Monitoring", "description": "Create an activity log alert for the Create Policy Assignment event.", "rationale": "Monitoring for Create Policy Assignment gives insight into privilege assignment and may reduce the time it takes to detect a breach or misuse of information.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Create policy assignment\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an activity log alert for the Create Policy Assignment event."},
        "5.4": { "category": "Logging and Monitoring", "description": "Create an Activity Log Alert for the 'Create' or 'Update Network Security Group' event.", "rationale": "Monitoring for 'Create' or 'Update Network Security Group' events gives insight into network access changes and may reduce the time it takes to detect suspicious activity.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Create or Update Network Security Group\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an Activity Log Alert for the 'Create' or 'Update Network Security Group' event."},
        "5.5": { "category": "Logging and Monitoring", "description": "Create an activity log alert for the Delete Network Security Group event.", "rationale": "Monitoring for 'Delete Network Security Group' events gives insight into network access changes and may reduce the time it takes to detect suspicious activity.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Delete Network Security Group\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an activity log alert for the Delete Network Security Group event."},
        "5.6": { "category": "Logging and Monitoring", "description": "Create an activity log alert for the Create or Update Network Security Group Rule event.", "rationale": "Monitoring for Create or Update Network Security Group Rule events gives insight into network access changes and may reduce the time it takes to detect suspicious activity.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Create or Update Security Rule\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an activity log alert for the Create or Update Network Security Group Rule event."},
        "5.7": { "category": "Logging and Monitoring", "description": "Create an activity log alert for the Delete Network Security Group Rule event.", "rationale": "Monitoring for Delete Network Security Group Rule events gives insight into network access changes and may reduce the time it takes to detect suspicious activity.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Delete Security Rule\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an activity log alert for the Delete Network Security Group Rule event."},
        "5.8": { "category": "Logging and Monitoring", "description": "Create an activity log alert for the Create or Update Security Solution event.", "rationale": "Monitoring for Create or Update Security Solution events gives insight into changes to the active security solutions and may reduce the time it takes to detect suspicious activity.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Create or Update Security Solutions\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an activity log alert for the Create or Update Security Solution event."},
        "5.9": { "category": "Logging and Monitoring", "description": "Create an activity log alert for the Delete Security Solution event.", "rationale": "Monitoring for Delete Security Solution events gives insight into changes to the active security solutions and may reduce the time it takes to detect suspicious activity.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Delete Security Solutions\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an activity log alert for the Delete Security Solution event."},
        "5.10": { "category": "Logging and Monitoring", "description": "Create an activity log alert for the Create or Update SQL Server Firewall Rule event.", "rationale": "Monitoring for Create or Update SQL Server Firewall Rule events gives insight into network access changes and may reduce the time it takes to detect suspicious activity.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Create/Update server firewall rule\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an activity log alert for the Create or Update SQL Server Firewall Rule event."},
        "5.11": { "category": "Logging and Monitoring", "description": "Create an Activity Log Alert for the Delete SQL Server Firewall Rule event.", "rationale": "Monitoring for Delete SQL Server Firewall Rule events gives insight into network access changes and may reduce the time it takes to detect suspicious activity.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Delete server firewall rule\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an Activity Log Alert for the Delete SQL Server Firewall Rule event."},
        "5.12": { "category": "Logging and Monitoring", "description": "Create an Activity Log Alert for the Update Security Policy event.", "rationale": "Monitoring for Update Security Policy events gives insight into changes to the Security Policy and may reduce the time it takes to detect suspicious activity.", "remediation":"Azure Console\n 1. Go to Alerts\n 2. Select Add activity log alert\n 3. Set a name, subscription, and resource group in which to store activity log alerts\n 4. Select Event category Administrative\n 5. Select Operation name Update Security Policy\n 6. Set a subscription and action group for alerts\n 7. Select Save", "recommendation": "Create an Activity Log Alert for the Update Security Policy event."},
        "5.13": { "category": "Logging and Monitoring", "description": "Enable AuditEvent logging for Key Vault instances to ensure interactions with key vaults are logged and available.", "rationale": "Monitoring how and when your key vaults are accessed, and by whom enables an audit trail of interactions with your secrets, keys and certificates managed by Azure Keyvault.  You can do this by enabling logging for Key Vault, which saves information in an Azure storage account that you provide. This creates a new container named insights-logs- auditevent automatically for your specified storage account, and you can use this same storage account for collecting logs for multiple key vaults.", "remediation":"Follow Microsoft Azure documentation and setup Azure Key Vault Logging.", "recommendation": "Enable AuditEvent logging for Key Vault instances to ensure interactions with key vaults are logged and available."},
        "6.1": { "category": "Networking", "description": "Disable RDP access on network security groups from the Internet.", "rationale": "The potential security problem with using RDP over the Internet is that attackers can use various brute force techniques to gain access to Azure Virtual Machines. Once the attackers gain access, they can use a virtual machine as a launch point for compromising other machines on an Azure Virtual Network or even attack networked devices outside of Azure.", "remediation":"Disable direct RDP access to your Azure Virtual Machines from the Internet. After direct RDP access from the Internet is disabled, you have other options you can use to access these virtual machines for remote management\n * Point-to-site VPN\n * Site-to-site VPN\n * ExpressRoute", "recommendation": "Disable RDP access on network security groups from the Internet."},
        "6.2": { "category": "Networking", "description": "Disable SSH access on network security groups from the Internet.", "rationale": "The potential security problem with using SSH over the Internet is that attackers can use various brute force techniques to gain access to Azure Virtual Machines. Once the attackers gain access, they can use a virtual machine as a launch point for compromising other machines on the Azure Virtual Network or even attack networked devices outside of Azure.", "remediation":"Disable direct SSH access to your Azure Virtual Machines from the Internet. After direct SSH access from the Internet is disabled, you have other options you can use to access these virtual machines for remote management:\n * Point-to-site VPN\n * Site-to-site VPN\n * ExpressRoute", "recommendation": "Disable SSH access on network security groups from the Internet."},
        "6.3": { "category": "Networking", "description": "Ensure that no SQL Databases allow ingress from the internet.", "rationale": "SQL Database includes a firewall to block access to unauthorized connections. After creating your SQL Database, you can specify which IP addresses can connect to your database. You can then define more granular IP addresses by referencing the range of addresses available from specific datacenters.\n Allowing ingress for the IP range 0.0.0.0/0 (StartIp of 0.0.0.0 and EndIP of 0.0.0.0) allows open access to any/all traffic potentially making the SQL Database vulnerable to attacks.", "remediation":"Azure Console\n 1. Go to SQL servers\n 2. For each SQL server\n 3. Click on Firewall / Virtual Networks\n 4. Set firewall rules to limit access to only authorized connections", "recommendation": "Ensure that no SQL Databases allow ingress from the internet)."},
        "6.4": { "category": "Networking", "description": "Network Security Group Flow Logs should be enabled and the retention period is set to greater than or equal to 90 days.", "rationale": "Flow logs enable capturing information about IP traffic flowing in and out of network security groups. Logs can be used to check for anomalies and give insight into suspected breaches.", "remediation":"Azure Console\n 1. Go to Network Watcher\n 2. Select NSG flow logs blade in the Logs section\n 3. Select each Network Security Group from the list\n 4. Ensure Status is set to On\n 5. Ensure Retention (days) setting greater than 90 days\n 6. Select your storage account in the Storage account field\n 7. Select Save", "recommendation": "Network Security Group Flow Logs should be enabled and the retention period is set to greater than or equal to 90 days."},
        "6.5": { "category": "Networking", "description": "Enable Network Watcher for Azure subscriptions.", "rationale": "Network diagnostic and visualization tools available with Network Watcher help users understand, diagnose, and gain insights to the network in Azure.", "remediation":"Azure Console\n 1. Go to Network Watcher\n 2. Right click on the subscription name and click on Enable network watcher in all regions", "recommendation": "Enable Network Watcher for Azure subscriptions."},
        "7.1": { "category": "Virtual Machines", "description": "Install VM agent on Virtual Machines.", "rationale": "The VM agent must be installed on Azure virtual machines (VMs) in order to enable Azure Security center for data collection. Security Center collects data from your virtual machines (VMs) to assess their security state, provide security recommendations, and alert you to threats.", "remediation":"Azure Console\n 1. Go to Azure Security Center\n 2. In the Recommendations blade, select Enable VM Agent\n 3. This opens the blade VM Agent Is Missing Or Not Responding\n 4. Follow instructions from Azure and install VM agent where missing", "recommendation": "Install VM agent on Virtual Machines."},
        "7.2": { "category": "Virtual Machines", "description": "Ensure that OS disks (boot volumes) are encrypted, where possible.", "rationale": "Encrypting the IaaS VM's OS disk (boot volume) ensures that its entire content is fully unrecoverable without a key and thus protects the volume from unwarranted reads.", "remediation":"Azure Console\nFollow Microsoft Azure documentation.", "recommendation": "Ensure that OS disks (boot volumes) are encrypted, where possible."},
        "7.3": { "category": "Virtual Machines", "description": "Ensure that data disks (non-boot volumes) are encrypted, where possible.", "rationale": "Encrypting the IaaS VM's Data disks (non-boot volume) ensures that its entire content is fully unrecoverable without a key and thus protects the volume from unwarranted reads.", "remediation": "Azure Console\nFollow Microsoft Azure documentation.", "recommendation": "Ensure that data disks (non-boot volumes) are encrypted, where possible."},
        "7.4": { "category": "Virtual Machines", "description": "Only install your organization approved extensions on VMs.", "rationale": "Azure virtual machine extensions are small applications that provide post-deployment configuration and automation tasks on Azure virtual machines. These extensions run with administrative privileges and could potentially access anything on your virtual machine.  Azure portal and community provide several such extensions. Your organization should carefully evaluate such extensions and ensure that only those that are approved for use are actually used.", "remediation": "Azure Console\n 1. Go to Virtual machines\n 2. For each virtual machine, go to Settings\n 3. Click on Extensions\n 4. If there are unapproved extensions, uninstall them.", "recommendation": "Only install your organization approved extensions on VMs."},
        "7.5": { "category": "Virtual Machines", "description": "Ensure that the latest OS patches for all virtual machines are applied.", "rationale": "Windows and Linux virtual machines should be kept updated to:\n * Address a specific bug or flaw\n * Improve an OS or application’s general stability\n * Fix a security vulnerability\n The Azure Security Center retrieves a list of available security and critical updates from Windows Update or Windows Server Update Services (WSUS), depending on which service is configured on a Windows VM. The security center also checks for the latest updates in Linux systems. If a VM is missing a system update, the security center will recommend system updates be applied.", "remediation": "Follow Microsoft Azure documentation to apply security patches from the security center.  Alternatively, you can employ your own patch assessment and management tool to periodically assess, report and install the required security patches for your OS.", "recommendation": "Ensure that the latest OS patches for all virtual machines are applied."},
        "7.6": { "category": "Virtual Machines", "description": "Install endpoint protection for all virtual machines.", "rationale": "Installing endpoint protection systems (like Antimalware for Azure) provides for real-time protection capability that helps identify and remove viruses, spyware, and other malicious software, with configurable alerts when known malicious or unwanted software attempts to install itself or run on Azure systems.", "remediation": "Follow Microsoft Azure documentation to install endpoint protection from the security center. Alternatively, you can employ your own endpoint protection tool for your OS.", "recommendation": "Install endpoint protection for all virtual machines."},
        "8.1": { "category": "Other Security Considerations", "description": "Ensure that all keys in Azure Key Vault have an expiration time set.", "rationale": "Azure Key Vault enables users to store and use cryptographic keys within the Microsoft Azure environment. The exp (expiration time) attribute identifies the expiration time on or after which the key MUST NOT be used for a cryptographic operation. By default, keys never expire. It is thus recommended that keys be rotated in the key vault and set an explicit expiration time for all keys. This ensures that the keys cannot be used beyond their assigned lifetimes.", "remediation": "Azure Console\n 1. Go to Key vaults\n 2. For each Key vault, click on Keys.\n 3. Set an appropriate EXPIRATION DATE on all keys.", "recommendation": "Ensure that all keys in Azure Key Vault have an expiration time set."},
        "8.2": { "category": "Other Security Considerations", "description": "Ensure that all Secrets in the Azure Key Vault have an expiration time set.", "rationale": "The Azure Key Vault enables users to store and keep secrets within the Microsoft Azure environment. Secrets in the Azure Key Vault are octet sequences with a maximum size of 25k bytes each. The exp (expiration time) attribute identifies the expiration time on or after which the secret MUST NOT be used. By default, secrets never expire. It is thus recommended to rotate secrets in the key vault and set an explicit expiration time for all secrets. This ensures that the secrets cannot be used beyond their assigned lifetimes.", "remediation": "Azure Console\n 1. Go to Key vaults\n 2. For each Key vault, click on Secrets.\n 3. Set an appropriate EXPIRATION DATE on all secrets.", "recommendation": "Ensure that all Secrets in the Azure Key Vault have an expiration time set."},
        "8.3": { "category": "Other Security Considerations", "description": "Resource Manager Locks provide a way for administrators to lock down Azure resources to prevent deletion of, or modifications to, a resource. These locks sit outside of the Role Based Access Controls (RBAC) hierarchy and, when applied, will place restrictions on the resource for all users. These are very useful when there is have an important resource in a subscription that users should not be able to delete or change and can help prevent accidental and malicious changes or deletion.", "rationale": "As an administrator, it may be necessary to lock a subscription, resource group, or resource to prevent other users in the organization from accidentally deleting or modifying critical resources. The lock level can be set to to CanNotDelete or ReadOnly to achieve this purpose.\n * CanNotDelete means authorized users can still read and modify a resource, but they can't delete the resource.\n * ReadOnly means authorized users can read a resource, but they can't delete or update the resource. Applying this lock is similar to restricting all authorized users to the permissions granted by the Reader role.", "remediation": "Azure Console\n 1. Navigate to the specific Azure Resource or Resource Group\n 2. For each of the mission critical resource, click on Locks\n 3. Click Add\n 4. Give the lock a name and a description, then select the type, CanNotDelete or ReadOnly as appropriate", "recommendation": "Ensure that Resource Locks are set for mission critical Azure resources"}
}
