import re
from datetime import timedelta


def _timedelta_format(td_object: timedelta) -> str:
    """Convert timedelta format to readable string"""
    seconds = int(td_object.total_seconds())
    periods = [
        ("year", 60 * 60 * 24 * 365),
        ("month", 60 * 60 * 24 * 30),
        ("day", 60 * 60 * 24),
        ("hour", 60 * 60),
        ("minute", 60),
        ("second", 1),
    ]

    strings = []
    for period_name, period_seconds in periods:
        if seconds > period_seconds:
            period_value, seconds = divmod(seconds, period_seconds)
            has_s = "s" if period_value > 1 else ""
            strings.append(f"{period_value} {period_name}{has_s}")

    return ", ".join(strings)


def _sanitize_label(label: str) -> str:
    """Sanitize name for Union labels."""
    return re.sub("[:/]", "_", label)
