# -*- coding: utf-8 -*-
"""
Defines some default values for parsing cuttings descriptions.

:copyright: 2015 Agile Geoscience
:license: Apache 2.0
"""

# This is the matplotlib colour table. I'm trying to avoid having to
# depend on matplotlib just for this. Goal is that matplotlib plotting
# will be optional.
COLOURS = {
    'k': '#000000',
    'w': '#FFFFFF',
    'r': '#FF0000',
    'g': '#00FF00',
    'b': '#0000FF',
    'c': '#00FFFF',
    'm': '#FF00FF',
    'y': '#FFFF00',
    'aliceblue':            '#F0F8FF',
    'antiquewhite':         '#FAEBD7',
    'aqua':                 '#00FFFF',
    'aquamarine':           '#7FFFD4',
    'azure':                '#F0FFFF',
    'beige':                '#F5F5DC',
    'bisque':               '#FFE4C4',
    'black':                '#000000',
    'blanchedalmond':       '#FFEBCD',
    'blue':                 '#0000FF',
    'blueviolet':           '#8A2BE2',
    'brown':                '#A52A2A',
    'burlywood':            '#DEB887',
    'cadetblue':            '#5F9EA0',
    'chartreuse':           '#7FFF00',
    'chocolate':            '#D2691E',
    'coral':                '#FF7F50',
    'cornflowerblue':       '#6495ED',
    'cornsilk':             '#FFF8DC',
    'crimson':              '#DC143C',
    'cyan':                 '#00FFFF',
    'darkblue':             '#00008B',
    'darkcyan':             '#008B8B',
    'darkgoldenrod':        '#B8860B',
    'darkgray':             '#A9A9A9',
    'darkgreen':            '#006400',
    'darkkhaki':            '#BDB76B',
    'darkmagenta':          '#8B008B',
    'darkolivegreen':       '#556B2F',
    'darkorange':           '#FF8C00',
    'darkorchid':           '#9932CC',
    'darkred':              '#8B0000',
    'darksage':             '#598556',
    'darksalmon':           '#E9967A',
    'darkseagreen':         '#8FBC8F',
    'darkslateblue':        '#483D8B',
    'darkslategray':        '#2F4F4F',
    'darkturquoise':        '#00CED1',
    'darkviolet':           '#9400D3',
    'deeppink':             '#FF1493',
    'deepskyblue':          '#00BFFF',
    'dimgray':              '#696969',
    'dodgerblue':           '#1E90FF',
    'firebrick':            '#B22222',
    'floralwhite':          '#FFFAF0',
    'forestgreen':          '#228B22',
    'fuchsia':              '#FF00FF',
    'gainsboro':            '#DCDCDC',
    'ghostwhite':           '#F8F8FF',
    'gold':                 '#FFD700',
    'goldenrod':            '#DAA520',
    'gray':                 '#808080',
    'green':                '#008000',
    'greenyellow':          '#ADFF2F',
    'honeydew':             '#F0FFF0',
    'hotpink':              '#FF69B4',
    'indianred':            '#CD5C5C',
    'indigo':               '#4B0082',
    'ivory':                '#FFFFF0',
    'khaki':                '#F0E68C',
    'lavender':             '#E6E6FA',
    'lavenderblush':        '#FFF0F5',
    'lawngreen':            '#7CFC00',
    'lemonchiffon':         '#FFFACD',
    'lightblue':            '#ADD8E6',
    'lightcoral':           '#F08080',
    'lightcyan':            '#E0FFFF',
    'lightgoldenrodyellow': '#FAFAD2',
    'lightgreen':           '#90EE90',
    'lightgray':            '#D3D3D3',
    'lightpink':            '#FFB6C1',
    'lightsage':            '#BCECAC',
    'lightsalmon':          '#FFA07A',
    'lightseagreen':        '#20B2AA',
    'lightskyblue':         '#87CEFA',
    'lightslategray':       '#778899',
    'lightsteelblue':       '#B0C4DE',
    'lightyellow':          '#FFFFE0',
    'lime':                 '#00FF00',
    'limegreen':            '#32CD32',
    'linen':                '#FAF0E6',
    'magenta':              '#FF00FF',
    'maroon':               '#800000',
    'mediumaquamarine':     '#66CDAA',
    'mediumblue':           '#0000CD',
    'mediumorchid':         '#BA55D3',
    'mediumpurple':         '#9370DB',
    'mediumseagreen':       '#3CB371',
    'mediumslateblue':      '#7B68EE',
    'mediumspringgreen':    '#00FA9A',
    'mediumturquoise':      '#48D1CC',
    'mediumvioletred':      '#C71585',
    'midnightblue':         '#191970',
    'mintcream':            '#F5FFFA',
    'mistyrose':            '#FFE4E1',
    'moccasin':             '#FFE4B5',
    'navajowhite':          '#FFDEAD',
    'navy':                 '#000080',
    'oldlace':              '#FDF5E6',
    'olive':                '#808000',
    'olivedrab':            '#6B8E23',
    'orange':               '#FFA500',
    'orangered':            '#FF4500',
    'orchid':               '#DA70D6',
    'palegoldenrod':        '#EEE8AA',
    'palegreen':            '#98FB98',
    'paleturquoise':        '#AFEEEE',
    'palevioletred':        '#DB7093',
    'papayawhip':           '#FFEFD5',
    'peachpuff':            '#FFDAB9',
    'peru':                 '#CD853F',
    'pink':                 '#FFC0CB',
    'plum':                 '#DDA0DD',
    'powderblue':           '#B0E0E6',
    'purple':               '#800080',
    'red':                  '#FF0000',
    'rosybrown':            '#BC8F8F',
    'royalblue':            '#4169E1',
    'saddlebrown':          '#8B4513',
    'salmon':               '#FA8072',
    'sage':                 '#87AE73',
    'sandybrown':           '#FAA460',
    'seagreen':             '#2E8B57',
    'seashell':             '#FFF5EE',
    'sienna':               '#A0522D',
    'silver':               '#C0C0C0',
    'skyblue':              '#87CEEB',
    'slateblue':            '#6A5ACD',
    'slategray':            '#708090',
    'snow':                 '#FFFAFA',
    'springgreen':          '#00FF7F',
    'steelblue':            '#4682B4',
    'tan':                  '#D2B48C',
    'teal':                 '#008080',
    'thistle':              '#D8BFD8',
    'tomato':               '#FF6347',
    'turquoise':            '#40E0D0',
    'violet':               '#EE82EE',
    'wheat':                '#F5DEB3',
    'white':                '#FFFFFF',
    'whitesmoke':           '#F5F5F5',
    'yellow':               '#FFFF00',
    'yellowgreen':          '#9ACD32'}

# LEGENDS

# Canstrat
LEGEND__Canstrat = """colour,int,data,width,component lithology
#d60000,1.0,x,None,Igneous basic,
#d60000,2.0,n,None,Igneous acidic,
#d60000,3.0,z,None,Metamorphic,
#d60000,4.0,v,None,Volcanic,
#f4db94,8.0,r,None,Siderite,
#c8965a,9.0,u,None,Glacial till,
#ff9000,12.0,e,None,Conglomerate,
#ffc500,13.0,f,None,Breccia,
#94c5c5,16.0,h,None,Chert,
#ffff00,17.0,j,None,Sandstone,
#ff863e,18.0,i,None,Siltstone,
#c5ffff,19.0,c,None,Clay,
#909090,20.0,s,None,Shale,
#c5c5ff,22.0,b,None,Bentonite,
#020202,24.0,q,None,Coal,
#c5c5c5,26.0,m,None,Marlstone,
#7d96ff,27.0,l,None,Limestone,
#ff46ff,30.0,d,None,Dolomite,
#aa6435,35.0,a,None,Anhydrite,
#008200,37.0,t,None,Salt,
#906e90,39.0,g,None,Gypsum,
#c5ffc5,40.0,p,None,Phosphate,"""

# The Nova Scotia Dept of Energy's legend

LEGEND__NSDOE = """colour, width, comp lithology, comp colour, comp grainsize
#F7E9A6, 3, Sandstone, Grey, VF-F
#FF99CC, 2, Anhydrite, ,
#DBD6BC, 3, Heterolithic, Grey,
#FF4C4A, 2, Volcanic, ,
#86F0B6, 5, Conglomerate, ,
#FF96F6, 2, Halite, ,
#F2FF42, 4, Sandstone, Grey, F-M
#DBC9BC, 3, Heterolithic, Red,
#A68374, 2, Siltstone, Grey,
#A657FA, 3, Dolomite, ,
#FFD073, 4, Sandstone, Red, C-M
#A6D1FF, 3, Limestone, ,
#FFDBBA, 3, Sandstone, Red, VF-F
#FFE040, 4, Sandstone, Grey, C-M
#A1655A, 2, Siltstone, Red,
#363434, 1, Coal, ,
#664A4A, 1, Mudstone, Red,
#666666, 1, Mudstone, Grey, """

# Data downloaded from
# Lorre A. Moyer, Jordan T. Hastings, and Gary L. Raines
# Methods to Create ArcMap® Styles with Examples for Lithology and Time
# U.S. Geological Survey Open-File Report 2005-1314
# http://pubs.usgs.gov/of/2005/1314/

# NAGDM
# North America Geologic Map Data Model
# http://ngmdb.usgs.gov/www-nadm/

LEGEND__NAGMDM__6_2 = """colour,width,component lithology
#FDF43F,None,Unconsolidated material,
#FFFF89,None,Alluvium,
#FFFFD5,None,Flood plain,
#FFFAE9,None,Levee,
#FFFAC8,None,Delta,
#FFFFB7,None,Alluvial fan,
#FAEE7A,None,Alluvial terrace,
#F4EFE4,None,Lake or marine sediment,
#F1E5DF,None,Playa,
#E4D0BE,None,Mud flat,
#E4D8BE,None,Beach sand,
#FFF6D9,None,Terrace,
#E0C59E,None,Eolian material,
#E0D2B4,None,Dune sand,
#DBCCA9,None,Sand sheet,
#F5E1BD,None,Loess,
#E0B09E,None,Volcanic ash,
#CFBB8F,None,Mass wasting material,
#E1E3C3,None,Colluvium,
#E5DBB3,None,Mudflow,
#DCD5B4,None,Lahar,
#D3CA9F,None,Debris flow,
#C9BE89,None,Landslide,
#BCAF6C,None,Talus,
#BFA743,None,Glacial drift,
#D2C27C,None,Till,
#FFEEBF,None,Moraine,
#FFE59D,None,Stratified glacial sediment,
#FFDF85,None,Glacial outwash sediment,
#FEE670,None,Sub/supra-glacial sediment,
#FEE258,None,Glaciolacustrine sediment,
#FEDB2E,None,Glacial-marine sediment,
#F7F3A1,None,Biogenic rock,
#FFCF81,None,Peat,
#FFCC99,None,Coral,
#FFE389,None,Residuum,
#FFDB67,None,Clay or mud,
#FFD345,None,Silt,
#FFCB23,None,Sand,
#ECB400,None,Gravel,
#92DCB7,None,Sedimentary rock,
#D9FDD3,None,Clastic rock,
#CFEFDF,None,Mudstone,
#D5E6CC,None,Claystone,
#C0D0C0,None,Bentonite,
#ACE4C8,None,Shale,
#DBFEBC,None,Black shale,
#BBFFDD,None,Oil shale,
#E1F0D8,None,Argillite,
#D6FE9A,None,Siltstone,
#95FFCA,None,Fine-grained mixed clastic rock,
#CDFFD9,None,Sandstone,
#A6FCAA,None,Arenite,
#CBEFCE,None,Orthoquartzite,
#9ACEFE,None,Calcarenite,
#69CF9C,None,Arkose,
#BDDBF1,None,Wacke,
#B8EAC3,None,Graywacke,
#90A565,None,Medium-grained mixed clastic rock,
#B7D9CC,None,Conglomerate,
#A7BA86,None,Sedimentary breccia,
#A5AAAD,None,Coarse-grained mixed clastic rock,
#8DBECD,None,Olistostrome,
#BBC0C5,None,Melange,
#56E0FC,None,Carbonate rock,
#43AFF9,None,Limestone,
#6BC3FF,None,Dolostone,
#38B4B1,None,Mixed carbonate/clastic rock,
#60CCBF,None,Mixed volcanic/clastic rock,
#BFE3DC,None,Phosphorite,
#CDDEFF,None,Chemical sedimentary rock,
#019CCD,None,Evaporite,
#9ABFC0,None,Chert,
#C0AEB6,None,Novaculite,
#B99598,None,Iron formation,
#D9C2A3,None,Exhalite,
#820041,None,Coal,
#6E4909,None,Mixed coal and clastic rock,
#FC6E7C,None,Plutonic rock,
#FFC1B7,None,Aplite,
#FFE1E8,None,Porphyry,
#E45891,None,Lampophyre,
#FFEFF3,None,Pegmatite,
#DD2972,None,Granitoid,
#FFD1DC,None,Alkali-feldspar granite,
#F9B5BB,None,Granite,
#F8BEAE,None,Peraluminous granite,
#FFB3C5,None,Metaluminous granite,
#FF6F6B,None,Subaluminous granite,
#FC5262,None,Peralkaline granite,
#E979A6,None,Granodiorite,
#FCB6B6,None,Tonalite,
#FFA7BC,None,Trondhjemite,
#F43C6C,None,Alkali-feldpar syenite,
#FB2338,None,Quartz syenite,
#F41A87,None,Syenite,
#FF6388,None,Quartz monzonite,
#FF275A,None,Monzonite,
#FF819F,None,Quartz monzodiorite,
#FFA99D,None,Monzodiorite,
#E81C00,None,Quartz diorite,
#FF3317,None,Diorite,
#D60000,None,Diabase,
#AC0000,None,Gabbroid,
#FF6F5B,None,Quartz monzogabbro,
#E377AD,None,Monzogabbro,
#EDA7CA,None,Quartz gabbro,
#E993BE,None,Gabbro,
#FFD6D1,None,Norite,
#FFBFCE,None,Troctolite,
#FF95AE,None,Anorthosite,
#FF6F91,None,Alkalic intrusive rock,
#FF1B51,None,Nepheline syenite,
#E80037,None,Ultramafic intrusive rock,
#CE0031,None,Peridotite,
#B0002A,None,Dunite,
#C1010A,None,Kimberlite,
#940023,None,Pyroxenite,
#A30109,None,Hornblendite,
#750107,None,Intrusive carbonatite,
#FFB7DE,None,Volcanic rock,
#FFC3E4,None,Glassy volcanic rock,
#FFD1EA,None,Obsidian,
#FFC3F8,None,Vitrophyre,
#FFE5F3,None,Pumice,
#FFE0DE,None,Pyroclastic,
#F9D3D3,None,Tuff,
#FFF3C9,None,Welded tuff,
#FFEFD9,None,Ash-flow tuff,
#FFE5C3,None,Ignimbrite,
#FFD59D,None,Volcanic breccia,
#FFA227,None,Lava flow,
#FFC16F,None,Bimodal suite,
#F48B00,None,Felsic volcanic rock,
#FEDC7E,None,Alkali-feldspar rhyolite,
#FECC68,None,Rhyolite,
#FEC62A,None,Rhyodacite,
#FECDAC,None,Dacite,
#FEB786,None,Alkali-feldspar trachyte,
#FEA060,None,Trachyte,
#FE8736,None,Quartz latite,
#FE7518,None,Latite,
#EB6001,None,Intermediate volcanic rock,
#C95201,None,Trachyandesite,
#B14801,None,Andesite,
#933C01,None,Mafic volcanic rock,
#ECD5C6,None,Trachybasalt,
#DDB397,None,Basalt,
#D39D79,None,Tholeite,
#C68050,None,Hawaiite,
#A96537,None,Alkaline basalt,
#C24100,None,Alkalic volcanic rock,
#5F391F,None,Phonolite,
#854F2B,None,Tephrite,
#A03500,None,Ultramafitite,
#6E2500,None,Volcanic carbonatite,
#A7A7FF,None,Metamorphic rock,
#EAAFFF,None,Hornfels,
#7DFF7D,None,Metasedimentary rock,
#C9FFC9,None,Meta-argillite,
#E6CDFF,None,Slate,
#9FFF9F,None,Quartzite,
#E9FFE9,None,Metaconglomerate,
#0000FF,None,Marble,
#FF57FF,None,Metavolcanic rock,
#FF8DFF,None,Felsic metavolcanic rock,
#FFA7FF,None,Metarhyolite,
#FE6700,None,Keratophyre,
#FF0000,None,Intermediate metavolcanic rock,
#B93B68,None,Mafic metavolcanic rock,
#872B4C,None,Metabasalt,
#C9557E,None,Spilite,
#008000,None,Greenstone,
#B4CFE4,None,Phyllite,
#DBDBE7,None,Schist,
#EDEDF3,None,Greenschist,
#C0C0C0,None,Blueschist,
#B1B1B1,None,Mica schist,
#CACADC,None,Pelitic schist,
#A2A2C0,None,Quartz-feldspar schist,
#B6B6CE,None,Calc-silicate schist,
#969696,None,Amphibole schist,
#A337FD,None,Granofels,
#ECD6FE,None,Gneiss,
#E0BCFE,None,Felsic gneiss,
#D5A4FE,None,Granitic gneiss,
#C886FE,None,Biotite gneiss,
#CCB7FF,None,Mafic gneiss,
#B395FF,None,Orthogneiss,
#9063FF,None,Paragneiss,
#9F00CA,None,Migmatite,
#7B009C,None,Amphibolite,
#6A006A,None,Granulite,
#CE9DFF,None,Eclogite,
#A449FF,None,Greisen,
#8103FF,None,Skarn,
#46008C,None,Calc-silicate rock,
#005C00,None,Serpentinite,
#84613E,None,Tectonite,
#D0CBB0,None,Tectonic melange,
#B0A778,None,Tectonic breccia,
#887F50,None,Cataclasite,
#AC7F50,None,Phyllonite,
#6D5033,None,Mylonite,
#64020B,None,Flaser gneiss,
#887F50,None,Augen gneiss,
"""
LEGEND__NAGMDM__6_1 = """colour,width,component lithology
#FFFFE9,None,unconsolidated,
#FFFFD5,None,alluvium,
#FFFFB7,None,flood plain,
#FFFF89,None,levee,
#FDF43F,None,delta,
#FFFAE9,None,alluvial fan,
#FAEE7A,None,alluvial terrace,
#F4EFE4,None,lake or marine deposit,
#EEE7D6,None,playa,
#EAE1CC,None,mud flat,
#E4D8BE,None,beach sand,
#FFF6D9,None,terrace,
#E0B000,None,eolian,
#E0D2B4,None,dune sand,
#DBCCA9,None,sand sheet,
#F5E1BD,None,loess,
#D6C59E,None,volcanic ash,
#CFBB8F,None,mass wasting,
#E1E3C3,None,colluvium,
#DCD5B4,None,mudflow,
#D3CA9F,None,lahar,
#C9BE89,None,debris flow,
#BCAF6C,None,landslide,
#9D8935,None,talus,
#BFA743,None,glacial drift,
#D2C27C,None,till,
#FFEEBF,None,moraine,
#FFE59D,None,stratified glacial sediment,
#FFE985,None,outwash,
#FEE670,None,sub- and supra-glacial sediment,
#FEE258,None,glaciolacustrine,
#FEDB2E,None,glacial-marine,
#F7F3A1,None,biogenic sediment,
#FFCC99,None,peat,
#FFEAA7,None,coral,
#FFE389,None,residuum,
#FFDB67,None,clay or mud,
#FFD345,None,silt,
#FFCB23,None,sand,
#ECB400,None,gravel,
#CFEFDF,None,sedimentary rock,
#D9FDD3,None,clastic,
#ACE4C8,None,mudstone,
#D5E6CC,None,claystone,
#92DCB7,None,bentonite,
#C0D0C0,None,shale,
#DBFEBC,None,black shale,
#BBFFDD,None,oil shale,
#95FFCA,None,argillite,
#D6FE9A,None,siltstone,
#E1F0D8,None,fine-grained mixed clastic,
#CDFFD9,None,sandstone,
#CBEFCE,None,arenite,
#A6FCAA,None,orthoquartzite,
#7DFFE3,None,calcarenite,
#B8EAC3,None,arkose,
#BDDBF1,None,wacke,
#69CF9C,None,graywacke,
#90A565,None,medium-grained mixed clastic,
#B7D9CC,None,conglomerate,
#A7BA86,None,sedimentary breccia,
#BCC0C5,None,coarse-grained mixed clastic,
#8DBECD,None,olistostrome,
#A5AAAD,None,melange,
#019CCD,None,carbonate,
#149EF8,None,limestone,
#0094F8,None,dolostone (dolomite),
#45C5C2,None,mixed clastic/carbonate,
#38B0A2,None,mixed clastic/volcanic,
#BFE3DC,None,phosphorite,
#CDDEFF,None,chemical,
#9ACEFE,None,evaporite,
#AAC2C8,None,chert,
#C0AEB6,None,novaculite,
#B99598,None,iron formation,
#98004C,None,exhalite,
#6E4900,None,coal,
#D9C2A3,None,mixed clastic/coal,
#FFEFF3,None,plutonic rock (phaneritic),
#FFC8BF,None,aplite,
#FFE1E8,None,porphyry,
#FDCFCF,None,lamprophyre,
#FFD1DC,None,pegmatite,
#FC6E7C,None,granitoid,
#FC5262,None,alkali granite (alaskite),
#FB2338,None,granite,
#F43C6C,None,peraluminous granite,
#F41A87,None,metaluminous granite,
#DD2972,None,subaluminous granite,
#E45891,None,peralkaline granite,
#E979A6,None,granodiorite,
#FF6F6B,None,tonalite,
#FFB3C5,None,trondhjemite,
#F8BEAE,None,alkali syenite,
#F9B5BB,None,quartz syenite,
#FFA7BC,None,syenite,
#FF6388,None,quartz monzonite,
#FF275A,None,monzonite,
#FFCCC5,None,quartz monzodiorite,
#FFA99D,None,monzodiorite,
#FF6F5B,None,quartz diorite,
#FF3317,None,diorite,
#E81C00,None,diabase,
#FF95AE,None,gabbroid,
#FF819F,None,quartz monzogabbro,
#FFD6D1,None,monzogabbro,
#EDA7CA,None,quartz gabbro,
#E993BE,None,gabbro,
#E377AD,None,norite,
#FFBFCE,None,troctolite,
#FFA3B9,None,anorthosite,
#FF6F91,None,alkalic intrusive rock,
#FF1B51,None,nepheline syenite,
#E80037,None,ultramafic intrusive rock,
#CE0031,None,peridotite,
#B0002A,None,dunite,
#940023,None,kimberlite,
#C1010A,None,pyroxenite,
#A30109,None,hornblendite,
#750107,None,intrusive carbonatite,
#F9D3D3,None,volcanic rock (aphanitic),
#FFE5F3,None,glassy volcanic rock,
#FFD1EA,None,obsidian,
#FFC3F8,None,vitrophyre,
#FFC3E4,None,pumice,
#FFEDBF,None,pyroclastic,
#FFEFD9,None,tuff,
#FFB7DE,None,welded tuff,
#FFC8C3,None,ash-flow tuff,
#FFE5C3,None,ignimbrite,
#FFD59D,None,volcanic breccia (agglomerate),
#FFC10B,None,lava flow,
#FFA227,None,bimodal suite,
#F48B00,None,felsic volcanic rock,
#FEDC7E,None,alkali rhyolite,
#FED768,None,rhyolite,
#FEC62A,None,rhyodacite,
#FECDAC,None,dacite,
#FEB786,None,alkali trachyte,
#FEA060,None,trachyte,
#FE8736,None,quartz latite,
#FE7518,None,latite,
#EB6001,None,intermediate volcanic rock,
#C95201,None,trachyandesite,
#B14801,None,andesite,
#933C01,None,mafic volcanic rock,
#ECD5C6,None,trachybasalt,
#DDB397,None,basalt,
#D39D79,None,tholeite,
#C68050,None,hawaiite,
#A96537,None,alkaline basalt,
#854F2B,None,alkalic volcanic rock,
#5F391F,None,phonolite,
#C24100,None,tephrite (basinite),
#A03500,None,ultramafitite (komatiite),
#6E2500,None,volcanic carbonatite,
#E6CDFF,None,metamorphic rock,
#EAAFFF,None,hornfels,
#E9FFE9,None,metasedimentary rock,
#C9FFC9,None,meta-argillite,
#A7A7FF,None,slate,
#9FFF9F,None,quartzite,
#7DFF7D,None,meta-conglomerate,
#0000FF,None,marble,
#FFA7FF,None,metavolcanic rock,
#FF8DFF,None,felsic metavolcanic rock,
#FF57FF,None,meta-rhyolite,
#FE6700,None,keratophyre,
#C9557E,None,intermediate metavolcanic rock,
#B93B68,None,mafic metavolcanic rock,
#872B4C,None,meta-basalt,
#FF0000,None,spilite,
#008000,None,greenstone,
#EDEDF3,None,phyllite,
#DBDBE7,None,schist,
#CACADC,None,greenschist,
#C0C0C0,None,blueschist,
#B1B1B1,None,mica schist,
#969696,None,pelitic schist,
#A2A2C0,None,quartz-feldspar schist,
#B4CFE4,None,calc-silicate schist,
#B6B6CE,None,amphibole schist,
#ABFFFF,None,granofels,
#79FFFF,None,gneiss,
#0FFFFF,None,felsic gneiss,
#00DBD6,None,granitic gneiss,
#00A4A0,None,biotite gneiss,
#007673,None,mafic gneiss,
#33CCCC,None,orthogneiss,
#2DB6B3,None,paragneiss,
#AC0000,None,migmatite,
#AC7F50,None,amphibolite,
#84613E,None,granulite,
#FF4FFF,None,eclogite,
#EC00EC,None,greisen,
#6600CC,None,skarn (tactite),
#46008C,None,calc-silicate rock,
#005C00,None,serpentinite,
#C600C6,None,tectonic rock,
#9C009C,None,tectonite,
#6A006A,None,tectonic melange,
#2A002A,None,tectonic breccia,
#F4FFD5,None,cataclasite,
#339966,None,phyllonite,
#D0CBB0,None,mylonite,
#B0A778,None,flaser gneiss,
#887F50,None,augen gneiss,"""

LEGEND__NAGMDM__4_3 = """
colour,width,component lithology
#FCFFE3,None,Unconsolidated,
#CCAD21,None,Boulder,
#E6C214,None,Gravel,
#FFE040,None,Sand,
#FFF559,None,Silt,
#F2FFA6,None,Clay,
#E6FF80,None,Peat,
#FFEB69,None,Mixed,
#40FF96,None,Sedimentary Rock,
#CFE669,None,Mudstone,
#BAD16B,None,Claystone,
#8CBA12,None,Shale,
#7AA800,None,Siltstone,
#A3F769,None,Sandstone,
#89DE50,None,Arenite,
#70C436,None,Orthoquartzite,
#57AB1C,None,Arkose,
#3D9103,None,Wacke,
#86F0B6,None,Conglomerate,
#B5CC00,None,Sedimentary Breccia,
#C9E300,None,Sedimentary Melange,
#7373FF,None,Carbonate,
#A6A6FF,None,Limestone,
#BFBFFF,None,Dolomite,
#9EE8FF,None,Evaporite,
#00A9E6,None,Chert,
#597D6E,None,Coal,
#FFD973,None,Extrusive Rock,
#FFE6CC,None,Felsic,
#FFCCB3,None,Alkali Rhyolite,
#FFB399,None,Rhyolite,
#FFAB8C,None,Dacite,
#FF9980,None,Alkali Trachyte,
#FF8066,None,Trachyte,
#FF664C,None,Latite,
#FFE699,None,Intermediate,
#FFCC80,None,Andesite,
#FFB366,None,Basaltic Andesite,
#FF994C,None,Phonolite,
#FF804C,None,Tephrite,
#FFCC33,None,Mafic,
#E69900,None,Basalt,
#A87333,None,Ultramafic,
#FF0000,None,Intrusive Rock,
#FFD1CF,None,Granitoid,
#FFF2F2,None,Granite,
#FFD9D9,None,Granodiorite,
#FFCCC9,None,Tonolite,
#FFB3B0,None,Quartz Syenite,
#FF9996,None,Quartz Monzonite,
#FF807D,None,Quartz Monzodiorite,
#FF6663,None,Quartz Monzogabbro,
#FF4C4A,None,Quartz Diorite,
#FF3330,None,Diorite,
#FF1917,None,Gabbro,
#E60000,None,Norite,
#CC0000,None,Troctolite,
#B30000,None,Anorthosite,
#E6B3B3,None,Alkalic Intrusive,
#E69999,None,Syenite,
#E68080,None,Monzonite,
#E66666,None,Monzodiorite,
#E64C4C,None,Monzogabbro,
#CC9999,None,Ultramafic Intrusive,
#CC8080,None,Peridotite,
#CC6666,None,Pyroxenite,
#CC4C4C,None,Hornblendite,
#CC3333,None,Carbonatite,
#E6CCFF,None,Metamorphic Rock,
#CC3333,None,Hornfels,
#547899,None,Slate,
#F2FFE6,None,Metasedimentary,
#E6FFCC,None,Argillite,
#CCFFB3,None,Quartzite,
#2138EB,None,Marble,
#F2A6FF,None,Metavolcanic,
#056E49,None,Greenstone,
#8A4533,None,Keratophyre,
#C23453,None,Spilite,
#E1E1E1,None,Phyllite,
#CCCCCC,None,Schist,
#B2B2B2,None,Mica Schist,
#999999,None,Quartz-feldspar Schist,
#668080,None,Calc-silicate Schist,
#42413C,None,Amphibole Schist,
#B3B3CC,None,Semischist,
#BFF2F2,None,Gneiss,
#99E6E6,None,Felsic Gneiss,
#80D9D9,None,Granitic Gneiss,
#80CCCC,None,Calc-silicate Gneiss,
#4CB3B3,None,Mafic Gneiss,
#754000,None,Amphibolite,
#D67869,None,Granulite,
#D58ADE,None,Eclogite,
#F721DE,None,Greisen,
#9100DE,None,Skarn,
#36B378,None,Serpentinite,
#9E2E8D,None,Tectonic Breccia,
#F0FCE1,None,Cataclasite,
#0E8A2F,None,Phyllonite,
#969666,None,Mylonite,"""

# SGMC
# State Geologic Map Compilation

LEGEND__SGMC = """colour,width,component lithology
#FDF43F,None,Unconsolidated,
#FFFF89,None,Coarse_detrital,
#FFDA63,None,Boulders,
#FFCE1D,None,Gravel,
#EEC102,None,Sand,
#FFCC99,None,Coral,
#EEEFB3,None,Fine_detrital,
#E5E081,None,Clay,
#F9F5D3,None,Silt,
#FEF2B8,None,Marl,
#FFE389,None,Peat,
#BDDBF1,None,Water,
#92DCB7,None,Sedimentary,
#56E0FC,None,Carbonate,
#6BC3FF,None,Dolostone,
#43AFF9,None,Limestone,
#DEEFFE,None,Chalk,
#8CE5FE,None,Coquina,
#BAE5FE,None,Marlstone,
#CDDEFF,None,Chemical,
#D5D11F,None,Banded_iron_formation,
#C9B655,None,Barite,
#8CB7B8,None,Chert,
#C7C299,None,Diatomite,
#DEE5C4,None,Evaporite,
#E7F6F1,None,Anhydrite,
#E1E9EC,None,Gypsum,
#C5D5E9,None,Salt,
#A3ADCB,None,Novaculite,
#BFE3DC,None,Phosphorite,
#D9FDD3,None,Clastic,
#B7D9CC,None,Conglomerate,
#65CFCC,None,Mixed-clastic,
#98C8AE,None,Conglomerate_sandstone,
#95FFCA,None,Sandstone_Mudstone,
#3DBFB0,None,Siltstone_Mudstone,
#CFEFDF,None,Mudstone,
#D5E6CC,None,Claystone,
#C0D0C0,None,Bentonite,
#ACE4C8,None,Shale,
#DBFEBC,None,Black_shale,
#BBFFDD,None,Oil_shale,
#9ED7C2,None,Phosphatic_shale,
#CDFFD9,None,Sandstone,
#A6FCAA,None,Arenite,
#9ACEFE,None,Calcarenite,
#69CF9C,None,Arkose,
#A7E5B4,None,Graywacke,
#A7BA86,None,Sedimentary_breccia,
#D6FE9A,None,Siltstone,
#8C8CF0,None,Coal,
#6363EB,None,Anthracite,
#2727E3,None,Bituminous,
#1616A8,None,Lignite,
#001086,None,Sub_bituminous,
#C61585,None,Plutonic,
#FFE3E0,None,Anorthosite,
#EED5D3,None,Charnockite,
#DFC8C8,None,Dioritic,
#D7A7AD,None,Diorite,
#EEA0AA,None,Monzodiorite,
#FFADB8,None,Quartz_diorite,
#FFB8C1,None,Quartz_monzodiorite,
#E88CA0,None,Foidal_dioritic,
#CE929F,None,Foidal_gabbroic,
#FF9EBE,None,Foidal_syenitic,
#FF80AA,None,Cancrinite_syenite,
#ED789D,None,Foid_syenite,
#CD6A8B,None,Nepheline_syenite,
#CF208F,None,Sodalite_syenite,
#FD1D68,None,Foidolite,
#FF5B5B,None,Gabbroic,
#E993BE,None,Gabbro,
#FF85FB,None,Gabbronorite,
#EE7CE8,None,Norite,
#CD6ACA,None,Troctolite,
#FFBDFF,None,Monzogabbro,
#EEAFEE,None,Quartz_gabbro,
#CD98CD,None,Quartz_monzogabbro,
#EE68A6,None,Granitic,
#FF70B5,None,Alkali_feldspar_granite,
#FF3895,None,Alkali_granite,
#FF33B4,None,Granite,
#FF00FF,None,Monzogranite,
#FC9EFE,None,Syenogranite,
#EE2FA8,None,Granodiorite,
#D7339A,None,Leucocratic_granitic,
#D503B4,None,Alaskite,
#B300B3,None,Aplite,
#CA61FF,None,Pegmatite,
#FF5BB9,None,Quartz_rich_granitoid,
#A82475,None,Tonalite,
#F80094,None,Trondhjemite,
#F00000,None,Intrusive_carbonatite,
#FF3838,None,Melilitic,
#CD3278,None,Syenitic,
#FF1492,None,Alkali_feldspar_syenite,
#EE1187,None,Monzonite,
#CC0F74,None,Quartz_alkali_feldspar_syenite,
#FF9FAA,None,Quartz_monzonite,
#FF61A8,None,Quartz_syenite,
#B80F5B,None,Syenite,
#CC0000,None,Ultramafic,
#8A475C,None,Hornblendite,
#8A668A,None,Peridotite,
#8C6969,None,Dunite,
#7D1C66,None,Kimberlite,
#6B0000,None,Pyroxenite,
#E4DBEC,None,Ice,
#F84D4D,None,Igneous,
#CDB79D,None,Hypabyssal,
#DEB887,None,Felsic_hypabyssal,
#FFEFDB,None,Hypabyssal_dacite,
#FAEAD6,None,Hypabyssal_felsic_alkaline,
#EEE1CE,None,Hypabyssal_latite,
#FFE0C2,None,Hypabyssal_quartz_latite,
#FFD399,None,Hypabyssal_quartz_trachyte,
#EEC591,None,Hypabyssal_rhyolite,
#CDAB7E,None,Hypabyssal_trachyte,
#CC8500,None,Lamprophyre,
#EE7620,None,Mafic_hypabyssal,
#FFB70F,None,Hypabyssal_andesite,
#ECAD0E,None,Hypabyssal_basalt,
#FFA600,None,Hypabyssal_basaltic_andesite,
#F09C00,None,Hypabyssal_mafic_alkaline,
#EE694F,None,Volcanic,
#FFA352,None,Alkalic_volcanic,
#FF8052,None,Basanite,
#FF7357,None,Foidite,
#D57562,None,Phonolite,
#CD7637,None,Felsic_volcanic,
#FCBE92,None,Dacite,
#FF9D47,None,Latite,
#FF8259,None,Quartz_latite,
#EE5E44,None,Quartz_trachyte,
#C2755B,None,Rhyolite,
#CD4E37,None,Trachyte,
#EA9090,None,Mafic_volcanic,
#EE2B2B,None,Andesite,
#E46C6C,None,Basalt,
#DB3939,None,Basaltic_andesite,
#B33000,None,Komatiite,
#8A2500,None,Picrite,
#A7A7FF,None,Metamorphic,
#7B009C,None,Amphibolite,
#8C298A,None,Argillite,
#6A006A,None,Eclogite,
#9F00CA,None,Gneiss,
#A337FD,None,Granofels,
#9B02B0,None,Granulite,
#698263,None,Greenstone,
#EAAFFF,None,Hornfels,
#6900FF,None,Marble,
#A184A2,None,Metasedimentary,
#DE5785,None,Metavolcanic,
#9F8ACA,None,Migmatite,
#DBDBE7,None,Phyllite,
#B4CFE4,None,Quartzite,
#BBC0C5,None,Schist,
#638A57,None,Serpentinite,
#AB70FF,None,Skarn,
#8103FF,None,Slate,
#84613E,None,Tectonite,
#887F50,None,Cataclasite,
#AC7F50,None,Melange,
#6D5033,None,Mylonite,
#64020B,None,Phyllonite,"""

TIMESCALE__ISC = """colour,width,component age
#6FDAED,None,Phanerozoic,
#F6EC39,None,Cenozoic,
#FEF691,None,Quaternary,
#F2F902,None,Tertiary,
#FEDD2D,None,Neogene,
#FEF1E0,None,Holocene,
#FEEFB8,None,Pleistocene,
#FEF1D6,None,Upper Pleistocene,
#FEF1D6,None,Tarantian,
#FEF0CC,None,Middle Pleistocene,
#FEF0CC,None,Ionian,
#FEEFC1,None,Calabrian,
#FEEEAD,None,Gelasian,
#FEF8A6,None,Pliocene,
#FEFAC8,None,Piacenzian,
#FEF9BD,None,Zanclean,
#FEEF00,None,Miocene,
#FEF587,None,Messinian,
#FEF47D,None,Tortonian,
#FEF472,None,Serravallian,
#FEF366,None,Langhian,
#FEF259,None,Burdigalian,
#FEF14D,None,Aquitanian,
#FEA163,None,Paleogene,
#FEA163,None,Palæogene,
#FEA163,None,Palaeogene,
#FEC386,None,Oligocene,
#FEE4B2,None,Chattian,
#FED9A2,None,Rupelian,
#FEB979,None,Eocene,
#FECFA7,None,Priabonian,
#FEC498,None,Bartonian,
#FEB98A,None,Lutetian,
#FEAE7D,None,Ypresian,
#FEAD6E,None,Paleocene,
#FEAD6E,None,Palæocene,
#FEAD6E,None,Palaeocene,
#FEC37D,None,Thanetian,
#FEC274,None,Selandian,
#FEB872,None,Danian,
#07CAEA,None,Mesozoic,
#6FC86B,None,Cretaceous,
#A6D468,None,Late Cretaceous,
#A6D468,None,Upper Cretaceous,
#F3F29C,None,Maastrichtian,
#EAED93,None,Campanian,
#DEE78A,None,Santonian,
#D1E382,None,Coniacian,
#C3DF79,None,Turonian,
#B5DA71,None,Cenomanian,
#7ECD74,None,Early Cretaceous,
#7ECD74,None,Lower Cretaceous,
#CDE5A8,None,Albian,
#BFE19F,None,Aptian,
#AFDD97,None,Barremian,
#9ED78E,None,Hauterivian,
#8DD285,None,Valanginian,
#7CCE7C,None,Berriasian,
#00BBE7,None,Jurassic,
#97E3FA,None,Late Jurassic,
#97E3FA,None,Upper Jurassic,
#CFF0FC,None,Tithonian,
#BDEBFB,None,Kimmeridgian,
#ABE7FB,None,Oxfordian,
#34D1EB,None,Mid Jurassic,
#34D1EB,None,Middle Jurassic,
#AEE6F0,None,Callovian,
#9CE2EF,None,Bathonian,
#87DEEE,None,Bajocian,
#6FDAED,None,Aalenian,
#00B7EA,None,Early Jurassic,
#00B7EA,None,Lower Jurassic,
#74D1F0,None,Toarcian,
#3CC9EF,None,Pliensbachian,
#07C1ED,None,Sinemurian,
#00BBEB,None,Hettangian,
#994E96,None,Triassic,
#C698C2,None,Late Triassic,
#C698C2,None,Upper Triassic,
#E8C2D8,None,Rhaetian,
#DDB4D1,None,Norian,
#D1A6C9,None,Carnian,
#BF7CB1,None,Mid Triassic,
#BF7CB1,None,Middle Triassic,
#D492BD,None,Ladinian,
#C986B6,None,Anisian,
#AD579A,None,Lower Triassic,
#AD579A,None,Early Triassic,
#C26AA5,None,Olenekian,
#B861A0,None,Induan,
#92C3A0,None,Palæozoic,
#92C3A0,None,Paleozoic,
#92C3A0,None,Palaeozoic,
#F7583C,None,Permian,
#FEAF97,None,Late Permian,
#FEAF97,None,Upper Permian,
#FEAF97,None,Lopingian,
#FEC6B3,None,Changhsingian,
#FEBBA5,None,Wuchiapingian,
#FE8367,None,Middle Permian,
#FE8367,None,Mid Permian,
#FE8367,None,Guadalupian,
#FEA38A,None,Capitanian,
#FE987E,None,Wordian,
#FE8E72,None,Roadian,
#F76E54,None,Early Permian,
#F76E54,None,Lower Permian,
#F76E54,None,Cisuralian,
#EF947F,None,Kungurian,
#EF8A74,None,Artinskian,
#EF806A,None,Sakmarian,
#F0775F,None,Asselian,
#3FAEAD,None,Carboniferous,
#8AC6C3,None,Upper Carboniferous,
#8AC6C3,None,Pennsylvanian,
#BDD0C4,None,Upper Pennsylvanian,
#CBD5CD,None,Gzhelian,
#BBD1CD,None,Kasimovian,
#9DCAC4,None,Middle Pennsylvanian,
#9DCAC4,None,Mid Pennsylvanian,
#AECDC4,None,Moscovian,
#77C2C3,None,Lower Pennsylvanian,
#8AC6C3,None,Bashkirian,
#619D7E,None,Lower Carboniferous,
#619D7E,None,Mississippian,
#BBC082,None,Upper Mississippian,
#C8C281,None,Serpukhovian,
#9BB983,None,Middle Mississippian,
#ABBC82,None,Visean,
#7AB284,None,Lower Mississippian,
#8AB584,None,Tournaisian,
#DD9651,None,Devonian,
#F4E0A9,None,Upper Devonian,
#F4E0A9,None,Late Devonian,
#F3EBCC,None,Frasnian,
#F4EAB9,None,Famennian,
#F6C87A,None,Middle Devonian,
#F6C87A,None,Mid Devonian,
#F5DE94,None,Givetian,
#F5D386,None,Eifelian,
#EFB063,None,Lower Devonian,
#EFB063,None,Early Devonian,
#ECCF87,None,Emsian,
#EEC57B,None,Pragian,
#EEC57B,None,Praghian,
#EEBA6E,None,Lochkovian,
#A6DFC5,None,Silurian,
#E4F2E6,None,Latest Silurian,
#E4F2E6,None,Pridoli,
#B4E5DB,None,Late Silurian,
#B4E5DB,None,Upper Silurian,
#B4E5DB,None,Ludlow,
#D4EEE6,None,Ludfordian,
#C3EAE6,None,Gorstian,
#A4E0D0,None,Middle Silurian,
#A4E0D0,None,Mid Silurian,
#A4E0D0,None,Wenlock,
#C5E9DB,None,Homerian,
#B6E4D0,None,Sheinwoodian,
#7ED7C6,None,Lower Silurian,
#7ED7C6,None,Early Silurian,
#7ED7C6,None,Llandovery,
#B4E5DB,None,Telychian,
#A4E0D0,None,Aeronian,
#93DBC6,None,Rhuddanian,
#00A98A,None,Ordovician,
#5ECCA9,None,Upper Ordovician,
#5ECCA9,None,Late Ordovician,
#95DABC,None,Hirnantian,
#81D6BC,None,Katian,
#72D0A9,None,Sandbian,
#00BD97,None,Middle Ordovician,
#00BD97,None,Mid Ordovician,
#35C9B2,None,Darriwilian,
#12C5A9,None,Dapingian,
#00AF89,None,Lower Ordovician,
#00AF89,None,Early Ordovician,
#00AF89,None,Tremadoc,
#00AF89,None,Ashgill,
#00BAA0,None,Floian,
#00B698,None,Tremadocian,
#81AA72,None,Cambrian,
#ADDDA8,None,Furongian,
#ADDDA8,None,Cambrian Series 4,
#ADDDA8,None,Series 4,
#E5F1D1,None,Cambrian Stage 10,
#E5F1D1,None,Stage 10,
#D8ECC6,None,Jiangshanian,
#D8ECC6,None,Cambrian Stage 9,
#D8ECC6,None,Stage 9,
#CAE7BC,None,Paibian,
#A1CF9B,None,Cambrian Series 3,
#A1CF9B,None,Series 3,
#A1CF9B,None,Middle Cambrian,
#A1CF9B,None,Mid Cambrian,
#CCDDB8,None,Guzhangian,
#BFD8AD,None,Drumian,
#B2D4A3,None,Cambrian Stage 5,
#B2D4A3,None,Stage 5,
#95C28F,None,Cambrian Series 2,
#95C28F,None,Lower Cambrian,
#95C28F,None,Series 2,
#B4CBA0,None,Cambrian Stage 4,
#B4CBA0,None,Stage 4,
#A5C697,None,Cambrian Stage 3,
#A5C697,None,Stage 3,
#8AB584,None,Terreneuvian,
#8AB584,None,Cambrian Series 1,
#8AB584,None,Series 1,
#A8BD93,None,Cambrian Stage 2,
#A8BD93,None,Stage 2,
#9ABA8B,None,Fortunian,
#9ABA8B,None,Cambrian Stage 1,
#9ABA8B,None,Stage 1,
#9FB885,None,Early Cambrian,
#FE5B71,None,Precambrian,
#FE4C68,None,Proterozoic,
#FEB757,None,Neoproterozoic,
#FED67B,None,Ediacaran,
#FECC6F,None,Cryogenian,
#FEC262,None,Tonian,
#FEB872,None,Mesoproterozoic,
#FED9A2,None,Stenian,
#FECE94,None,Ectasian,
#FEC386,None,Calymmian,
#FE5B71,None,Paleoproterozoic,
#FE5B71,None,Palaeoproterozoic,
#FE5B71,None,Palæoproterozoic,
#FE86A1,None,Statherian,
#FE7B94,None,Orosirian,
#FE7087,None,Rhyacian,
#FE657B,None,Siderian,
#FE007C,None,Archean,
#FEA6BA,None,Neoarchean,
#FE7CA3,None,Mesoarchean,
#FE5B97,None,Paleoarchean,
#FE5B97,None,Palæoarchean,
#FE5B97,None,Palaeoarchean,
#EE007D,None,Eoarchean,
#CB0381,None,Hadean,"""

TIMESCALE__USGS_ISC = """colour,width,component age
#99ADAC,None,Archaen,
#FA815F,None,Cambrian,
#98BBD9,None,Carboniferous,
#FFFF00,None,Cenozoic,
#80CFC9,None,Cisuralian,
#7FC21B,None,Cretaceous,
#DBAAA9,None,Cryogenian,
#9999C9,None,Devonian,
#7F8F8F,None,Eoarchaen,
#EBAE44,None,Eocene,
#9AD9D9,None,Guadalupian,
#FFFFB3,None,Holocene,
#4EB580,None,Jurassic,
#9858A8,None,Llandovery,
#B2E2ED,None,Lopingian,
#E87C72,None,Lower Cambrian,
#B1DE7E,None,Lower Cretaceous,
#807DBA,None,Lower Devonian,
#65BF91,None,Lower Jurassic,
#DE7CA3,None,Lower Ordovician,
#68B39F,None,Lower Triassic,
#CAA7D1,None,Ludlow,
#B2B5B0,None,Mesoarchaen,
#DEC38A,None,Mesoproterozoic,
#7FAD51,None,Mesozoic,
#E8AE97,None,Middle Cambrian,
#9A84BF,None,Middle Devonian,
#7FC993,None,Middle Jurassic,
#FA9BB1,None,Middle Ordovician,
#98D6BD,None,Middle Triassic,
#FFDD00,None,Miocene,
#7191AD,None,Mississippian,
#CACCC8,None,Neoarchaen,
#FCCB8B,None,Neogene,
#C9A595,None,Neoproterozoic,
#EBD9BC,None,NeoproterozoicIII,
#EBC773,None,Oligocene,
#FA82A6,None,Ordovician,
#997391,None,Paleoarchaen,
#EB9100,None,Paleocene,
#FFB300,None,Paleogene,
#B3B15F,None,Paleoproterozoic,
#81B5D6,None,Paleozoic,
#679FC9,None,Pennsylvanian,
#68C6DE,None,Permian,
#B3E3D1,None,Phanerozoic,
#FFEA61,None,Pleistocene,
#FFECAD,None,Pliocene,
#B38654,None,Precambrian,
#E8C5E1,None,Pridoli,
#CDD991,None,Proterozic,
#FFFF4D,None,Quaternary,
#B172B5,None,Silurian,
#CCA46C,None,Tonian,
#67C2B6,None,Triassic,
#FCCDB8,None,Upper Cambrian,
#DFF299,None,Upper Cretaceous,
#CABDDB,None,Upper Devonian,
#CCEBC5,None,Upper Jurassic,
#FAB4BD,None,Upper Ordivician,
#CCEDE2,None,Upper Triassic,
#B089B3,None,Wenlock,"""

TIMESCALE__DNAG = """colour,width,component age
#AAFF00,None,Aalenian,
#4CB319,None,Albian,
#66CC99,None,Anisian,
#80FF4C,None,Aptian,
#DE7038,None,Aquitanian,
#E1E1E1,None,Archean,
#AD4CB3,None,Arenigian,
#00A9E6,None,Artinskian,
#E6B3D1,None,Ashgillian,
#9EFA00,None,Bajocian,
#8FDB00,None,Barremian,
#DEA640,None,Bartonian,
#9BB2FF,None,Bashkirian,
#A3FF73,None,Bathonian,
#009C21,None,Berriasian,
#E6780D,None,Burdigalian,
#FFEDC7,None,Calabrain,
#E9FFBE,None,Callovian,
#FF8099,None,Cambrian,
#66CC33,None,Campanian,
#CC99B8,None,Caradocian,
#8FA8FF,None,Carboniferous,
#99CC99,None,Carnian,
#99E666,None,Cenomanian,
#FAFFA3,None,Cenozoic,
#E6B34C,None,Chattian,
#99E666,None,Coniacian,
#B3FF80,None,Cretaceous,
#B36600,None,Danian,
#8099FF,None,Devonian,
#EBB3B3,None,Dresbachian,
#828282,None,Early Archean,
#FFCCCC,None,Early Cambrian,
#99B3E6,None,Early Carboniferous,
#7DE34A,None,Early Cretaceous,
#9999FF,None,Early Devonian,
#D6B34C,None,Early Eocene,
#4CFF80,None,Early Jurassic,
#E6780D,None,Early Miocene,
#CC9933,None,Early Oligocene,
#CC6BD1,None,Early Ordovician,
#B36600,None,Early Paleocene,
#87E8FF,None,Early Permian,
#D98C00,None,Early Pliocene,
#E6CCCC,None,Early Proterozoic,
#CCB3FF,None,Early Silurian,
#66EBB3,None,Early Triassic,
#8080CC,None,Eifelian,
#8080E6,None,Emsian,
#EBCC80,None,Eocene,
#B3B3E6,None,Fammenian,
#EBB3B3,None,Franconian,
#9999CC,None,Frasnian,
#4C4CB3,None,Gedinnian,
#9999E6,None,Gevitian,
#9EBBD7,None,Gzelian Kasimovian,
#C4E300,None,Hauterivian,
#008519,None,Hettangian,
#FFFF29,None,Holocene,
#00E07A,None,Jurassic,
#BEE8FF,None,Kazanian,
#CCFFD4,None,Kimmeridgian,
#00C5FF,None,Kungurian,
#80E6B3,None,Ladinian,
#D97A00,None,Langhian,
#CCCCCC,None,Late Archean,
#FF99B3,None,Late Cambrian,
#80CCFF,None,Late Carboniferous,
#99FF66,None,Late Cretaceous,
#CCCCFF,None,Late Devonian,
#FFCC99,None,Late Eocene,
#CCFFCC,None,Late Jurassic,
#FFB35E,None,Late Miocene,
#E6B34C,None,Late Oligocene,
#FFCCEB,None,Late Ordovician,
#F2A640,None,Late Paleocene,
#BDEDFF,None,Late Permian,
#F2A60D,None,Late Pliocene,
#B39999,None,Late Proterozoic,
#EBCCFF,None,Late Silurian,
#CCFFEB,None,Late Triassic,
#C791D9,None,Llandeilan,
#9980CC,None,Llandoverian,
#A16BB3,None,Llanvirnian,
#B899CC,None,Ludlovian,
#C48C26,None,Lutetian,
#80CC4C,None,Maastrichtian,
#CFFFB5,None,Mesozoic,
#F29E52,None,Messinian,
#B2B2B2,None,Middle Archean,
#EB8099,None,Middle Cambrian,
#B3B3FF,None,Middle Devonian,
#EBB34C,None,Middle Eocene,
#80FF99,None,Middle Jurassic,
#FC9E00,None,Middle Miocene,
#E3ADF5,None,Middle Ordovician,
#998080,None,Middle Proterozoic,
#99FFCC,None,Middle Triassic,
#FFC780,None,Miocene,
#91B3E6,None,Mississippian,
#BED2FF,None,Moscovian,
#66CC33,None,Neocomian,
#FFD96E,None,Neogene,
#B3E6B3,None,Norian,
#FFCC66,None,Oligocene,
#FF80E6,None,Ordovician,
#D3FFBE,None,Oxfordian,
#FFB34C,None,Paleocene,
#FFEDC7,None,Paleogene,
#E3E3FF,None,Paleozoic,
#80CCFF,None,Pennsylvanian,
#C4FFFF,None,Permian,
#F2A60D,None,Piacenzian,
#FFFAA8,None,Pleistocene,
#19CC4C,None,Pliensbachian,
#FFB300,None,Pliocene,
#999966,None,Precambrian,
#FFCC99,None,Priabonian,
#D1B3E6,None,Pridolian,
#CCB3B3,None,Proterozoic,
#FFFF8C,None,Quaternary,
#CC9933,None,Rupelian,
#009CB3,None,Sakmarian Asselian,
#66E633,None,Santonian,
#33B880,None,Scythian,
#F2A640,None,Selandian,
#80B3E6,None,Serpukhovian,
#F29400,None,Serravallian,
#6666CC,None,Siegenian,
#B380FF,None,Silurian,
#4CE600,None,Sinemurian,
#D4F7FF,None,Tatarian,
#FFD900,None,Tertiary,
#FFA673,None,Thanetian,
#00FCA3,None,Tithonian,
#33E666,None,Toarcian,
#E89C14,None,Tortonian,
#CCE6EB,None,Tournaisian,
#CC66B3,None,Tremadocian,
#EBB3B3,None,Trempealeauan,
#66FFCC,None,Triassic,
#80E64C,None,Turonian,
#4CE6E6,None,Ufimian,
#85B000,None,Valanginian,
#B3CCEB,None,Visean,
#B399E6,None,Wenlockian,
#D6B34C,None,Ypresian,
#D98C00,None,Zanclean,"""

LEXICON = {'lithology': [r'overburden', r'sandstone', r'siltstone', r'shale',
                         r'mudstone', r'limestone', r'dolomite',
                         r'salt', r'halite', r'anhydrite', r'gypsum',
                         r'sylvite',
                         r'clay', r'mud', r'silt', r'sand', r'gravel',
                         r'boulders',
                         ],
           'amount': [r'streaks?', r'veins?', r'stringers?',
                      r'interbed(?:s|ded)?',
                      r'blotch(?:es)?', r'bands?', r'fragments?',
                      r'impurit(?:y|ies)',
                      r'minor', r'some', r'abundant', r'rare', r'flakes?',
                      r'[-\.\d]+%'
                      ],
           'grainsize': [r'vf(?:-)?', r'f(?:-)?', r'm(?:-)?', r'c(?:-)?',
                         r'vc',
                         r'very fine(?: to)?', r'fine(?: to)?',
                         r'medium(?: to)?', r'coarse(?: to)?', r'very coarse',
                         r'v fine(?: to)?', r'med(?: to)?', r'med.(?: to)?',
                         r'v coarse',
                         r'grains?', r'granules?', r'pebbles?', r'cobbles?',
                         r'boulders?',
                         ],
           'colour': [r"red(?:dish)?",
                      r"gray(?:ish)?",
                      r"grey(?:ish)?",
                      r"black(?:ish)?",
                      r"whit(?:e|ish)",
                      r"blu(?:e|ish)",
                      r"purpl(?:e|ish)",
                      r"yellow(?:ish)?",
                      r"green(?:ish)?",
                      r"brown(?:ish)?",
                      r"light", "dark",
                      r"sandy"
                      ],
           'synonyms': {'Overburden': ['Drift'],
                        'Anhydrite': ['Gypsum'],
                        'Salt': ['Halite', 'Sylvite'],
                        },
           'splitters': [' with ',
                         ' contain(?:s|ing) ',
                         '\. ',
                         ],
           'parts_of_speech': {'noun': ['lithology'],
                               'adjective': ['colour', 'grainsize'],
                               'subordinate': ['amount'],
                               },
           'abbreviations': {"gt": "gritty", "dist": "distillate", "gr": "grained", "LSD": "legal subdivision", "ptg": "parting", "alg": "algal", "mnr": "minor", "Assem": "Assem", "Vad": "vadose", "MCW": "mud cut water", "Pch": "patch", "gd": "good", "/": "with", "ga": "gauged", "bulb": "bulbous", "Var": "variation", "gn": "green", "alt": "altering", "Gil": "gilsonite", "Oyst": "oyster", "sch": "schist", "Clst": "claystone", "ves": "vesicular", "Nod": "nodules", "tt": "tightly", "V.P.S.": "very poor sample V.P.S.", "asph": "asphaltic", "SIP": "shut in pressure", "tn": "tan", "G&OCM": "gas and oil cut mud", "DI": "dual induction log", "Mol": "mollusca", "Inoc": "inoceramus*", "spec": "speckled", "@": "at", "Amph": "amphipora*", "vert": "vertical", "lrg": "larger", "md": "muddy", "wthrd": "weathered", "Brec": "breccia", "D & A": "dry and abandoned", "fau": "fauna", "depau": "depauperate", "shad": "shadow", "DF": "derrick floor", "gy": "gray", "Elev": "elevation", "indst": "indistinct", "Syring": "syringopora*", "fac": "faceted", "GL": "guard log", "brhg": "branching", "Gt": "grit", "Gr": "grains", "FIt": "fault", "Tas": "tasmanites*", "Spr": "spore", "fenst": "fenestral", "plag": "plagioclase", "p": "poorly", "Spk": "speck", "Spl": "sampole", "SNP": "sidewall neutron porosity log", "n.s.": "no sample", "Clcar": "calcarenite", "pbl": "pebble (4-64 mm)", "cmt": "cemented", "Spg": "sponge", "Grv": "gravel", "Cyp": "cypridopsis*", "Grt": "granite", "SP": "spontaneous potential", "Res": "residue", "Bioh": "bioherm", "Biost": "biostrom", "tex": "texture", "Brach": "brachiopod", "hydc": "hydrocarbon", "Ren": "renalcis*", "Biot": "biotite", "Peld": "pelletoid", "Bld": "boulder", "ter": "terriginous", "splty": "splintery", "acic": "acicular", "sug": "sugary", "bdd": "bedded", "bdg": "bedding", "gl": "glassy", "abd": "abundant", "Intst": "intersticies", "Micr": "micrite", "O str": "Ostracod", "Clcsp": "calcisphere", "bl": "bluish", "abs": "absent", "abt": "about", "conspic": "conspicuous", "Spfool": "superficial olite", "sli": "slightly", "med": "medium", "O&SW": "oil and salt water", "biocl": "bioclastic", "Agg": "aggregate", "DST": "drill stem test", "Mn": "manganese", "psdo": "pseudo", "len": "lentilcular", "rug": "rugosa", "Wd": "wood", "hkl": "hackly", "DLL": "dual laterolog", "t.s.": "thin section", "Mtrx": "matrix", "crpxln": "crystocrystalline", "Zn": "zone", "Anthr": "anthracite", "altg": "alternating", "blksh": "blackish", "bor": "boreding", "dru": "drusy", "ctd": "coated", "Conc": "concretion", "wtr cush": "water cushion", "ctc": "contact", "micropor": "microporosity", "Zr": "zircon", "Cono": "conodont", "sft": "soft", "Piso": "pisoid", "LL": "laterolog", "lmn": "limonitic", "volc": "volcanics", "Ctgs": "cuttings", "apr": "apparent", "tr": "trace", "app": "appear", "brt": "bright", "ls": "limestone", "Slt": "silt", "Circ": "circulate", "aph": "aphanitic", "oomol": "oomoldic", "brk": "brackish", "vit": "vitreous", "org": "organic", "n.v.p.": "no visible porosity", "w/": "with", "brd": "bored", "intxln": "intercrystalline", "Para": "paraparchites*", "Fp": "flowing pressure", "Ft": "foot", "perf": "perforated", "&": "and", "fen": "fenestraal", "pred": "predominantly", "Phlog": "phloaopite", "perm": "permeability", "fibr": "fibrous", "msm": "metasomatic", "cht": "chert", "Fe": "iron-ferruginous", "dns": "denser", "vi": "violet", "fros": "frosted", "calc": "calcitareous", "Fm": "formation", "pres": "preservation", "cntrt": "contorted", "wvy": "wavy", "vps": "very poor samples", "ooc": "oocastic", "musc": "muscovite", "glas": "glassy", "Sh": "shale", "lchd": "leached", "rhb": "rhombic", "glau": "glauconitic", "Brac": "brachiopod", "choc": "chocolate", "chit": "chitinous", "Str": "structure", "Sl": "slate", "clus": "cluster", "Sa": "salt", "Cmt": "cement", "lmpy": "lumpy", "Sd": "sand", "intrapar": "intraparticle", "phos": "phosphatic", "prly": "pearly", "Lstr": "lustre", "tns": "tension", "f": "finely", "fls": "flesh", "des": "descript", "SW": "salt water", "flt": "faulted", "Cbl": "cobble", "plty": "platy", "lithgr": "lithographic", "flk": "flake", "W.R.": "washed residue", "SO": "show of oil", "v": "very", "deb": "debris", "slty": "silty", "fld": "feldsparthic", "flg": "flaggy", "ptch": "patches", "Lig": "lignite", "mica": "micaeous", "bent": "bentonitic", "Min": "mineral", "sy-Ca": "sparry calcite", "Lim": "limonite", "Invtb": "invertebrate", "sps": "sparsly", "Mid": "middle", "yelsh": "ish", "sph": "spherules", "spl": "sample", "Ls": "limestone", "tab": "tabular", "Plcy": "palecypod", "scat": "scattered", "psool": "pseudo oolitic", "GR": "gamma ray", "spsly": "sparsly", "Bdeye": "birdseye", "purp": "purple", "Pyr": "pyrite", "hom": "homogeneous", "Kao": "kaolin", "Spic": "spicule", "hor": "horizontal", "Belm": "belemnites*", "sid": "sideritic", "aft": "after", "Rhb": "rhomb", "Typ": "type", "sim": "similar", "sil": "siliceous", "frag": "fragmental", "lam": "laminated", "fr": "fair", "mar": "maroon", "frac": "fractured", "srt": "sorting", "Dol": "dolomite", "I.P.": "in part", "cpct": "compact", "max": "maximum", "insl": "insoluble", "lac": "lacustrine", "Mrl": "marl", "mag": "magnetic", "Ctc": "contact", "ireg": "irregular", "lav": "lavender", "IAB": "initial air blow", "fl": "filled", "Tril": "trilobite", "Foram": "foraminifera", "MMCFG": "million cubic feet of gas", "Clvg": "cleavage", "Alg": "algal", "sp": "spotty", "Deer": "decrease", "Microspr": "microspar", "su": "sulphurous", "or": "orangish", "strk": "streaked", "stri": "striated", "sh": "shale", "Moll": "mollusc", "spkld": "speckled", "sm": "smooth", "sl": "slightly", "sc": "scales", "sb": "sub", "sa": "salt", "strg": "stringer", "Trip": "tripoli", "Equiv": "equivalent", "lse": "loose", "mnut": "minute", "BHCS": "bore hole compensated sonic", "Cal": "caliper", "Chk": "chalk", "Biomi": "biomicrite", "brit": "brittle", "coln": "colonial", "Smwt": "somewhat", "Rf": "reef", "Cht": "chert", "(D)": "development", "decr": "decreasing", "Rk": "rock", "RT": "rotary table", "fis": "fissile", "cln": "clean", "xl": "crystalline", "cbl": "cobble (64-256 mm)", "Aglm": "agglomerate", "Evap": "evapourite", "sa-c": "salt castic", "fib": "fibrous", "imp": "impression", "lt": "lighter", "eux": "euxinic", "cren": "crenulated", "gty": "gravity", "dess": "dessiccation", "clr": "clear", "TSTM": "too small to measure", "Bas": "basalt", "Shw": "show", "nod": "nodule", "uncons": "unconsolidated", "rexl": "recrystallization", "Cav": "cavernous", "FAB": "fair air blow", "aprox": "approximately", "\u20b5": "core", "Schm": "schist", "Shl": "shell", "xln": "crystalline", "Rad": "radial", "Oomol": "oomold", "Dist": "distillate", "extr": "extremely", "l": "lower", "Anhy": "anhydrite", "intv": "interval", "Stach": "stachyodes*", "crpxl": "cryptocrystalline", "Poln": "pollen", "Chtz": "chitinozoa", "MCFG": "thousand cubic feet of gas", "frmwk": "framework", "Lith": "lithology", "Macrofos": "macrofossil", "prphy": "porphyry", "Lut": "lutite", "OFM": "oil flecked mud", "Asph": "assemblage", "intpar": "interparticle", "Perm": "permeability", "Bdst": "boundstone", "chty": "cherty", "meta": "metamorphic", "ex": "excellent", "hrtl": "horizontal", "p-p": "pin point", "zeo": "zeolite", "n/s": "no show", "nac": "nacerous", "Wtr": "water", "apprx": "approximate", "rr": "rare", "Musc": "muscovite", "intclas": "intraclastic", "rep": "replacedment", "porcel": "porcelaneous", "BOPH": "barrels of oil per hour", "rd": "rounded", "rf": "reefoid", "sml": "small", "blk": "black", "IP": "initial production", "bld": "bladed", "Tub": "tube", "Pisol": "pisolite", "mtx": "matrix", "lmy": "limy", "Phos": "phosphate", "crd": "cored", "G": "gas", "Spo": "spore", "GCM": "gas cut mud", "SGCM": "slight gas cut mud", "OWWO": "old well worked over", "Novac": "novaculite", "rhmb": "rhombic", "argl": "argillate", "W": "west", "carb": "carbonaceous", "Frac": "fracture", "freq": "frequent", "ES": "electric", "Pyrxn": "pyroxene", "g": "good", "Contam": "contamination", "srtg": "Sorteding", "Chal": "chalcedony", "fspr": "feldsparathic", "Char": "charophyte", "SSO": "slight show of oil", "Hyde": "hydrocarbon", "w": "well", "intgn": "inter grown", "vrtb": "vertebrate", "Sphal": "sphalerite", "intpt": "interpretation", "cche": "caliche", "Frg": "fringe", "sacc": "saccharoidal", "onc": "oncolites", "Slick slick": "slickenside", "Diagn": "diagenesis", "zn": "zone", "Imp": "impression", "sblit": "sublithic", "Prod": "production", "Incl": "inclusion", "Frag": "fragment", "sphal": "sphalerite", "Iran": "granule", "dtrl": "detritalus", "wthd": "weathered", "WCM": "water cut mud", "GCW": "gas cut water", "Pet": "petroleum", "Microstyl": "microstylolite", "Volc": "volcanic", "BWPH": "barrels of water per hour", "thru": "throughout", "intcl": "intraclasts", "Biosp": "biosparite", "Girv": "girvanella*", "OWDD": "oil well drilled deeper", "consol": "consolidated", "Fus": "fusulinid", "sz": "size", "grysh": "greyish", "mrlst": "marlstone", "Strk": "streak", "SGCW": "slight gas cut water", "crnk": "crinkled", "Rbl": "rubble", "Fuc": "fucoid", "bdeye": "birdseye", "gyp": "gypsumiferous", "orng": "orange", "Endo": "endothyra*", "BHFP": "bottom hole flow pressure", "Xl": "crystal", "stn": "staining", "Qtz": "quartz", "csg": "casing", "Chlor": "chlorite", "r": "rare", "mky": "milky", "str": "streak", "Onc": "oncolite", "Btm": "bottom", "Slst": "siltstone", "dissem": "disseminated", "spr": "sparry", "Pap": "paper", "grnt": "granite", "Par": "particle", "ang": "angular", "Descr": "description", "intgwn": "intergrown", "Stylio": "styliolina*", "Intclas": "intraclast", "Rem": "remains", "chlor": "chlorite", "euhd": "euhedral", "Pend": "pendularous", "Rec": "recovery", "grnl": "granule (2-4 mm)", "Calc": "calcite", "p.d": "pressure deformation", "recem": "recemented", "strgr": "stringer", "lig": "lignitic", "Glauc": "glauconite", "intbd": "interbedded", "lim": "itic", "mic": "micro", "Db": "diabase", "Port por": "porosity", "Ech": "echinoid", "lit": "lithic", "Fluor": "fluoresceince", "vrvd": "varved", "Arag": "aragonite", "vgt": "varigated", "Clus": "cluster", "mot": "mottled", "surf": "surface", "pos": "possibility", "plas": "plastic", "pyr": "pyritized", "In": "inch", "kao": "kaolin", "Orbit": "Orbitolina", "MLL": "microlaterolog", "sdy": "sandy", "Mic": "micaceous", "Plt": "plant", "assoc": "associated", "rthy": "earthy", "Ivan": "ivanovia*", "suc": "sucrosic", "intercal": "intercalated", "glos": "glossy", "typ": "typical", "abv": "above", "MCO": "mud cut oil", "Unconf": "unconformity", "Bent": "bentonite", "dol": "dolomitic", "dom": "dominant", "flor": "fluorescence", "sltst": "siltstone", "brec": "brecciated", "Stri": "striae", "dism": "disseminated", "BHT": "bottom hole temperature", "exv": "extrusive", "Pol": "polish", "GTS": "gas to surface", "Mbr": "member", "exp": "exposed", "Pybit": "pyrobitumen", "a.a.": "same as above sample", "intlam": "interlaminated", "sd": "sand (1/16-2 mm)", "Rpl": "ripple", "dend": "dendritic", "pkr": "packer", "drlg": "drilling", "Spher": "spherule", "Hal": "halitiferous", "lstr": "lustre", "Exclas": "extraclast", "ML": "microlog, minilog", "anhy": "anhydritic", "drlr": "driller", "Rud": "rudist", "grapst": "grapestone", "Bubl": "bubble", "pris": "prismatic", "Bnd": "band", "och": "ochre", "spher": "spherulitic", "Jt": "joint", "occ": "occasional", "Wl": "well", "varic": "varicolored", "intrlam": "interlaminated", "O&G": "oil and gas", "mnrl": "mineralized", "Shlt por": "shelter porosity", "AOF": "absolute open flow", "Gyp": "gypsumiferous", "Bit": "bitumen", "Gast": "gastropod", "Pst": "pumice-stone", "PB": "plugged back", "Stromlt": "stromatolite", "BO": "barrels of oil", "dk": "darker", "CN": "compensated neutron", "KB": "kelly bushing", "dd": "dead", "Intvl": "interval", "stromlt": "stromatolite", "Fspr": "feldspar", "Milid": "miliolid", "cotg": "coateding", "cotd": "coateding", "repl": "replacement", "slily": "slightly", "struc": "structure", "SO&G": "show of oil and gas", "gen": "generally", "hetr": "heterogeneous", "crs": "coarse", "bar": "baritic", "bas": "basaltic", "(W)": "wildcat", "shy": "shaly", "FDL": "formation density log", "w/o": "without w/o", "BW": "barrels of water", "rsns": "resinous", "PL": "proximity log", "gran": "granular", "BWPD": "barrels of water per day", "x": "cross", "grad": "grading", "Qtzt": "quartzite", "crm": "cream", "res": "residuual", "Pt": "part", "OTD": "old total depth", "contam": "contaminated", "S.W.C.": "sidewall core", "qtz": "quartz", "magnt": "magnetite", "Pel": "pellet", "num": "numerous", "sec": "secondary", "fnly": "finly", "arg": "argillaceous", "ark": "arkosic", "rmn": "remainant", "prim": "primary", "volat": "volatile", "SOCW": "slight oil cut water", "piso": "pisolitic", "pkish": "pinkish", "metaph": "metamorphosed", "trnsp": "transparent", "irr": "irregular", "hornbd": "hornblend", "'' or do": "ditto", "biost": "biostromal", "gept": "geopetal", "trnsl": "translucent", "PD": "per day", "PH": "per hour", "SO&W": "show of oil and water", "Vnlet": "veinlet", "Tham": "thamnopora*", "wg": "vuggy", "C": "coal", "men": "meniscus", "exclas": "extraclastic", "lg": "long", "jt": "jointing", "comp": "completion", "gnsh": "greenish", "wk": "weak", "wi": "with", "wh": "white", "Exv": "extrusive rock", "S": "sonic, acoustilog", "magn": "magnetic", "gywk": "graywacke", "G.W.": "granite wash", "Satm sat": "saturation", "tub": "tubular", "tuf": "tuffaceous", "coq": "coquina", "vug": "vugular", "c": "coarsely", "fnt": "faintly", "dkr": "darker", "cov": "covered", "conch": "conchoidal", "intgran": "intergranular", "SI": "shut in", "Chit": "chitinous", "s": "small", "Meta": "metamorphic rock", "Sst": "sandstone", "brak": "brackish", "uni": "uniform", "com": "common", "cotd gn": "coated grains", "Het": "Heterostegina", "foram": "foraminiferal", "chky": "chalky", "cl": "clastic", "cb": "carbonized", "Glas": "glass", "rad": "radiating", "poly": "polygonal", "hvy": "heavy", "pol": "polished", "Pent": "pentamerus*", "Hem": "hematite", "tgh": "tough", "cp": "compare", "Surf": "surface", "ps": "pseudo-", "frg": "fringing", "pt": "partly", "Bur": "burrow", "fri": "friable", "blsh": "bluish", "pch": "patchy", "stmg": "streaming", "frs": "fresh", "skel": "skeletal", "pyrbit": "pyrobitumen", "pk": "pink", "devit": "devitrified", "authg": "authigenic", "pl": "plant", "cly": "clayey", "t.b.": "thin-bedded", "Tr": "trace", "IES": "induction electric", "WAB": "weak air blow", "lge": "large", "spic": "spicular", "psi": "pounds per square inch", "crbnt": "carbonate", "Tp": "top", "Pkst": "packstone", "Sedm": "sediment", "Cont": "content", "xbdg": "cross-bedding", "gns": "gneiss", "micgr": "micrograined", "Cl": "clay", "slt": "silt", "vcol": "varicolored", "undly": "underlying", "grnt.w": "granite wash", "n": "no, none, non", "contm": "contaminated", "sln": "solution", "rbl": "rubblbly", "fuc": "fucoidal", "Intr": "intrusive", "cvg": "cavings", "k": "permeabilityable", "slb": "slabby", "FTAB": "faint air blow", "DIL": "dual induction laterolog", "pyrcl": "pyroclastic", "cons": "considerable", "rndd": "rounded", "bot": "botryoidal", "Sel": "selenite", "vn": "vein", "Tf": "tuffaceous", "styl": "stylotitic", "conc": "concretionary", "mott": "mottled", "xlam": "cross-laminated", "x-strat": "cross-stratified", "Strom": "stromatoporoid", "ig": "igneous", "pap": "papery", "incr": "increasing", "litt": "littoral", "intstl": "interstitial", "bioturb": "bioturbated", "PPM": "parts per million", "GAP": "good air blow", "Repl": "replaced", "lith": "lithographic", "elong": "elongate", "Chara": "charophytes", "sat": "saturated", "incl": "inclusion", "Coq": "coquina", "Vug": "vug", "Cor": "coral", "intst": "intersticitial", "cncn": "concentric", "rng": "range", "orth": "orthoclase", "rdsh": "redish", "syn": "syntaxial", "Microfos": "microfossilferous", "phr": "phreatic", "Wkst": "wackestone", "pisol": "pisolitic", "Col": "color", "Jasp": "jasper", "Mat": "material", "Mbl": "marble", "intxl": "intercrystalline", "detr": "detrital", "sed": "sedimentary", "x-bd": "cross-bedded", "gsy": "grasy", "OWPB": "oil well plugged back", "min": "mineralized", "Sol": "Soution", "Vn": "vein", "col": "colored", "x-lam": "cross-laminated", "thn": "thin", "thk": "thick", "fltg": "floating", "Ig": "igneous rock", "imbd": "imbedded", "ck": "choke", "BHP": "bottom hole pressure", "yel": "yellow", "Orth": "orthoclase", "sptd": "spottedy", "spty": "spottedy", "Sphaer": "sphaerocodium*", "Pbl": "pebble", "intfrag": "interfragmental", "Scaph": "scaphopod", "resd": "residual", "Bd": "bed", "Fe-mag": "ferro-magnesian", "sks": "slickensided", "rexlzd": "recrystallized", "Bm": "basement", "Glob": "globigerina*", "elg": "elongate", "unident": "unidentifiable", "Fau": "fauna", "Gal": "galeolaria*", "cub": "cubic", "Fac": "facet", "Glos": "gloss", "Gab": "gabbro", "bnd": "banded", "Oo": "ooid", "Gns": "gneiss", "amb": "amber", "strat": "strataified", "amm": "ammonite", "vis": "visible", "mos": "mosaic", "por": "poroussity", "uncons.": "unconsolidated", "embd": "embedded", "Dia": "diameter", "rnd": "rounded", "sbang": "subangular", "cntr": "centered", "mol": "moldic", "Cvg": "caving", "bit": "bitumeninous", "Micropor": "micropore", "S.W.": "salt water", "amt": "amount", "mod": "moderate", "Crin": "crinoidal", "Lyr": "layer", "brn": "brown", "boudg": "boudinage", "OC": "oil cut", "Microol": "micro-oolite", "Ltl": "little", "V.op": "valve open", "amor": "amorphous", "Ark": "arkose", "clas": "clastic", "Psool": "pseudo oolite", "Strat": "strata", "Bdg": "bedding", "bri": "bright", "drsy": "drusy", "tstg": "testing", "Scol": "scolecodonts", "crpld": "crumpled", "SOCM": "slight oil cut mud", "rec": "recovered", "Fvst": "favosites*", "sbrndd": "sub rounded", "p.p.": "pin-poin", "HO": "heavy oil", "olv": "olive", "Mdst": "mudstone", "s & p": "salt and pepper", "venn": "vermillon", "u": "upper", "gvl": "gravel", "fos": "fossiliferous", "pet": "petroleumiferous", "Clclt": "calcilutite", "OSR": "oil source rock", "Len": "lens", "pel": "pellet", "circ": "circulation", "prom": "prominently", "fol": "foliated", "peld": "pelletoidal", "Tent": "tentaculites*", "prob": "probably", "bd": "bed", "flky": "flaky", "bf": "buff", "LL8": "laterolog-8", "cgl": "conglomerate", "Gwke": "graywacke", "slky": "silky", "Grap": "graptolite", "Bor": "bored", "bo": "bophaceous", "Bot": "botryoid", "phen": "phenocrysts", "posa": "possible", "bu": "buff", "sel": "selenite", "Gran": "granule", "r.f.p": "rounded frosted pitted", "Clslt": "calcisiltite", "ss": "sandstone", "Uc": "underclay", "oo": "ooidal", "GOR": "gas-to-oil ratio", "Clcrd": "calcirudite", "euhed": "euhedral", "Solen": "solenopora*", "Euryamph": "euryamphipora*", "Ptg": "parting", "od": "odor", "eqnt": "equant", "Ost": "ostracod", "o": "oil", "Ceph": "cephalopod", "irid": "iridescent", "ox": "oxidized", "Casph": "calcisphaera*", "ti": "tight", "Foss": "fossiliferous", "sept": "septate", "marn": "marine", "Scs": "scarce", "op": "open", "chk": "chalky", "ahd": "anhedral", "Fen": "fenestra", "qtzc": "quartzitic", "sol": "solitary", "corln": "coralline", "mas": "massive", "ferr": "ferruginous", "Cub": "cube", "intr": "intrusionive", "Chaet": "chaetetes*", "OCM": "oil cut mud", "qtzs": "quartzose", "qtzt": "quartzite", "GIP": "good initial puff", "loc": "location", "blky": "blocky", "phyl": "phyllitic", "vrtl": "vertical", "Ooc": "oolicast", "anhed": "anhedral", "aren": "arenaceous", "Ool": "oolite", "bioh": "biohermal", "diagn": "diagenesisetic", "Pelec": "pelecypod", "biot": "biotite", "abnt": "abundant", "var": "variable", "hem": "hematitic", "gil": "gilsonite", "calctc": "calcitic", "clyst": "claystone", "fl/": "flowing", "bur": "burrowed", "ea": "earthy", "micr": "micritic", "grdg": "grading", "Flk": "flake", "hi": "high", "s&p": "salt & pepper", "Flo": "flora", "Deb": "debris", "Splin": "splintery", "hd": "hard", "coqid": "coquinaoid", "Grst": "grainstone", "Phyl": "phyllite", "med.": "medium", "microxln": "microcrystalline", "Plag": "plagioclase", "mat": "material, matter", "bldr": "boulder", "up": "upper", "Tex": "texture", "mdy": "muddy", "WIP": "weak initial puff", "olvn": "olivine", "ab": "above", "mrl": "marly", "orsh": "orangish", "Allo": "allochem", "m": "medium", "deer": "decreasing", "chal": "chalcedony", "ovgth": "overgrowth", "ap": "appears", "Sid": "siderite", "ind": "indurated", "pit": "pitted", "trip": "tripolic", "DL": "density log", "Sil": "silica", "Lam": "laminations", "F.Q.G.": "frosted quartz  grains", "Cgl": "conglomerate", "hex": "hexagonal", "wxy": "waxy", "gry": "greyish", "Fe-st": "ironstone", "oom": "oomoldic", "grd": "graded", "BHSIP": "bottom hole shut in pressure", "Mag": "magnetite", "ool": "oolitic", "Lat": "laterite", "mass": "massive", "T.D.": "total depth", "Stn": "stain", "sqz": "squeezed", "E": "east", "BOPD": "barrels of oil per day", "aglm": "agglomerate", "evap": "evapourititic", "fluor": "fluoresceincent", "est": "estimated", "Su": "sulphur", "lent": "lenticular", "stal": "stalactitic", "N": "Neutron", "wtr": "water", "dolst": "dolostone", "bcm": "becoming", "OTS": "oil to surface", "SAB": "strong air blow", "Bry": "bryozoa", "O-Qtz": "orthoquartzite", "Styl": "stylolite", "crinal": "crinoidal", "Brk": "break", "mrly": "marly", "Av": "average", "xbd": "cross-bedded", "Radax": "radiaxial", "swbd": "swabbed"}
           }
