# 📝 Custom Prompts Guide

DRommage поддерживает полностью настраиваемые промпты для анализа коммитов! Теперь можно создавать специализированные анализы для любых нужд.

## 🎯 Встроенные категории промптов

### **General** (общие)
- `brief_default` - стандартный краткий анализ
- `deep_default` - стандартный глубокий анализ

### **Security** (безопасность)
- `brief_security` - краткий анализ безопасности
- `deep_security_audit` - полный аудит безопасности

### **Performance** (производительность)
- `brief_performance` - анализ производительности

### **Architecture** (архитектура)
- `brief_architecture` - архитектурный анализ

### **Quality** (качество кода)
- `deep_code_review` - детальное code review

### **Business** (бизнес)
- `deep_business_impact` - анализ бизнес-влияния

## 🚀 Использование через CLI

### **Список всех промптов:**
```bash
drommage prompts list
```

### **Промпты по категориям:**
```bash
drommage prompts list --category=security
drommage prompts categories
```

### **Детали конкретного промпта:**
```bash
drommage prompts show --name=brief_security
```

### **Анализ с кастомным промптом:**
```bash
# Использовать предустановленный промпт
drommage analyze --commit=HEAD --prompt=brief_security

# Анализ нескольких коммитов с security focus
drommage analyze --last=5 --prompt=deep_security_audit --format=json

# Комбинирование с провайдерами
OPENAI_API_KEY=xxx drommage analyze --prompt=deep_code_review --commit=HEAD
```

## 🛠️ Создание собственных промптов

### **1. Структура промпта:**
```json
{
  "name": "my_custom_prompt",
  "description": "Описание промпта",
  "category": "custom",
  "variables": ["commit_hash", "message", "files_changed"],
  "template": "Проанализируй коммит {commit_hash}:\n{message}\n..."
}
```

### **2. Доступные переменные:**
- `{commit_hash}` - короткий хеш коммита (8 символов)
- `{commit_hash_full}` - полный хеш коммита
- `{message}` - сообщение коммита
- `{author}` - автор коммита
- `{date}` - дата коммита
- `{files_changed}` - количество измененных файлов
- `{insertions}` - количество добавленных строк
- `{deletions}` - количество удаленных строк
- `{total_changes}` - общее количество изменений

### **3. Добавление промптов:**
```bash
# Скопировать примеры
cp example_custom_prompts.json .drommage/prompts.json

# Или редактировать вручную
nano .drommage/prompts.json
```

## 🎨 Примеры специализированных промптов

### **Security Focus:**
```json
{
  "name": "security_owasp",
  "category": "security",
  "template": "🔒 Анализ безопасности по OWASP Top 10:\n\nКоммит: {commit_hash} - {message}\nИзменения: {files_changed} файлов (+{insertions}/-{deletions})\n\nПроверь на уязвимости:\n1. Injection (A03)\n2. Broken Authentication (A07)\n3. Sensitive Data Exposure (A02)\n4. Security Misconfiguration (A05)\n\nОцени риск: LOW/MEDIUM/HIGH"
}
```

### **Performance Focus:**
```json
{
  "name": "performance_analysis",
  "category": "performance", 
  "template": "⚡ Анализ производительности:\n\nКоммит: {commit_hash} - {message}\n\nПроверь влияние на:\n- Алгоритмическую сложность\n- Использование памяти\n- Сетевые запросы\n- Кэширование\n- Загрузку базы данных\n\nВердикт: УЛУЧШАЕТ/НЕЙТРАЛЬНО/УХУДШАЕТ производительность"
}
```

### **Business Impact:**
```json
{
  "name": "business_value",
  "category": "business",
  "template": "💼 Бизнес-анализ изменения:\n\nКоммит: {message}\nАвтор: {author}\n\nОцени:\n1. Ценность для пользователей\n2. Влияние на выручку\n3. Операционные улучшения\n4. Конкурентные преимущества\n5. Риски для бизнеса\n\nROI: ВЫСОКИЙ/СРЕДНИЙ/НИЗКИЙ"
}
```

## 🔧 Настройка провайдеров с кастомными промптами

### **В providers.json:**
```json
{
  "name": "security_focused_llm",
  "type": "ollama",
  "model": "mistral:latest",
  "prompts": {
    "brief": "brief_security",
    "deep": "deep_security_audit"
  }
}
```

Теперь этот провайдер всегда будет использовать security-фокусированные промпты!

## 📊 Практические применения

### **Для команд разработки:**
```bash
# Security team проверяет все коммиты
drommage analyze --last=20 --prompt=deep_security_audit --format=json > security_report.json

# Frontend team анализирует UX изменения  
drommage analyze --prompt=frontend_ux_impact --commit=HEAD

# DevOps team проверяет операционное влияние
drommage analyze --prompt=devops_deployment_impact --last=10
```

### **Для code review:**
```bash
# Детальное техническое ревью
drommage analyze --prompt=deep_code_review --commit=feature-branch-head

# Архитектурный анализ больших изменений
drommage analyze --prompt=architecture_impact --last=50 --format=json
```

### **Для продуктовых команд:**
```bash
# Анализ бизнес-ценности фичей
drommage analyze --prompt=business_value --commit=release-tag

# Оценка пользовательского опыта
drommage analyze --prompt=user_experience_impact --last=10
```

## 🎯 Best Practices

### **1. Специализация промптов:**
- Создавайте промпты под конкретные задачи
- Используйте четкие критерии оценки
- Добавляйте конкретные вопросы/чеклисты

### **2. Структурированные ответы:**
```json
// Для deep анализа используйте JSON формат
{
  "summary": "Краткое резюме",
  "details": "Детальный анализ", 
  "risks": ["риск1", "риск2"],
  "recommendations": ["рекомендация1", "рекомендация2"],
  "score": "числовая оценка или категория"
}
```

### **3. Командная работа:**
- Создавайте общие наборы промптов для команды
- Версионируйте промпты в git
- Документируйте назначение каждого промпта

## 🚀 Продвинутые техники

### **Conditional Logic в промптах:**
```
Если изменения касаются файлов auth* или security*:
- Повышенное внимание к безопасности
- Проверка на уязвимости аутентификации
- Анализ привилегий и доступов

Если изменения > 100 строк:
- Архитектурный анализ
- Оценка сложности
- Риск регрессий
```

### **Multi-language промпты:**
```
Для Python файлов: анализируй PEP8, type hints, docstrings
Для JavaScript: проверь ESLint rules, async/await usage
Для SQL: оцени производительность запросов, индексы
```

---

**🎉 Готово!** Теперь DRommage может анализировать коммиты exactly как вам нужно через полностью настраиваемые промпты.