import base64

from pytoniq_core import Cell
from pytoniq_core.crypto.crc import crc16


def cell_to_b64(cell: Cell) -> bytes:
    return base64.b64encode(cell.to_boc())


def b64_to_cell(b64: bytes) -> Cell:
    return Cell.one_from_boc(base64.b64decode(b64))


def get_method_id(method: str):
    return (int.from_bytes(crc16(method.encode()), byteorder='big') & 0xffff) | 0x10000


DEFAULT_CONFIG_BOC = 'te6ccgECRwEABFcAAgmbAAAAEAECAgEgAwQCASAaGwIBIAUGAgEgDxACASAHCAEBYg4CASAJCgEBSA0BASALAQEgDABAVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVVUAQDMzMzMzMzMzMzMzMzMzMzMzMzMzMzMzMzMzMzMzMzMzAEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABA5WdU+DQm9psJJnvYdqyXxEghNFt+JmvZVqe/v7mN81wBAWIRAgEgEhMAGsQAAAACAAAAAAAAAC4BAUgUAgEgFhcBAcAVALfQUy7nTs8AAAJwACrYn7aHDoYaZOELB7fIx0lsFfzu58bxcmSlH++c6KojdwX2/yWZOw/Zr08OxAx1OQZWjQc9ppdrOeJEc5dIgaEAAAAAD/////gAAAAAAAAABAEBIBgBASAZABRrRlU/EAQ7msoAACAAAQAAAACAAAAAIAAAAIAAAgEgHB0CASAvMAIBIB4fAgEgJSYCASAgIQEBSCQBASAiAQEgIwAMAZAAZABLADdwEQ2TFuwAByOG8m/BAACAEKdBpGJ4AAAAMAAIAE3QZgAAAAAAAAAAAAAAAIAAAAAAAAD6AAAAAAAAAfQAAAAAAAPQkEACASAnKAIBICssAQEgKQEBICoAlNEAAAAAAAAAZAAAAAAAD0JA3gAAAAAnEAAAAAAAAAAPQkAAAAAAAhYOwAAAAAAAACcQAAAAAAI0k0AAAAAABfXhAAAAAAA7msoAAJTRAAAAAAAAAGQAAAAAAAGGoN4AAAAAA+gAAAAAAAAAD0JAAAAAAAAPQkAAAAAAAAAnEAAAAAAAmJaAAAAAAAX14QAAAAAAO5rKAAEBIC0BASAuAFBdwwACAAAACAAAABAAAMMAHoSAAB6EgAI0k0DDAAAD6AAAE4gAACcQAFBdwwACAAAACAAAABAAAMMAHoSAAJiWgAExLQDDAAAD6AAAE4gAACcQAgFIMTICASA1NgEBIDMBASA0AELqAAAAAACYloAAAAAAJxAAAAAAAA9CQAAAAAGAAFVVVVUAQuoAAAAAAA9CQAAAAAAD6AAAAAAAAYagAAAAAYAAVVVVVQIBIDc4AQFYOwEBIDkBASA6ACTCAQAAAPoAAAD6AAAD6AAAABcAStkBAwAAB9AAAD6AAAAAAwAAAAgAAAAEACAAAAAgAAAAAgAAJxABAcA8AgEgPT4CASA/QABDv+6SYlD5XEfFuCmona5jYtGN4iWVOW5abGAZxXh4ab9iwAIBIEFCAEK/jVwCELNdrdqiGfrEWdug/e+x+uTpeg0Hl3Of4FDWlMoCAUhDRAIBWEVGAAPfcABBvvXr/85ThwN08RVEkXrXOpCNTrUaVASnRwrD2wNe3bMUAEG+2ZmZmZmZmZmZmZmZmZmZmZmZmZmZmZmZmZmZmZmZmZwAQb7c3f6FapnFy4B4QZnAdwvqMfKODXM49zeESA3vRM2QFA=='
